/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.builder.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.objectstyle.wolips.baseforplugins.AbstractBaseActivator;
import org.objectstyle.wolips.baseforplugins.util.FileUtilities;
import org.objectstyle.wolips.builder.BuilderPlugin;
import org.objectstyle.wolips.builder.internal.ResourceUtilities;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;

public abstract class BuildHelper
extends ResourceUtilities
implements IResourceDeltaVisitor,
IResourceVisitor {
    private IProject _project;
    private IPath _distPath;
    private List _buildTasks = new ArrayList();
    private int _buildWork = 0;
    private static final String APPINFO_PATH = "Contents";
    private static final String RESOURCE_PATH = "Resources";
    private static final String WEBRESOURCE_PATH = "WebServerResources";
    private static final String JAVA_PATH = "Resources/Java";

    public void reinitForNextBuild(IProject project) {
        this._project = project;
        this._distPath = new Path("dist");
        this._buildWork = 0;
        this._buildTasks = new ArrayList();
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        return this._visitResource(delta.getResource(), delta);
    }

    public boolean visit(IResource resource) throws CoreException {
        return this._visitResource(resource, null);
    }

    private boolean _visitResource(IResource res, IResourceDelta delta) throws CoreException {
        IPath resPath = res.getProjectRelativePath();
        if (this.getBuildPath().isPrefixOf(resPath) || this._distPath.isPrefixOf(resPath)) {
            return false;
        }
        boolean handleResourceChildren = this.handleResource(res, delta);
        return handleResourceChildren;
    }

    public synchronized void addTask(Buildtask task) {
        this._buildTasks.add(task);
        this._buildWork += task.amountOfWork();
    }

    public void executeTasks(IProgressMonitor progressMonitor) throws CoreException {
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(progressMonitor, 41);
        subProgressMonitor.beginTask("building ...", this._buildWork);
        for (Buildtask thisTask : this._buildTasks) {
            thisTask.doWork((IProgressMonitor)subProgressMonitor);
            subProgressMonitor.worked(thisTask.amountOfWork());
            if (!subProgressMonitor.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        subProgressMonitor.done();
    }

    protected AbstractBaseActivator _getLogger() {
        return BuilderPlugin.getDefault();
    }

    public abstract boolean handleResource(IResource var1, IResourceDelta var2) throws CoreException;

    public IProject getProject() {
        return this._project;
    }

    public IJavaProject getJavaProject() {
        return JavaCore.create((IProject)this.getProject());
    }

    public boolean isFramework() {
        ProjectAdapter project = (ProjectAdapter)this.getProject().getAdapter(ProjectAdapter.class);
        return project.isFramework();
    }

    public String getResultName() {
        String name = this.getProject().getName();
        if (this.isFramework()) {
            return name + ".framework";
        }
        return name + ".woa";
    }

    public IPath getBuildPath() {
        return this.getProject().getFullPath().append("build");
    }

    public IPath getResultPath() {
        return this.getBuildPath().append(this.getResultName());
    }

    public IPath getInfoPath() {
        if (this.isFramework()) {
            return this.getResultPath().append(RESOURCE_PATH);
        }
        return this.getResultPath().append(APPINFO_PATH);
    }

    public IPath _getResultPath() {
        if (this.isFramework()) {
            return this.getResultPath();
        }
        return this.getResultPath().append(APPINFO_PATH);
    }

    public IPath getResourceOutputPath() {
        return this._getResultPath().append(RESOURCE_PATH);
    }

    public IPath getJavaOutputPath() {
        return this._getResultPath().append(JAVA_PATH);
    }

    public IPath getWebResourceOutputPath() {
        return this._getResultPath().append(WEBRESOURCE_PATH);
    }

    public String getResourceName() {
        String result = "";
        if (!this.isFramework()) {
            result = result + "Contents/";
        }
        result = result + RESOURCE_PATH;
        return result;
    }

    public String getWebResourceName() {
        String result = "";
        if (!this.isFramework()) {
            result = result + "Contents/";
        }
        result = result + WEBRESOURCE_PATH;
        return result;
    }

    private IPath _appendSpecial(IPath destinationPrefix, IPath source) {
        int n;
        String[] segments = source.segments();
        for (int i = n = segments.length - 1; i >= 0; --i) {
            if (!segments[i].endsWith(".lproj")) continue;
            n = i;
            if (!segments[i].toLowerCase().startsWith("nonlocalized")) continue;
            n = i + 1;
        }
        IPath tmp = destinationPrefix;
        while (n < segments.length) {
            tmp = tmp.append(segments[n++]);
        }
        return tmp;
    }

    public IPath asResourcePath(IPath path, IResource res) {
        if (1 == res.getType() || 2 == res.getType()) {
            String lastSegment = path.lastSegment();
            if (-1 == path.toString().indexOf(".eomodeld/") && -1 == path.toString().indexOf(".wo/")) {
                return this._appendSpecial(this.getResourceOutputPath(), path);
            }
            String parentName = res.getParent().getName();
            if (parentName.endsWith(".wo") || parentName.endsWith(".eomodeld")) {
                return this._appendSpecial(this.getResourceOutputPath(), res.getParent().getProjectRelativePath()).append(lastSegment);
            }
        }
        return null;
    }

    public IPath asWebResourcePath(IPath path, IResource res) {
        if (1 == res.getType() || 2 == res.getType()) {
            return this._appendSpecial(this.getWebResourceOutputPath(), path);
        }
        return null;
    }

    public static class DeleteTask
    extends BuildtaskAbstract {
        IPath _path;
        String _msgPrefix;

        public DeleteTask(IPath path, String msgPrefix) {
            this._workAmount = 1000;
            this._path = path;
            this._msgPrefix = msgPrefix;
        }

        public void doWork(IProgressMonitor m) throws CoreException {
            if (this._path == null) {
                throw new OperationCanceledException("(deleting a null path wipes the workspace)");
            }
            boolean deletedUnderlyingFile = false;
            IResource res = ResourceUtilities.getWorkspaceRoot().findMember(this._path);
            if (res != null) {
                File file = res.getLocation().toFile();
                if (file.exists()) {
                    FileUtilities.deleteRecursively((File)file);
                    deletedUnderlyingFile = true;
                }
                res.refreshLocal(1, m);
            }
            if (!deletedUnderlyingFile) {
                IFile theFile = ResourceUtilities.getWorkspaceRoot().getFile(this._path);
                IFolder theFolder = ResourceUtilities.getWorkspaceRoot().getFolder(this._path);
                if (theFolder instanceof IFolder && theFolder.exists()) {
                    this._getLogger().debug((Object)(this._msgPrefix + " delete " + this._path));
                    m.subTask("delete " + this._path);
                    theFolder.delete(true, true, null);
                } else if (theFile != null && theFile.exists()) {
                    this._getLogger().debug((Object)(this._msgPrefix + " delete " + this._path));
                    m.subTask("delete " + this._path);
                    theFile.delete(true, true, null);
                }
            }
        }
    }

    public static class CopyTask
    extends BuildtaskAbstract {
        IResource _res;
        IPath _dest;
        String _msgPrefix;

        public CopyTask(IResource res, IPath destination, String msgPrefix) {
            this._res = res;
            this._dest = destination;
            this._msgPrefix = msgPrefix;
            this._workAmount = 1000;
        }

        public void doWork(IProgressMonitor m) throws CoreException {
            String error = null;
            try {
                int n = this._dest.segmentCount() - 3;
                IPath dstShortened = this._dest;
                if (n > 0) {
                    dstShortened = this._dest.removeFirstSegments(n);
                }
                m.subTask("create " + dstShortened);
                ResourceUtilities.copyDerived(this._res, this._dest, m);
                this._getLogger().debug((Object)("copy " + this._res + " -> " + this._dest));
            }
            catch (CoreException up) {
                error = " *failed* to copy resource " + this._res + " -> " + this._dest + " (" + up.getMessage() + ")";
                this._getLogger().debug((Object)(this._msgPrefix + error), (Throwable)up);
            }
            catch (RuntimeException up) {
                error = " *failed* to copy resource " + this._res + " -> " + this._dest + " (" + up.getMessage() + ")";
                this._getLogger().log((Object)(this._msgPrefix + error), (Throwable)up);
            }
            if (null == error) {
                this._res.deleteMarkers("org.objectstyle.wolips.projectbuild.problem", true, 0);
            } else {
                ResourceUtilities.markResource(this._res, "org.objectstyle.wolips.projectbuild.problem", 2, error, this._dest.toString());
            }
        }
    }

    public static abstract class BuildtaskAbstract
    implements Buildtask {
        protected int _workAmount = 1000;

        public int amountOfWork() {
            return this._workAmount;
        }

        protected AbstractBaseActivator _getLogger() {
            return BuilderPlugin.getDefault();
        }
    }

    public static interface Buildtask {
        public int amountOfWork();

        public void doWork(IProgressMonitor var1) throws CoreException;
    }
}

