/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.htmlpreview.editor;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Stack;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.internal.RenderContext;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TagDelegate {
    public abstract void renderNode(IWodElement var1, FuzzyXMLElement var2, RenderContext var3, StringBuffer var4, StringBuffer var5, Stack<WodParserCache> var6, Stack<FuzzyXMLNode> var7);

    public void reset() {
    }

    public static void appendHtmlBindings(StringBuffer htmlBuffer, IWodElement wodElement) {
        IWodBinding styleBinding;
        IWodBinding classBinding;
        IWodBinding idBinding = wodElement.getBindingNamed("id");
        if (idBinding != null && !idBinding.isKeyPath()) {
            htmlBuffer.append(" id = \"" + idBinding.getValue() + "\"");
        }
        if ((classBinding = wodElement.getBindingNamed("class")) != null && !classBinding.isKeyPath()) {
            htmlBuffer.append(" class = \"" + classBinding.getValue() + "\"");
        }
        if ((styleBinding = wodElement.getBindingNamed("style")) != null && !styleBinding.isKeyPath()) {
            htmlBuffer.append(" style = \"" + styleBinding.getValue() + "\"");
        }
    }

    public static String getResourceUrl(String frameworkBindingName, String filenameBindingName, String hrefBindingName, IWodElement wodElement, Stack<WodParserCache> caches) {
        IWodBinding hrefBinding = wodElement.getBindingNamed(hrefBindingName);
        String resourceUrl = hrefBinding != null && !hrefBinding.isKeyPath() ? hrefBinding.getValue() : TagDelegate.getResourceUrl(frameworkBindingName, filenameBindingName, wodElement, caches);
        return resourceUrl;
    }

    public static String getResourceUrl(String frameworkBindingName, String filenameBindingName, IWodElement wodElement, Stack<WodParserCache> caches) {
        File webserverResourcesFolder = null;
        IWodBinding frameworkBinding = wodElement.getBindingNamed(frameworkBindingName);
        String framework = null;
        if (frameworkBinding == null) {
            framework = "app";
        } else if (!frameworkBinding.isKeyPath()) {
            framework = frameworkBinding.getValue();
        }
        if (framework != null) {
            framework = framework.replaceAll("\"", "");
            IJavaProject javaProject = caches.peek().getJavaProject();
            if ("app".equals(framework)) {
                webserverResourcesFolder = new File(javaProject.getProject().getLocation().toFile(), "WebServerResources");
            } else {
                try {
                    IClasspathEntry[] classpathEntries;
                    for (IClasspathEntry classpathEntry : classpathEntries = javaProject.getResolvedClasspath(true)) {
                        if (classpathEntry.getEntryKind() != 2 && classpathEntry.getEntryKind() != 3 || !classpathEntry.getPath().segment(0).equals(framework)) continue;
                        File projectFolder = new File(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile(), classpathEntry.getPath().segment(0));
                        webserverResourcesFolder = new File(projectFolder, "WebServerResources");
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
        String resourceUrl = null;
        if (webserverResourcesFolder != null) {
            File webserverResourceFile = null;
            IWodBinding filenameBinding = wodElement.getBindingNamed(filenameBindingName);
            if (filenameBinding != null && !filenameBinding.isKeyPath()) {
                String filename = filenameBinding.getValue().replaceAll("\"", "");
                webserverResourceFile = new File(webserverResourcesFolder, filename);
            }
            if (webserverResourceFile != null) {
                try {
                    resourceUrl = webserverResourceFile.getAbsoluteFile().toURL().toExternalForm();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        }
        if (resourceUrl == null) {
            resourceUrl = "MISSING";
        }
        return resourceUrl;
    }
}

