/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.objectstyle.wolips.baseforuiplugins.utils.WorkbenchUtilities;
import org.objectstyle.wolips.core.CorePlugin;
import org.objectstyle.wolips.core.resources.IWOLipsResource;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentWOLipsResource
implements IWOLipsResource {
    public static String[] EXTENSIONS = new String[]{"java", "groovy", "wo", "html", "wod", "woo", "api"};
    private IResource _resource;

    public ComponentWOLipsResource(IResource resource) {
        this._resource = resource;
    }

    @Override
    public List<IResource> getRelatedResources() {
        LinkedList<IResource> list = new LinkedList<IResource>();
        try {
            String fileName = this._resource.getName();
            String extension = this._resource.getFileExtension();
            int length = fileName.length() - extension.length() - 1;
            if (length > 0) {
                fileName = fileName.substring(0, length);
                LocalizedComponentsLocateResult results = LocatePlugin.getDefault().getLocalizedComponentsLocateResult(this._resource);
                list.addAll(Arrays.asList(results.getResources()));
                if (results.getFirstHtmlFile() != null) {
                    list.add((IResource)results.getFirstHtmlFile());
                }
                if (results.getFirstWodFile() != null) {
                    list.add((IResource)results.getFirstWodFile());
                }
                if (results.getFirstWooFile() != null) {
                    list.add((IResource)results.getFirstWooFile());
                }
            }
        }
        catch (Exception e) {
            CorePlugin.getDefault().log(e);
        }
        return list;
    }

    @Override
    public IResource getUnderlyingResource() {
        return this._resource;
    }

    @Override
    public void open() {
        String extension = this._resource.getFileExtension();
        if ("wo".equals(extension)) {
            String fileName = this._resource.getName();
            IFile wodFile = (IFile)((IFolder)this._resource).findMember((fileName = fileName.substring(0, fileName.length() - extension.length() - 1)) + ".wod");
            if (wodFile != null) {
                WorkbenchUtilities.open((IFile)wodFile, (String)"org.objectstyle.wolips.componenteditor.ComponentEditor");
            }
        } else {
            WorkbenchUtilities.open((IFile)((IFile)this._resource), null);
        }
    }

    public int hashCode() {
        return this._resource.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof IWOLipsResource && this._resource.equals((Object)((IWOLipsResource)obj).getUnderlyingResource());
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + ": " + this._resource + "]";
    }

    public static boolean isComponentExtension(String extension) {
        if (extension != null) {
            String lowercaseExtension = extension.toLowerCase();
            for (String componentExtension : EXTENSIONS) {
                if (!lowercaseExtension.equals(componentExtension)) continue;
                return true;
            }
        }
        return false;
    }
}

