/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.internal.build;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.objectstyle.wolips.core.resources.internal.build.BuilderWrapper;
import org.objectstyle.wolips.core.resources.internal.pattern.PatternList;
import org.objectstyle.wolips.core.resources.internal.types.project.ProjectPatternsets;
import org.objectstyle.wolips.core.resources.types.folder.IDotApplicationAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotFrameworkAdapter;

public class AbstractBuildVisitor {
    public static int WO_RESOURCE_TYPE_IGNORE = 0;
    public static int WO_RESOURCE_TYPE_RESOURCE = 1;
    public static int WO_RESOURCE_TYPE_WEB_SERVER_RESOURCE = 2;
    public static int WO_RESOURCE_TYPE_CLASS = 3;
    public static int WO_RESOURCE_TYPE_CLASSPATH = 4;
    public static int WO_RESOURCE_TYPE_OTHER = 5;
    public static int WO_RESOURCE_TYPE_SOURCE = 6;
    private IProgressMonitor myProgressMonitor;
    private BuilderWrapper[] myBuilderWrappers;
    private ProjectPatternsets projectPatternsets;
    private Map myBuildCache;
    private static final PatternList DEFAULT_EXCLUDE_MATCHER = new PatternList(new String[]{"**/.svn", "**/.svn/**", "**/CVS", "**.*~/**", "**/CVS/**", "**/build/**", "**/dist/**"});

    public AbstractBuildVisitor(BuilderWrapper[] _builderWrappers, IProgressMonitor _progressMonitor, Map _buildCache) {
        this.myBuilderWrappers = _builderWrappers;
        this.myProgressMonitor = _progressMonitor;
        this.myBuildCache = _buildCache;
    }

    public Map getBuildCache() {
        return this.myBuildCache;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.myProgressMonitor;
    }

    public boolean isCanceled() {
        return this.myProgressMonitor != null && this.myProgressMonitor.isCanceled();
    }

    public BuilderWrapper[] getBuilderWrappers() {
        return this.myBuilderWrappers;
    }

    public void buildStarted(IProject project) {
        this.projectPatternsets = new ProjectPatternsets(project);
    }

    public void visitingDone() {
        this.projectPatternsets = null;
    }

    public int getWoResourceType(IResource _resource) {
        String[] strings;
        if (_resource == null || _resource.isDerived()) {
            return WO_RESOURCE_TYPE_IGNORE;
        }
        if (_resource.getType() == 2) {
            if ("dist".equals(_resource.getName())) {
                return WO_RESOURCE_TYPE_IGNORE;
            }
            IDotFrameworkAdapter dotFrameworkAdapter = (IDotFrameworkAdapter)_resource.getAdapter(IDotFrameworkAdapter.class);
            if (dotFrameworkAdapter != null) {
                return WO_RESOURCE_TYPE_IGNORE;
            }
            IDotApplicationAdapter dotApplicationAdapter = (IDotApplicationAdapter)_resource.getAdapter(IDotApplicationAdapter.class);
            if (dotApplicationAdapter != null) {
                return WO_RESOURCE_TYPE_IGNORE;
            }
        }
        int woResourceType = DEFAULT_EXCLUDE_MATCHER.matches(strings = this.toProjectRelativePaths(_resource)) ? WO_RESOURCE_TYPE_IGNORE : (!this.projectPatternsets.getClassesExcludeMatcher().match(strings) && this.projectPatternsets.getClassesIncludeMatcher().match(strings) ? WO_RESOURCE_TYPE_CLASS : (!this.projectPatternsets.getResourcesExcludeMatcher().match(strings) && this.projectPatternsets.getResourcesIncludeMatcher().match(strings) ? WO_RESOURCE_TYPE_RESOURCE : (!this.projectPatternsets.getWoappResourcesExcludeMatcher().match(strings) && this.projectPatternsets.getWoappResourcesIncludeMatcher().match(strings) ? WO_RESOURCE_TYPE_WEB_SERVER_RESOURCE : (_resource.getType() == 1 && _resource.getName().endsWith(".java") ? WO_RESOURCE_TYPE_SOURCE : WO_RESOURCE_TYPE_OTHER))));
        if (_resource.getType() == 1 && _resource.getName().equals(".classpath")) {
            woResourceType = WO_RESOURCE_TYPE_CLASSPATH;
        }
        return woResourceType;
    }

    private String[] toProjectRelativePaths(IResource resource) {
        String[] returnValue = null;
        if (resource.getParent().getType() != 8) {
            String string = null;
            if (resource.getType() != 2) {
                returnValue = new String[1];
            } else {
                returnValue = new String[2];
                returnValue[0] = string = "/" + resource.getName() + "/";
            }
        } else {
            returnValue = new String[1];
        }
        IPath path = resource.getProjectRelativePath();
        String string = path.toString();
        if (returnValue.length == 2) {
            returnValue[1] = string;
        } else {
            returnValue[0] = string;
        }
        return returnValue;
    }
}

