/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.internal.types;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.objectstyle.wolips.core.resources.internal.types.LocalizedPath;
import org.objectstyle.wolips.core.resources.types.ILocalizedPath;
import org.objectstyle.wolips.core.resources.types.IPBDotProjectOwner;
import org.objectstyle.wolips.core.resources.types.IResourceType;
import org.objectstyle.wolips.core.resources.types.folder.IDotSubprojAdapter;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;

public abstract class AbstractResourceAdapter
implements IResourceType {
    private IResource underlyingResource;

    public AbstractResourceAdapter(IResource underlyingResource) {
        this.underlyingResource = underlyingResource;
    }

    public IResource getUnderlyingResource() {
        return this.underlyingResource;
    }

    public IPBDotProjectOwner getPBDotProjectOwner() {
        return this.getPBDotProjectOwner(this.getUnderlyingResource());
    }

    public IPBDotProjectOwner getPBDotProjectOwner(IResource resource) {
        IContainer parent = null;
        parent = resource instanceof IFile ? resource.getParent() : (IContainer)resource;
        if (!(parent instanceof IProject)) {
            do {
                IDotSubprojAdapter subprojectAdapter;
                if ((subprojectAdapter = (IDotSubprojAdapter)parent.getAdapter(IDotSubprojAdapter.class)) == null) continue;
                return subprojectAdapter;
            } while (!((parent = parent.getParent()) instanceof IProject));
        }
        if (this instanceof ProjectAdapter) {
            return (IPBDotProjectOwner)((Object)this);
        }
        ProjectAdapter projectAdapter = (ProjectAdapter)resource.getProject().getAdapter(ProjectAdapter.class);
        return projectAdapter;
    }

    public ILocalizedPath localizedRelativeResourcePath(IPBDotProjectOwner pbDotProjectOwner, IResource resource) {
        String resourcePath;
        if (pbDotProjectOwner.getUnderlyingResource().equals((Object)resource.getParent())) {
            resourcePath = resource.getName();
        } else if (pbDotProjectOwner.getUnderlyingResource().getFullPath().matchingFirstSegments(resource.getFullPath()) == pbDotProjectOwner.getUnderlyingResource().getFullPath().segmentCount()) {
            resourcePath = resource.getFullPath().removeFirstSegments(pbDotProjectOwner.getUnderlyingResource().getFullPath().matchingFirstSegments(resource.getFullPath())).toString();
        } else {
            resourcePath = resource.getProjectRelativePath().toString();
            for (int i = 0; i < pbDotProjectOwner.getUnderlyingResource().getProjectRelativePath().segmentCount() - 1; ++i) {
                resourcePath = "../" + resourcePath;
            }
        }
        return new LocalizedPath(resourcePath, null);
    }
}

