/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.internal.types.file;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.objectstyle.woenvironment.pb.PBProject;
import org.objectstyle.wolips.core.CorePlugin;
import org.objectstyle.wolips.core.resources.internal.types.file.AbstractFileAdapter;
import org.objectstyle.wolips.core.resources.types.ILocalizedPath;
import org.objectstyle.wolips.core.resources.types.file.IPBDotProjectAdapter;
import org.objectstyle.wolips.core.resources.types.folder.IDotSubprojAdapter;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBDotProjectAdapter
extends AbstractFileAdapter
implements IPBDotProjectAdapter {
    private static final String DefaultLocalFrameworkSearch = "$(NEXT_ROOT)$(LOCAL_LIBRARY_DIR)/Frameworks";
    private boolean saveRequired = false;
    private boolean rebuildRequired = false;
    private PBProject pbProject;

    public PBDotProjectAdapter(IFile underlyingFile) {
        super(underlyingFile);
        this.initPBProject();
    }

    @Override
    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    public void save(IProgressMonitor monitor) {
        if (this.pbProject == null) {
            return;
        }
        if (!this.saveRequired) {
            return;
        }
        this.saveRequired = false;
        try {
            this.pbProject.saveChanges();
            this.getUnderlyingFile().refreshLocal(0, monitor);
        }
        catch (Exception up) {
            CorePlugin.getDefault().debug(this.getClass().getName() + "Error while saving PB.project: " + this.getUnderlyingFile(), up);
        }
    }

    private ProjectAdapter getProjectAdapter() {
        IProject project = this.getUnderlyingFile().getProject();
        ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
        return projectAdapter;
    }

    private void initPBProject() {
        ProjectAdapter projectAdapter = this.getProjectAdapter();
        try {
            this.pbProject = new PBProject(this.getUnderlyingFile().getLocation().toOSString(), projectAdapter.isFramework());
            this.pbProject.update();
            IFile underlyingFile = this.getUnderlyingFile();
            if (!underlyingFile.exists()) {
                this.rebuildRequired = true;
                this.pbProject.saveChanges();
                try {
                    underlyingFile.refreshLocal(1, null);
                }
                catch (CoreException e) {
                    CorePlugin.getDefault().debug(this.getClass().getName() + "Error while refreshing PB.project: " + underlyingFile, e);
                }
            }
            this.addLocalFrameworkSectionToPBProject();
            this.syncProjectName();
        }
        catch (Exception e) {
            CorePlugin.getDefault().debug(this.getClass().getName() + "Error while loading PB.project: " + this.getUnderlyingFile(), e);
        }
    }

    @Override
    public void cleanTables() {
        this.pbProject.setClasses(new ArrayList());
        this.pbProject.setWebServerResources(new ArrayList());
        this.pbProject.setWoAppResources(new ArrayList());
        this.pbProject.setWoComponents(new ArrayList());
        this.saveRequired = true;
    }

    public void syncProjectName() {
        String projectName = this.getUnderlyingResource().getProject().getName();
        if (!projectName.equals(this.pbProject.getProjectName())) {
            this.pbProject.setProjectName(projectName);
            this.saveRequired = true;
        }
    }

    public void addLocalFrameworkSectionToPBProject() {
        List actualFrameworkSearch = this.pbProject.getFrameworkSearch();
        if (actualFrameworkSearch == null) {
            this.pbProject.setFrameworkSearch(new ArrayList());
            actualFrameworkSearch = this.pbProject.getFrameworkSearch();
        }
        if (!actualFrameworkSearch.contains(DefaultLocalFrameworkSearch)) {
            actualFrameworkSearch.add(DefaultLocalFrameworkSearch);
        }
    }

    @Override
    public void save() {
        if (this.pbProject != null && this.saveRequired) {
            try {
                this.pbProject.saveChanges();
                this.saveRequired = false;
            }
            catch (Exception e) {
                CorePlugin.getDefault().debug(this.getClass().getName() + " Error while saving PB.project: " + this.getUnderlyingFile(), e);
            }
        }
    }

    private void addToListIfListNotContains(List<Object> list, Object object) {
        if (!list.contains(object)) {
            list.add(object);
            this.saveRequired = true;
        }
    }

    private void removeFromListIfListNotContains(List list, Object object) {
        if (list != null && list.contains(object)) {
            list.remove(object);
            this.saveRequired = true;
        }
    }

    @Override
    public void addClass(ILocalizedPath localizedPath) {
        if (this.pbProject == null) {
            return;
        }
        List classes = this.pbProject.getClasses();
        if (classes == null) {
            this.pbProject.setClasses(new ArrayList());
            classes = this.pbProject.getClasses();
        }
        this.addToListIfListNotContains(classes, localizedPath.getResourcePath());
    }

    @Override
    public void removeClass(ILocalizedPath localizedPath) {
        if (this.pbProject == null) {
            return;
        }
        this.removeFromListIfListNotContains(this.pbProject.getClasses(), localizedPath.getResourcePath());
    }

    @Override
    public void addWoComponent(ILocalizedPath localizedPath) {
        if (this.pbProject == null) {
            return;
        }
        List woComponents = this.pbProject.getWoComponents(localizedPath.getLanguage());
        if (woComponents == null) {
            this.pbProject.setWoComponents(new ArrayList(), localizedPath.getLanguage());
            woComponents = this.pbProject.getWoComponents(localizedPath.getLanguage());
        }
        this.addToListIfListNotContains(woComponents, localizedPath.getResourcePath());
    }

    @Override
    public void removeWoComponent(ILocalizedPath localizedPath) {
        if (this.pbProject == null) {
            return;
        }
        this.removeFromListIfListNotContains(this.pbProject.getWoComponents(localizedPath.getLanguage()), localizedPath.getResourcePath());
    }

    @Override
    public void addWoappResource(ILocalizedPath localizedPath) {
        if (this.pbProject == null) {
            return;
        }
        List woAppResourcesComponents = this.pbProject.getWoAppResources(localizedPath.getLanguage());
        if (woAppResourcesComponents == null) {
            this.pbProject.setWoAppResources(new ArrayList(), localizedPath.getLanguage());
            woAppResourcesComponents = this.pbProject.getWoAppResources(localizedPath.getLanguage());
        }
        this.addToListIfListNotContains(woAppResourcesComponents, localizedPath.getResourcePath());
    }

    @Override
    public void removeWoappResource(ILocalizedPath localizedPath) {
        if (this.pbProject == null) {
            return;
        }
        this.removeFromListIfListNotContains(this.pbProject.getWoAppResources(localizedPath.getLanguage()), localizedPath.getResourcePath());
    }

    @Override
    public void addWebServerResource(ILocalizedPath localizedPath) {
        if (this.pbProject == null) {
            return;
        }
        List wsResourcesComponents = this.pbProject.getWebServerResources(localizedPath.getLanguage());
        if (wsResourcesComponents == null) {
            this.pbProject.setWebServerResources(new ArrayList(), localizedPath.getLanguage());
            wsResourcesComponents = this.pbProject.getWebServerResources(localizedPath.getLanguage());
        }
        this.addToListIfListNotContains(wsResourcesComponents, localizedPath.getResourcePath());
    }

    @Override
    public void removeWebServerResource(ILocalizedPath localizedPath) {
        if (this.pbProject == null) {
            return;
        }
        this.removeFromListIfListNotContains(this.pbProject.getWebServerResources(localizedPath.getLanguage()), localizedPath.getResourcePath());
    }

    @Override
    public void updateFrameworkNames(List frameworkNames) {
        int newNamesLength;
        if (this.pbProject == null) {
            return;
        }
        List frameworks = this.pbProject.getFrameworks();
        if (frameworks == null) {
            this.pbProject.setFrameworks(new ArrayList());
            frameworks = this.pbProject.getFrameworks();
        }
        boolean set = false;
        int existingNamesLength = frameworks.size();
        if (existingNamesLength != (newNamesLength = frameworkNames.size())) {
            set = true;
        } else {
            for (int i = 0; i < newNamesLength; ++i) {
                String currentName = (String)frameworkNames.get(i);
                if (frameworks.contains(currentName)) continue;
                set = true;
                break;
            }
        }
        if (set) {
            this.pbProject.setFrameworks(frameworkNames);
            this.saveRequired = true;
        }
    }

    @Override
    public void addSubproject(IDotSubprojAdapter dotSubprojAdapter) {
        if (this.pbProject == null) {
            return;
        }
        List subProjects = this.pbProject.getSubprojects();
        if (subProjects == null) {
            this.pbProject.setSubprojects(new ArrayList());
            subProjects = this.pbProject.getSubprojects();
        }
        this.addToListIfListNotContains(subProjects, dotSubprojAdapter.getUnderlyingFolder().getName());
    }

    @Override
    public void removeSubproject(IDotSubprojAdapter dotSubprojAdapter) {
        if (this.pbProject == null) {
            return;
        }
        this.removeFromListIfListNotContains(this.pbProject.getSubprojects(), dotSubprojAdapter.getUnderlyingFolder().getName());
    }
}

