/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.resources.internal.types.project;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.objectstyle.wolips.core.CorePlugin;
import org.objectstyle.wolips.core.resources.pattern.PatternsetMatcher;
import org.objectstyle.wolips.core.resources.pattern.PatternsetWriter;
import org.objectstyle.wolips.core.resources.types.ILocalizedPath;
import org.objectstyle.wolips.core.resources.types.IPBDotProjectOwner;
import org.objectstyle.wolips.core.resources.types.IResourceType;
import org.objectstyle.wolips.core.resources.types.project.IProjectPatternsets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectPatternsets
implements IProjectPatternsets,
IResourceType {
    public static final String EXTENSION = "patternset";
    public static final String ANT_FOLDER_NAME = "woproject";
    protected static final String LEGACY_ANT_FOLDER_NAME = "ant";
    private Map<IFile, Long> _modificationStamps;
    private PatternsetMatcher woappResourcesIncludeMatcher;
    private PatternsetMatcher woappResourcesExcludeMatcher;
    private PatternsetMatcher resourcesIncludeMatcher;
    private PatternsetMatcher resourcesExcludeMatcher;
    private PatternsetMatcher classesIncludeMatcher;
    private PatternsetMatcher classesExcludeMatcher;
    private static final PatternsetMatcher DEFAULT_EXCLUDE_MATCHER = new PatternsetMatcher(new String[]{"**/.svn", "**/.svn/**", "**/CVS", "**/*.eomodeld~", "**/*.eomodeld~/**", "**/CVS/**", "**/build/**", "**/dist/**"});
    private IProject project;

    public ProjectPatternsets(IProject project) {
        this.project = project;
        this._modificationStamps = new HashMap<IFile, Long>();
    }

    protected boolean useCachedVersion(IFile file) {
        Long cachedModificationStamp = this._modificationStamps.get(file);
        long modificationStamp = file.getModificationStamp();
        boolean useCachedVersion = true;
        if (cachedModificationStamp == null || modificationStamp > cachedModificationStamp) {
            this._modificationStamps.put(file, modificationStamp);
            useCachedVersion = false;
        }
        return useCachedVersion;
    }

    private String[] getWSResourcesIncludeStringsDefault() {
        return new String[]{"WebServerResources/**/*"};
    }

    private String[] getWSResourcesExcludeStringsDefault() {
        return new String[0];
    }

    private String[] getResourcesIncludeStringsDefault() {
        return new String[]{"Components/**/*.wo/**/*", "Components/**/*.api", "Resources/**/*"};
    }

    private String[] getResourcesExcludeStringsDefault() {
        return new String[]{"Resources/**/*.eomodeld~/**"};
    }

    private String[] getClassesIncludeStringsDefault() {
        return new String[]{"**/*.class", "*.properties"};
    }

    private String[] getClassesExcludeStringsDefault() {
        return new String[]{"build.properties"};
    }

    public void createAntFolder() {
        if (this.getAntFolder().exists()) {
            return;
        }
        IWorkspaceRunnable operation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                String string = ProjectPatternsets.this.getAntFolder().getLocation().toOSString();
                File file = new File(string);
                file.mkdirs();
                try {
                    ProjectPatternsets.this.getAntFolder().refreshLocal(0, monitor);
                }
                catch (CoreException e) {
                    CorePlugin.getDefault().log(e);
                }
            }
        };
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            workspace.run(operation, (ISchedulingRule)this.getIProject(), 1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CorePlugin.getDefault().log(e);
        }
    }

    public IFolder getAntFolder() {
        IFolder folder = this.getIProject().getFolder(LEGACY_ANT_FOLDER_NAME);
        if (!folder.exists()) {
            folder = this.getIProject().getFolder(ANT_FOLDER_NAME);
        }
        return folder;
    }

    public PatternsetMatcher getClassesExcludeMatcher() {
        IFile classesExcludePatternset = this.getAntFolder().getFile("classes.exclude.patternset");
        if (this.classesExcludeMatcher != null && this.useCachedVersion(classesExcludePatternset)) {
            return this.classesExcludeMatcher;
        }
        this.createAntFolder();
        PatternsetWorkspaceRunnable patternsetWorkspaceRunnable = new PatternsetWorkspaceRunnable(classesExcludePatternset, this.getClassesExcludeStringsDefault());
        patternsetWorkspaceRunnable.run();
        this.classesExcludeMatcher = patternsetWorkspaceRunnable.getMatcher();
        return this.classesExcludeMatcher;
    }

    public PatternsetMatcher getClassesIncludeMatcher() {
        IFile classesIncludePatternset = this.getAntFolder().getFile("classes.include.patternset");
        if (this.classesIncludeMatcher != null && this.useCachedVersion(classesIncludePatternset)) {
            return this.classesIncludeMatcher;
        }
        this.createAntFolder();
        PatternsetWorkspaceRunnable patternsetWorkspaceRunnable = new PatternsetWorkspaceRunnable(classesIncludePatternset, this.getClassesIncludeStringsDefault());
        patternsetWorkspaceRunnable.run();
        this.classesIncludeMatcher = patternsetWorkspaceRunnable.getMatcher();
        return this.classesIncludeMatcher;
    }

    public PatternsetMatcher getResourcesExcludeMatcher() {
        IFile resourcesExcludePatternset = this.getAntFolder().getFile("resources.exclude.patternset");
        if (this.resourcesExcludeMatcher != null && this.useCachedVersion(resourcesExcludePatternset)) {
            return this.resourcesExcludeMatcher;
        }
        this.createAntFolder();
        PatternsetWorkspaceRunnable patternsetWorkspaceRunnable = new PatternsetWorkspaceRunnable(resourcesExcludePatternset, this.getResourcesExcludeStringsDefault());
        patternsetWorkspaceRunnable.run();
        this.resourcesExcludeMatcher = patternsetWorkspaceRunnable.getMatcher();
        return this.resourcesExcludeMatcher;
    }

    public PatternsetMatcher getResourcesIncludeMatcher() {
        IFile resourcesIncludePatternset = this.getAntFolder().getFile("resources.include.patternset");
        if (this.resourcesIncludeMatcher != null && this.useCachedVersion(resourcesIncludePatternset)) {
            return this.resourcesIncludeMatcher;
        }
        this.createAntFolder();
        PatternsetWorkspaceRunnable patternsetWorkspaceRunnable = new PatternsetWorkspaceRunnable(resourcesIncludePatternset, this.getResourcesIncludeStringsDefault());
        patternsetWorkspaceRunnable.run();
        this.resourcesIncludeMatcher = patternsetWorkspaceRunnable.getMatcher();
        return this.resourcesIncludeMatcher;
    }

    public PatternsetMatcher getWoappResourcesExcludeMatcher() {
        IFile wsresourcesExcludePatternset = this.getAntFolder().getFile("wsresources.exclude.patternset");
        if (this.woappResourcesExcludeMatcher != null && this.useCachedVersion(wsresourcesExcludePatternset)) {
            return this.woappResourcesExcludeMatcher;
        }
        this.createAntFolder();
        PatternsetWorkspaceRunnable patternsetWorkspaceRunnable = new PatternsetWorkspaceRunnable(wsresourcesExcludePatternset, this.getWSResourcesExcludeStringsDefault());
        patternsetWorkspaceRunnable.run();
        this.woappResourcesExcludeMatcher = patternsetWorkspaceRunnable.getMatcher();
        return this.woappResourcesExcludeMatcher;
    }

    public PatternsetMatcher getWoappResourcesIncludeMatcher() {
        IFile wsresourcesIncludePatternset = this.getAntFolder().getFile("wsresources.include.patternset");
        if (this.woappResourcesIncludeMatcher != null && this.useCachedVersion(wsresourcesIncludePatternset)) {
            return this.woappResourcesIncludeMatcher;
        }
        this.createAntFolder();
        PatternsetWorkspaceRunnable patternsetWorkspaceRunnable = new PatternsetWorkspaceRunnable(wsresourcesIncludePatternset, this.getWSResourcesIncludeStringsDefault());
        patternsetWorkspaceRunnable.run();
        this.woappResourcesIncludeMatcher = patternsetWorkspaceRunnable.getMatcher();
        return this.woappResourcesIncludeMatcher;
    }

    @Override
    public boolean matchesClassesPattern(IResource resource) {
        String relativePath = resource.getProjectRelativePath().toString();
        return !this.getClassesExcludeMatcher().match(relativePath) && !DEFAULT_EXCLUDE_MATCHER.match(relativePath) && this.getClassesIncludeMatcher().match(relativePath);
    }

    @Override
    public boolean matchesWOAppResourcesPattern(IResource resource) {
        String relativePath = resource.getProjectRelativePath().toString();
        return !this.getWoappResourcesExcludeMatcher().match(relativePath) && !DEFAULT_EXCLUDE_MATCHER.match(relativePath) && this.getWoappResourcesIncludeMatcher().match(relativePath);
    }

    @Override
    public boolean matchesResourcesPattern(IResource resource) {
        String relativePath = resource.getProjectRelativePath().toString();
        boolean matches = !this.getResourcesExcludeMatcher().match(relativePath) && !DEFAULT_EXCLUDE_MATCHER.match(relativePath) && this.getResourcesIncludeMatcher().match(relativePath);
        return matches;
    }

    @Override
    public void setUpPatternsetFiles() {
        this.getClassesExcludeMatcher();
        this.getClassesIncludeMatcher();
        this.getResourcesExcludeMatcher();
        this.getResourcesIncludeMatcher();
        this.getWoappResourcesExcludeMatcher();
        this.getWoappResourcesIncludeMatcher();
    }

    @Override
    public void releasePatternsetCache() {
        this.woappResourcesIncludeMatcher = null;
        this.woappResourcesExcludeMatcher = null;
        this.resourcesIncludeMatcher = null;
        this.resourcesExcludeMatcher = null;
        this.classesIncludeMatcher = null;
        this.classesExcludeMatcher = null;
    }

    @Override
    public boolean hasClassesIncludePattern(String string) {
        return this.getClassesIncludeMatcher().hasPattern(string);
    }

    @Override
    public boolean hasClassesExcludePattern(String string) {
        return this.getClassesExcludeMatcher().hasPattern(string);
    }

    @Override
    public boolean hasWOAppResourcesIncludePattern(String string) {
        return this.getWoappResourcesIncludeMatcher().hasPattern(string);
    }

    @Override
    public boolean hasWOAppResourcesExcludePattern(String string) {
        return this.getWoappResourcesExcludeMatcher().hasPattern(string);
    }

    @Override
    public boolean hasResourcesIncludePattern(String string) {
        return this.getResourcesIncludeMatcher().hasPattern(string);
    }

    @Override
    public boolean hasResourcesExcludePattern(String string) {
        return this.getResourcesExcludeMatcher().hasPattern(string);
    }

    @Override
    public void addClassesIncludePattern(String string) {
        List<String> list = this.loadClassesIncludePatternSet();
        if (!list.contains(string)) {
            list.add(string);
            this.saveClassesIncludePatternList(list);
            this.removeClassesExcludePattern(string);
        }
    }

    public void removeClassesIncludePattern(String string) {
        List<String> patterns = this.loadClassesIncludePatternSet();
        if (patterns.remove(string)) {
            this.saveClassesIncludePatternList(patterns);
        }
    }

    protected List<String> loadClassesIncludePatternSet() {
        PatternsetMatcher patternsetMatcher = this.getClassesIncludeMatcher();
        String[] pattern = patternsetMatcher.getPattern();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < pattern.length; ++i) {
            list.add(pattern[i]);
        }
        return list;
    }

    protected void saveClassesIncludePatternList(List<String> list) {
        IFile classesIncludePatternset = this.getAntFolder().getFile("classes.include.patternset");
        PatternsetWriter.create(classesIncludePatternset, list.toArray(new String[list.size()]));
        this.classesIncludeMatcher = new PatternsetMatcher(classesIncludePatternset);
        try {
            classesIncludePatternset.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CorePlugin.getDefault().log(e);
        }
    }

    @Override
    public void addClassesExcludePattern(String string) {
        List<String> list = this.loadClassesExcludePatternList();
        if (!list.contains(string)) {
            list.add(string);
            this.saveClassesExcludePatternList(list);
            this.removeClassesIncludePattern(string);
        }
    }

    public void removeClassesExcludePattern(String string) {
        List<String> list = this.loadClassesExcludePatternList();
        if (list.remove(string)) {
            this.saveClassesExcludePatternList(list);
        }
    }

    public List<String> loadClassesExcludePatternList() {
        PatternsetMatcher patternsetMatcher = this.getClassesExcludeMatcher();
        String[] pattern = patternsetMatcher.getPattern();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < pattern.length; ++i) {
            list.add(pattern[i]);
        }
        return list;
    }

    public void saveClassesExcludePatternList(List<String> list) {
        IFile classesExcludePatternset = this.getAntFolder().getFile("classes.exclude.patternset");
        PatternsetWriter.create(classesExcludePatternset, list.toArray(new String[list.size()]));
        this.classesExcludeMatcher = new PatternsetMatcher(classesExcludePatternset);
        try {
            classesExcludePatternset.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CorePlugin.getDefault().log(e);
        }
    }

    @Override
    public void addWOAppResourcesIncludePattern(String string) {
        List<String> list = this.loadWOAppResourcesIncludePatternList();
        if (!list.contains(string)) {
            list.add(string);
            this.saveWOAppResourcesIncludePatternList(list);
            this.removeWOAppResourcesExcludePattern(string);
        }
    }

    public void removeWOAppResourcesIncludePattern(String string) {
        List<String> list = this.loadWOAppResourcesIncludePatternList();
        if (list.remove(string)) {
            this.saveWOAppResourcesIncludePatternList(list);
        }
    }

    public List<String> loadWOAppResourcesIncludePatternList() {
        PatternsetMatcher patternsetMatcher = this.getWoappResourcesIncludeMatcher();
        String[] pattern = patternsetMatcher.getPattern();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < pattern.length; ++i) {
            list.add(pattern[i]);
        }
        return list;
    }

    public void saveWOAppResourcesIncludePatternList(List<String> list) {
        IFile wsresourcesIncludePatternset = this.getAntFolder().getFile("wsresources.include.patternset");
        PatternsetWriter.create(wsresourcesIncludePatternset, list.toArray(new String[list.size()]));
        this.woappResourcesIncludeMatcher = new PatternsetMatcher(wsresourcesIncludePatternset);
        try {
            wsresourcesIncludePatternset.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CorePlugin.getDefault().log(e);
        }
    }

    @Override
    public void addWOAppResourcesExcludePattern(String string) {
        List<String> list = this.loadWOAppResourcesExcludePatternList();
        if (!list.contains(string)) {
            list.add(string);
            this.saveWOAppResourcesExcludePatternList(list);
            this.removeWOAppResourcesIncludePattern(string);
        }
    }

    public void removeWOAppResourcesExcludePattern(String string) {
        List<String> list = this.loadWOAppResourcesExcludePatternList();
        if (list.remove(string)) {
            this.saveWOAppResourcesExcludePatternList(list);
        }
    }

    public List<String> loadWOAppResourcesExcludePatternList() {
        PatternsetMatcher patternsetMatcher = this.getWoappResourcesExcludeMatcher();
        String[] pattern = patternsetMatcher.getPattern();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < pattern.length; ++i) {
            list.add(pattern[i]);
        }
        return list;
    }

    public void saveWOAppResourcesExcludePatternList(List<String> list) {
        IFile wsresourcesExcludePatternset = this.getAntFolder().getFile("wsresources.exclude.patternset");
        PatternsetWriter.create(wsresourcesExcludePatternset, list.toArray(new String[list.size()]));
        this.woappResourcesExcludeMatcher = new PatternsetMatcher(wsresourcesExcludePatternset);
        try {
            wsresourcesExcludePatternset.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CorePlugin.getDefault().log(e);
        }
    }

    @Override
    public void addResourcesIncludePattern(String string) {
        List<String> list = this.loadResourcesIncludePatternList();
        if (!list.contains(string)) {
            list.add(string);
            this.saveResourcesIncludePatternList(list);
            this.removeResourcesExcludePattern(string);
        }
    }

    public void removeResourcesIncludePattern(String string) {
        List<String> list = this.loadResourcesIncludePatternList();
        if (list.remove(string)) {
            this.saveResourcesIncludePatternList(list);
        }
    }

    public List<String> loadResourcesIncludePatternList() {
        PatternsetMatcher patternsetMatcher = this.getResourcesIncludeMatcher();
        String[] pattern = patternsetMatcher.getPattern();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < pattern.length; ++i) {
            list.add(pattern[i]);
        }
        return list;
    }

    public void saveResourcesIncludePatternList(List<String> list) {
        IFile resourcesIncludePatternset = this.getAntFolder().getFile("resources.include.patternset");
        PatternsetWriter.create(resourcesIncludePatternset, list.toArray(new String[list.size()]));
        this.resourcesIncludeMatcher = new PatternsetMatcher(resourcesIncludePatternset);
        try {
            resourcesIncludePatternset.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CorePlugin.getDefault().log(e);
        }
    }

    @Override
    public void addResourcesExcludePattern(String string) {
        List<String> list = this.loadResourcesExcludePatternList();
        if (!list.contains(string)) {
            list.add(string);
            this.saveResourcesExcludePatternList(list);
            this.removeResourcesIncludePattern(string);
        }
    }

    public void removeResourcesExcludePattern(String string) {
        List<String> list = this.loadResourcesExcludePatternList();
        if (list.remove(string)) {
            this.saveResourcesExcludePatternList(list);
        }
    }

    public List<String> loadResourcesExcludePatternList() {
        PatternsetMatcher patternsetMatcher = this.getResourcesExcludeMatcher();
        String[] pattern = patternsetMatcher.getPattern();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < pattern.length; ++i) {
            list.add(pattern[i]);
        }
        return list;
    }

    public void saveResourcesExcludePatternList(List<String> list) {
        IFile resourcesexcludePatternset = this.getAntFolder().getFile("resources.exclude.patternset");
        PatternsetWriter.create(resourcesexcludePatternset, list.toArray(new String[list.size()]));
        this.resourcesIncludeMatcher = new PatternsetMatcher(resourcesexcludePatternset);
        try {
            resourcesexcludePatternset.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            CorePlugin.getDefault().log(e);
        }
    }

    public IProject getIProject() {
        return this.project;
    }

    @Override
    public IPBDotProjectOwner getPBDotProjectOwner() {
        return null;
    }

    @Override
    public IPBDotProjectOwner getPBDotProjectOwner(IResource resource) {
        return null;
    }

    @Override
    public IResource getUnderlyingResource() {
        return null;
    }

    @Override
    public ILocalizedPath localizedRelativeResourcePath(IPBDotProjectOwner pbDotProjectOwner, IResource resource) {
        return null;
    }

    protected static class PatternsetWorkspaceRunnable
    implements Runnable {
        IFile patternset;
        private PatternsetMatcher matcher;
        String[] defaultPattern;

        PatternsetWorkspaceRunnable(IFile patternset, String[] defaultPattern) {
            this.patternset = patternset;
            this.defaultPattern = defaultPattern;
        }

        public void run() {
            if (!this.patternset.exists()) {
                IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor pm) throws CoreException {
                        PatternsetWorkspaceRunnable.this.patternset.refreshLocal(2, pm);
                        if (!PatternsetWorkspaceRunnable.this.patternset.exists()) {
                            PatternsetWriter.create(PatternsetWorkspaceRunnable.this.patternset, PatternsetWorkspaceRunnable.this.defaultPattern);
                            try {
                                PatternsetWorkspaceRunnable.this.patternset.refreshLocal(1, pm);
                            }
                            catch (CoreException e) {
                                CorePlugin.getDefault().log(e);
                            }
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(workspaceRunnable, (ISchedulingRule)this.patternset, 1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    CorePlugin.getDefault().log(e);
                }
            }
            this.matcher = new PatternsetMatcher(this.patternset);
        }

        protected PatternsetMatcher getMatcher() {
            return this.matcher;
        }
    }
}

