/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.core.tobeintregrated;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.objectstyle.wolips.core.tobeintregrated.ASTMethodExplorer;
import org.objectstyle.wolips.core.tobeintregrated.NameComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSearch
implements IRunnableWithProgress {
    private static final int MAX_RUN = 100;
    private static final String SOURCE_FOLDER = "src";
    private static final String COMPONENTS_FOLDER = "Components";
    private IJavaProject javaProject;
    private Hashtable<String, List<String>> declaredMethods;
    private Hashtable<String, List<String>> usedMethods;
    private Hashtable<String, List<String>> unusedMethods;
    private Hashtable<String, List<String>> publicClassVariables;
    private Hashtable<String, String> possibleWodMethods;
    private Hashtable<String, List<String>> unusedClassVariables;
    private Hashtable<String, String> classDependencies;
    private ASTParser parser;
    private IProgressMonitor monitor;
    private IProgressMonitor taskMonitor;
    private Pattern intPat = Pattern.compile("(.+) = (\\d+);");
    private Pattern booleanPat = Pattern.compile("(.+) = (true)|(false);");
    private Pattern stringPat = Pattern.compile("(.+) = \"(.*)\";");
    private Pattern woInternPat = Pattern.compile("(.+) = (.+)\\.@(\\w+);");
    private Pattern normPat = Pattern.compile("(.+) = (.+);");
    private Pattern appPat = Pattern.compile("(.+) = application\\.(.+);");
    private Pattern sesPat = Pattern.compile("(.+) = session\\.(.+);");
    private Pattern commentPat = Pattern.compile("//TODO Not used: (.*)\n");

    public MethodSearch(IJavaProject javaProject) {
        this.javaProject = javaProject;
        this.unusedMethods = new Hashtable();
        this.declaredMethods = new Hashtable();
        this.usedMethods = new Hashtable();
        this.publicClassVariables = new Hashtable();
        this.possibleWodMethods = new Hashtable();
        this.unusedClassVariables = new Hashtable();
        this.classDependencies = new Hashtable();
        this.monitor = new NullProgressMonitor();
    }

    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        this.taskMonitor = progressMonitor;
        this.taskMonitor.beginTask("Search for unused WO code", 100);
        if (!this.searchForMethods()) {
            throw new InterruptedException();
        }
        this.taskMonitor.subTask("checking declared methods against vocated methods");
        if (!this.fillUnusedMethodsHash()) {
            throw new InterruptedException();
        }
        if (!this.checkSettersAndGettersFromClassVariables()) {
            throw new InterruptedException();
        }
        if (this.taskMonitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (!this.checkWodMethods()) {
            throw new InterruptedException();
        }
        this.taskMonitor.done();
    }

    private boolean searchForMethods() throws InvocationTargetException {
        try {
            IPackageFragmentRoot[] packageFragmentRoots = this.javaProject.getAllPackageFragmentRoots();
            IPackageFragmentRoot scr = null;
            for (int i = 0; i < packageFragmentRoots.length; ++i) {
                IPackageFragmentRoot root = packageFragmentRoots[i];
                if (!root.getHandleIdentifier().equals("=" + this.javaProject.getElementName() + "/" + SOURCE_FOLDER)) continue;
                scr = root;
            }
            if (scr != null) {
                IJavaElement[] IPackageFragments = scr.getChildren();
                for (int i = 0; i < IPackageFragments.length; ++i) {
                    IPackageFragment packageFragment = (IPackageFragment)IPackageFragments[i];
                    ICompilationUnit[] iCompUnits = packageFragment.getCompilationUnits();
                    for (int j = 0; j < iCompUnits.length; ++j) {
                        ICompilationUnit iComp = iCompUnits[j];
                        String packageName = "";
                        IPackageDeclaration[] packageBindings = iComp.getPackageDeclarations();
                        for (int k = 0; k < packageBindings.length; ++k) {
                            packageName = packageName + packageBindings[k];
                        }
                        if (iComp.getElementName().startsWith("_")) continue;
                        this.parser = ASTParser.newParser((int)3);
                        this.parser.setResolveBindings(true);
                        this.parser.setSource(iComp);
                        CompilationUnit astRoot = (CompilationUnit)this.parser.createAST(this.monitor);
                        this.taskMonitor.subTask("searching " + iComp.getElementName());
                        ASTMethodExplorer astVisitor = new ASTMethodExplorer(this.usedMethods, this.declaredMethods, this.publicClassVariables, this.classDependencies, iComp);
                        astRoot.accept((ASTVisitor)astVisitor);
                    }
                    this.taskMonitor.worked(1);
                    if (!this.taskMonitor.isCanceled()) continue;
                    return false;
                }
            }
            Object[] nonJava = this.javaProject.getNonJavaResources();
            for (int i = 0; i < nonJava.length; ++i) {
                IFolder folder;
                Object object = nonJava[i];
                if (object instanceof IFolder && (folder = (IFolder)object).getName().equals(COMPONENTS_FOLDER)) {
                    IResource[] res = folder.members();
                    for (int j = 0; j < res.length; ++j) {
                        String wodName;
                        IFolder wo;
                        IFile wod;
                        if (!(res[j] instanceof IFolder) || (wod = (wo = (IFolder)res[j]).getFile(wodName = wo.getName().substring(0, wo.getName().indexOf(".")) + ".wod")) == null) continue;
                        this.taskMonitor.subTask("searching " + wod.getName());
                        this.checkWOD(wod);
                    }
                }
                this.taskMonitor.worked(1);
                if (!this.taskMonitor.isCanceled()) continue;
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvocationTargetException(e, e.toString());
        }
        return true;
    }

    private boolean checkWOD(IFile wod) throws CoreException, IOException {
        String line;
        String wodName = wod.getName().substring(0, wod.getName().indexOf("."));
        BufferedReader in = new BufferedReader(new InputStreamReader(wod.getContents()));
        while ((line = in.readLine()) != null) {
            Matcher intMat = this.intPat.matcher(line);
            Matcher woInternMat = this.woInternPat.matcher(line);
            Matcher booleanMat = this.booleanPat.matcher(line);
            Matcher stringMat = this.stringPat.matcher(line);
            Matcher normMat = this.normPat.matcher(line);
            Matcher appMat = this.appPat.matcher(line);
            Matcher sesMat = this.sesPat.matcher(line);
            if (!(intMat.find() || woInternMat.find() || booleanMat.find() || stringMat.find())) {
                if (appMat.find()) {
                    this.possibleWodMethods.put("Application." + appMat.group(2), "null");
                } else if (sesMat.find()) {
                    this.possibleWodMethods.put("Session." + sesMat.group(2), "null");
                } else if (normMat.find()) {
                    this.possibleWodMethods.put(wodName + "." + normMat.group(2), "null");
                }
            }
            if (!this.taskMonitor.isCanceled()) continue;
            in.close();
            return false;
        }
        in.close();
        return true;
    }

    private boolean fillUnusedMethodsHash() {
        Enumeration<String> keysEnum = this.declaredMethods.keys();
        while (keysEnum.hasMoreElements()) {
            List<String> value;
            String skip;
            String key = keysEnum.nextElement();
            if (this.usedMethods.containsKey(key) || !(skip = (value = this.declaredMethods.get(key)).get(3)).equals("false")) continue;
            this.unusedMethods.put(key, value);
        }
        this.taskMonitor.worked(1);
        return !this.taskMonitor.isCanceled();
    }

    private boolean checkSettersAndGettersFromClassVariables() {
        Enumeration<String> keyEnum = this.publicClassVariables.keys();
        while (keyEnum.hasMoreElements()) {
            String classVariable = keyEnum.nextElement();
            String[] comps = classVariable.split("\\.");
            String className = comps[0];
            String methodName = comps[1];
            methodName = Character.toUpperCase(methodName.charAt(0)) + methodName.substring(1);
            ArrayList value = (ArrayList)this.publicClassVariables.get(classVariable);
            String arg = (String)value.get(1);
            String key = className + ".set" + methodName + "(" + arg + ")";
            this.unusedMethods.remove(key);
            key = className + ".get" + methodName + "()";
            this.unusedMethods.remove(key);
        }
        this.taskMonitor.worked(1);
        return !this.taskMonitor.isCanceled();
    }

    private boolean checkWodMethods() {
        this.unusedClassVariables = new Hashtable<String, List<String>>(this.publicClassVariables);
        Enumeration<String> keyEnum = this.possibleWodMethods.keys();
        while (keyEnum.hasMoreElements()) {
            String call = keyEnum.nextElement();
            ArrayList<String> splitList = new ArrayList<String>();
            String[] split = call.split("\\.");
            for (int i = 0; i < split.length; ++i) {
                splitList.add(split[i]);
            }
            String className = (String)splitList.remove(0);
            this.recursiveMethodFinder(className, new ArrayList<String>(splitList));
            this.recursiveMethodFinder(this.classDependencies.get(className), splitList);
        }
        this.taskMonitor.worked(1);
        return !this.taskMonitor.isCanceled();
    }

    private void recursiveMethodFinder(String className, List<String> splitList) {
        try {
            String newClass;
            ArrayList value;
            String local = splitList.remove(0);
            String key = className + "." + local;
            String key2 = key + "()";
            if (this.unusedMethods.containsKey(key2)) {
                this.unusedMethods.remove(key2);
            }
            if (this.publicClassVariables.containsKey(key)) {
                this.unusedClassVariables.remove(key);
                if (splitList.size() > 0) {
                    value = this.publicClassVariables.get(key);
                    newClass = (String)value.get(1);
                    this.recursiveMethodFinder(newClass, splitList);
                }
            }
            if (this.declaredMethods.containsKey(key2) && splitList.size() > 0) {
                value = (ArrayList)this.declaredMethods.get(key2);
                newClass = (String)value.get(2);
                this.recursiveMethodFinder(newClass, splitList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean setComments() throws InvocationTargetException {
        String comment;
        String source;
        ICompilationUnit iCompUnit;
        String name;
        String handleID;
        ArrayList value;
        String key;
        Enumeration<String> keysEnum = this.unusedMethods.keys();
        while (keysEnum.hasMoreElements()) {
            key = keysEnum.nextElement();
            value = (ArrayList)this.unusedMethods.get(key);
            handleID = (String)value.get(0);
            name = key.split("\\.")[1];
            try {
                iCompUnit = (ICompilationUnit)JavaCore.create((String)handleID);
                source = iCompUnit.getBuffer().getContents();
                comment = "//TODO Not used: Method " + name + "\n";
                if (this.checkComment(iCompUnit, comment)) {
                    iCompUnit.getBuffer().setContents(comment + source);
                    iCompUnit.save(this.monitor, true);
                }
                this.taskMonitor.worked(1);
                if (!this.taskMonitor.isCanceled()) continue;
                return false;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e, e.toString());
            }
        }
        keysEnum = this.unusedClassVariables.keys();
        while (keysEnum.hasMoreElements()) {
            key = keysEnum.nextElement();
            value = (ArrayList)this.unusedClassVariables.get(key);
            handleID = (String)value.get(0);
            name = key.split("\\.")[1];
            try {
                iCompUnit = (ICompilationUnit)JavaCore.create((String)handleID);
                source = iCompUnit.getBuffer().getContents();
                comment = "//TODO Not used: Class variable " + name + "\n";
                if (this.checkComment(iCompUnit, comment)) {
                    iCompUnit.getBuffer().setContents(comment + source);
                    iCompUnit.save(this.monitor, true);
                }
                this.taskMonitor.worked(1);
                if (!this.taskMonitor.isCanceled()) continue;
                return false;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e, e.toString());
            }
        }
        return true;
    }

    private boolean checkComment(ICompilationUnit iCompUnit, String comment) throws Exception {
        String source = iCompUnit.getBuffer().getContents();
        Matcher mat = this.commentPat.matcher(source);
        while (mat.find()) {
            if (!mat.group().equals(comment)) continue;
            return false;
        }
        return true;
    }

    public void writePossiblyUnusedMethodsToFile(File outputFile) throws InvocationTargetException {
        try {
            String key;
            int i;
            NameComparator comparator = new NameComparator();
            FileWriter writer = new FileWriter(outputFile);
            writer.write("############ unused methods #############\n\n");
            String[] keyArray = this.unusedMethods.keySet().toArray(new String[0]);
            Arrays.sort(keyArray, comparator);
            for (i = 0; i < keyArray.length; ++i) {
                key = keyArray[i];
                writer.write(key + "\n");
            }
            writer.write("\n########## unused class variables ##########\n\n");
            keyArray = this.unusedClassVariables.keySet().toArray(new String[0]);
            Arrays.sort(keyArray, comparator);
            for (i = 0; i < keyArray.length; ++i) {
                key = keyArray[i];
                writer.write(key + "\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new InvocationTargetException(e, e.toString());
        }
    }
}

