/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.api;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IType;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.bindings.wod.BindingValidationRule;
import org.objectstyle.wolips.bindings.wod.TagShortcut;
import org.objectstyle.wolips.core.resources.types.LimitedLRUCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiCache {
    private static String _tagShortcutsStr;
    private static String _bindingValidationRulesStr;
    private static List<TagShortcut> _tagShortcuts;
    private static List<BindingValidationRule> _bindingValidationRules;
    private Map<String, String> _elementNameToTypeCache;
    private Map<String, Wo> _elementTypeToApiCache;
    private Map<String, Boolean> _elementTypeToApiMissingCache;

    public ApiCache() {
        this.clearCache();
    }

    public synchronized void clearCache() {
        this._elementNameToTypeCache = Collections.synchronizedMap(new LimitedLRUCache(100));
        this._elementTypeToApiCache = Collections.synchronizedMap(new LimitedLRUCache(100));
        this._elementTypeToApiMissingCache = Collections.synchronizedMap(new LimitedLRUCache(100));
    }

    public synchronized void clearCacheForElementNamed(String elementName) {
        String elementTypeName = this._elementNameToTypeCache.remove(elementName);
        if (elementTypeName != null) {
            this.clearApiForElementTypeName(elementTypeName);
        }
    }

    public synchronized void clearCache(IType elementType) {
        this.clearApiForElementType(elementType);
        String elementName = elementType.getElementName();
        if (elementName != null) {
            this._elementNameToTypeCache.remove(elementName);
        }
    }

    public void clearApiForElementType(IType type) {
        this._elementTypeToApiMissingCache.remove(type.getFullyQualifiedName());
        this._elementTypeToApiCache.remove(type.getFullyQualifiedName());
    }

    private void clearApiForElementTypeName(String elementTypeName) {
        this._elementTypeToApiMissingCache.remove(elementTypeName);
        this._elementTypeToApiCache.remove(elementTypeName);
    }

    public Boolean apiMissingForElementType(IType type) {
        Boolean missing = this._elementTypeToApiMissingCache.get(type.getFullyQualifiedName());
        return missing;
    }

    public void setApiMissingForElementType(boolean missing, IType type) {
        if (missing) {
            this._elementTypeToApiMissingCache.put(type.getFullyQualifiedName(), Boolean.TRUE);
        } else {
            this._elementTypeToApiMissingCache.put(type.getFullyQualifiedName(), Boolean.FALSE);
        }
    }

    public Wo getApiForType(IType type) {
        Wo wo = this._elementTypeToApiCache.get(type.getFullyQualifiedName());
        return wo;
    }

    public void setApiForType(Wo wo, IType type) {
        this._elementTypeToApiCache.put(type.getFullyQualifiedName(), wo);
        this.setApiMissingForElementType(false, type);
    }

    public String getElementTypeNamed(String elementName) {
        return this._elementNameToTypeCache.get(elementName);
    }

    public void setElementTypeForName(IType elementType, String elementName) {
        this._elementNameToTypeCache.put(elementName, elementType.getFullyQualifiedName());
    }

    public static TagShortcut getTagShortcutNamed(String shortcut) {
        TagShortcut matchingTagShortcut = null;
        for (TagShortcut tagShortcut : ApiCache.getTagShortcuts()) {
            if (matchingTagShortcut != null || !tagShortcut.getShortcut().equalsIgnoreCase(shortcut)) continue;
            matchingTagShortcut = tagShortcut;
        }
        return matchingTagShortcut;
    }

    public static synchronized List<TagShortcut> getTagShortcuts() {
        String tagShortcutsStr = Activator.getDefault().getPreferenceStore().getString("TagShortcuts");
        if (tagShortcutsStr == null && _tagShortcutsStr != null || tagShortcutsStr != null && !tagShortcutsStr.equals(_tagShortcutsStr)) {
            _tagShortcutsStr = tagShortcutsStr;
            _tagShortcuts = TagShortcut.fromPreferenceString(tagShortcutsStr);
        }
        return _tagShortcuts;
    }

    public static synchronized List<BindingValidationRule> getBindingValidationRules() {
        String bindingValidationRulesStr = Activator.getDefault().getPreferenceStore().getString("BindingValidationRules");
        if (bindingValidationRulesStr == null && _bindingValidationRulesStr != null || bindingValidationRulesStr != null && !bindingValidationRulesStr.equals(_bindingValidationRulesStr)) {
            _bindingValidationRulesStr = bindingValidationRulesStr;
            _bindingValidationRules = BindingValidationRule.fromPreferenceString(bindingValidationRulesStr);
        }
        return _bindingValidationRules;
    }
}

