/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.api;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.bindings.api.ApiCache;
import org.objectstyle.wolips.bindings.api.ApiModel;
import org.objectstyle.wolips.bindings.api.ApiModelException;
import org.objectstyle.wolips.bindings.api.Binding;
import org.objectstyle.wolips.bindings.api.IApiBinding;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.BindingValueKey;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.core.resources.types.TypeNameCollector;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.jdt.ProjectFrameworkAdapter;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiUtils {
    private static ApiModel _globalApiModel;

    public static boolean isActionBinding(IApiBinding binding) {
        String defaults = binding.getDefaults();
        boolean isActionBinding = false;
        if ("Actions".equals(defaults)) {
            isActionBinding = true;
        } else if (defaults == null) {
            String bindingName = binding.getName();
            isActionBinding = "action".equals(bindingName) || bindingName.endsWith("Action");
        }
        return isActionBinding;
    }

    public static int getSelectedDefaults(IApiBinding binding) {
        String defaults = binding.getDefaults();
        if (defaults == null) {
            return 0;
        }
        for (int i = 0; i < IApiBinding.ALL_DEFAULTS.length; ++i) {
            String string = IApiBinding.ALL_DEFAULTS[i];
            if (!string.equals(defaults)) continue;
            return i;
        }
        return 0;
    }

    public static Wo findApiModelWo(IType elementType, ApiCache cache) throws ApiModelException {
        Wo wo;
        if (elementType == null) {
            wo = null;
        } else {
            Boolean apiMissing;
            ApiModel model;
            wo = cache.getApiForType(elementType);
            if (wo != null && (model = wo.getModel()).parseIfNecessary()) {
                cache.clearApiForElementType(elementType);
                wo = null;
            }
            if (!(wo != null || (apiMissing = cache.apiMissingForElementType(elementType)) != null && apiMissing.booleanValue())) {
                ApiModel apiModel = null;
                try {
                    Wo[] wos;
                    if (elementType.getFullyQualifiedName().startsWith("com.webobjects.appserver._private.")) {
                        if (_globalApiModel == null) {
                            Bundle bundle = Activator.getDefault().getBundle();
                            URL woDefinitionsURL = bundle.getEntry("/WebObjectDefinitions.xml");
                            if (woDefinitionsURL != null) {
                                apiModel = new ApiModel(woDefinitionsURL);
                            }
                            _globalApiModel = apiModel;
                        } else {
                            apiModel = _globalApiModel;
                        }
                    } else {
                        LocalizedComponentsLocateResult componentsLocateResults;
                        IFile apiFile;
                        IOpenable typeContainer = elementType.getOpenable();
                        if (typeContainer instanceof IClassFile) {
                            IClassFile classFile = (IClassFile)typeContainer;
                            IJavaElement parent = classFile.getParent();
                            if (parent instanceof IPackageFragment) {
                                IPath packagePath;
                                IPath apiPath;
                                File apiFile2;
                                boolean fileExists;
                                IPackageFragment parentPackage = (IPackageFragment)parent;
                                IJavaElement parentParent = parentPackage.getParent();
                                if (parentParent instanceof IPackageFragmentRoot && "jar".equalsIgnoreCase(parentParent.getPath().getFileExtension())) {
                                    JarFile jarFile;
                                    JarEntry je;
                                    String jarResourcePath = "Resources/" + elementType.getElementName() + ".api";
                                    String jarOSPath = parentParent.getPath().toOSString();
                                    File jarOSFile = new File(jarOSPath);
                                    if (jarOSFile.exists() && (je = (jarFile = new JarFile(jarOSFile)).getJarEntry(jarResourcePath)) != null && je.getSize() != 0L) {
                                        apiModel = new ApiModel(new URL("jar:file:" + jarOSPath + "!/" + jarResourcePath));
                                    }
                                }
                                if (apiModel == null && (fileExists = (apiFile2 = (apiPath = (packagePath = parentPackage.getPath()).removeLastSegments(2).append(elementType.getElementName()).addFileExtension("api")).toFile()).exists())) {
                                    apiModel = new ApiModel(apiFile2);
                                }
                            }
                        } else if (typeContainer instanceof ICompilationUnit && (apiFile = (componentsLocateResults = LocatePlugin.getDefault().getLocalizedComponentsLocateResult(elementType.getJavaProject().getProject(), elementType.getElementName())).getDotApi()) != null && apiFile.exists()) {
                            apiModel = new ApiModel(apiFile);
                        }
                    }
                    if (apiModel != null && (wos = apiModel.getWODefinitions().getWos()).length != 0) {
                        if (wos.length == 1) {
                            wo = wos[0];
                        } else {
                            for (int i = 0; wo == null && i < wos.length; ++i) {
                                if (!elementType.getElementName().equals(wos[i].getClassName())) continue;
                                wo = wos[i];
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    wo = null;
                    Activator.getDefault().log("Failed to parse API for " + elementType.getElementName() + ".", t);
                }
                if (wo == null) {
                    cache.setApiMissingForElementType(true, elementType);
                } else {
                    cache.setApiForType(wo, elementType);
                }
            }
        }
        return wo;
    }

    public static String[] getValidValues(String partialValue, IJavaProject javaProject, IType componentType, IType apiType, String bindingName, TypeCache typeCache) throws JavaModelException, ApiModelException {
        Binding matchingBinding;
        String[] validValues = null;
        Wo wo = ApiUtils.findApiModelWo(apiType, typeCache.getApiCache(javaProject));
        if (wo != null && (matchingBinding = wo.getBinding(bindingName)) != null) {
            validValues = matchingBinding.getValidValues(partialValue, javaProject, componentType, typeCache);
        }
        return validValues;
    }

    public static String[] getValidValues(IApiBinding binding, String partialValue, IJavaProject javaProject, IType componentType, TypeCache typeCache) throws JavaModelException {
        TypeNameCollector typeNameCollector;
        HashSet<String> validValues = new HashSet<String>();
        int selectedDefaults = binding.getSelectedDefaults();
        String defaultsName = IApiBinding.ALL_DEFAULTS[selectedDefaults];
        if ("Boolean".equals(defaultsName)) {
            validValues.add("true");
            validValues.add("false");
        } else if ("YES/NO".equals(defaultsName)) {
            validValues.add("yes");
            validValues.add("no");
        } else if ("Date Format Strings".equals(defaultsName)) {
            validValues.add("\"%m/%d/%y\"");
            validValues.add("\"%B %d, %Y\"");
            validValues.add("\"%b %d, %Y\"");
            validValues.add("\"%A, %B %d, %Y\"");
            validValues.add("\"%A, %b %d, %Y\"");
            validValues.add("\"%d.%m.%y\"");
            validValues.add("\"%d %B %y\"");
            validValues.add("\"%d %b %y\"");
            validValues.add("\"%A %d %B %Y\"");
            validValues.add("\"%A %d %b %Y\"");
            validValues.add("\"%x\"");
            validValues.add("\"%H:%M:%S\"");
            validValues.add("\"%I:%M:%S %p\"");
            validValues.add("\"%H:%M\"");
            validValues.add("\"%I:%M %p\"");
            validValues.add("\"%X\"");
        } else if ("Number Format Strings".equals(defaultsName)) {
            validValues.add("\"0\"");
            validValues.add("\"0.00\"");
            validValues.add("\"0.##\"");
            validValues.add("\"#,##0\"");
            validValues.add("\"_,__0\"");
            validValues.add("\"#,##0.00\"");
            validValues.add("\"$#,##0\"");
            validValues.add("\"$#,##0.00\"");
            validValues.add("\"$#,##0.##\"");
        } else if ("MIME Types".equals(defaultsName)) {
            validValues.add("\"image/gif\"");
            validValues.add("\"image/jpeg\"");
            validValues.add("\"image/png\"");
        } else if ("Direct Actions".equals(defaultsName)) {
            if (partialValue != null && partialValue.startsWith("\"")) {
                typeNameCollector = new TypeNameCollector("com.webobjects.appserver.WODirectAction", javaProject, false);
                BindingReflectionUtils.findMatchingElementClassNames("", 1, typeNameCollector, (IProgressMonitor)new NullProgressMonitor());
                for (IType type : typeNameCollector.types()) {
                    IMethod[] methods;
                    for (IMethod method : methods = type.getMethods()) {
                        String name = method.getElementName();
                        if (!name.endsWith("Action") || method.getParameterNames().length != 0) continue;
                        validValues.add("\"" + name.substring(0, name.length() - "Action".length()) + "\"");
                    }
                }
            }
        } else if ("Direct Action Classes".equals(defaultsName)) {
            if (partialValue != null && partialValue.startsWith("\"")) {
                typeNameCollector = new TypeNameCollector("com.webobjects.appserver.WODirectAction", javaProject, false);
                BindingReflectionUtils.findMatchingElementClassNames(partialValue.substring(1), 1, typeNameCollector, (IProgressMonitor)new NullProgressMonitor());
                for (String typeName : typeNameCollector.getTypeNames()) {
                    int dotIndex = typeName.lastIndexOf(46);
                    if (dotIndex != -1) {
                        typeName = typeName.substring(dotIndex + 1);
                    }
                    validValues.add("\"" + typeName + "\"");
                }
            }
        } else if ("Page Names".equals(defaultsName)) {
            if (partialValue != null && partialValue.startsWith("\"")) {
                typeNameCollector = new TypeNameCollector(javaProject, false);
                BindingReflectionUtils.findMatchingElementClassNames(partialValue.substring(1), 1, typeNameCollector, (IProgressMonitor)new NullProgressMonitor());
                for (String typeName : typeNameCollector.getTypeNames()) {
                    int dotIndex = typeName.lastIndexOf(46);
                    if (dotIndex != -1) {
                        typeName = typeName.substring(dotIndex + 1);
                    }
                    validValues.add("\"" + typeName + "\"");
                }
            }
        } else if ("Frameworks".equals(defaultsName)) {
            if (partialValue != null && partialValue.startsWith("\"")) {
                validValues.add("\"app\"");
                ProjectFrameworkAdapter projectFrameworkAdapter = (ProjectFrameworkAdapter)javaProject.getProject().getAdapter(ProjectFrameworkAdapter.class);
                if (projectFrameworkAdapter != null) {
                    for (String frameworkName : projectFrameworkAdapter.getLinkedFrameworkNames()) {
                        validValues.add("\"" + frameworkName + "\"");
                    }
                }
            }
        } else if ("Resources".equals(defaultsName)) {
            ProjectAdapter projectAdapter = (ProjectAdapter)javaProject.getProject().getAdapter(ProjectAdapter.class);
            if (projectAdapter != null) {
                IFolder folder = projectAdapter.getBuildAdapter().getProductAdapter().getContentsAdapter().getWebServerResourcesAdapter().getUnderlyingFolder();
                try {
                    ApiUtils.acceptResources((IResource)folder, "", validValues);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        } else if ("Actions".equals(defaultsName)) {
            List<BindingValueKey> bindingKeysList = BindingReflectionUtils.getBindingKeys(javaProject, componentType, "", false, 3, false, typeCache);
            for (BindingValueKey key : bindingKeysList) {
                validValues.add(key.getBindingName());
            }
        }
        String[] validValueStrings = validValues.toArray(new String[validValues.size()]);
        return validValueStrings;
    }

    protected static void acceptResources(IResource resource, String basePath, Set<String> paths) throws CoreException {
        if (resource instanceof IFolder) {
            IResource[] members;
            for (IResource childResource : members = ((IFolder)resource).members()) {
                if (childResource instanceof IFolder) {
                    ApiUtils.acceptResources(childResource, basePath + "/" + childResource.getName() + "/", paths);
                    continue;
                }
                ApiUtils.acceptResources(childResource, basePath, paths);
            }
        } else if (resource instanceof IFile) {
            paths.add("\"" + basePath + resource.getName() + "\"");
        }
    }
}

