/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.wod;

import org.eclipse.jface.text.Position;
import org.objectstyle.wolips.bindings.wod.AbstractWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodBinding;

public class SimpleWodBinding
extends AbstractWodBinding {
    private String _namespace;
    private String _name;
    private String _valueNamespace;
    private String _value;
    private Position _namespacePosition;
    private Position _namePosition;
    private Position _valueNamespacePosition;
    private Position _valuePosition;
    private int _lineNumber;
    private int _startOffset;
    private int _endOffset;

    public SimpleWodBinding(IWodBinding wodBinding) {
        this(wodBinding.getNamespace(), wodBinding.getName(), wodBinding.getValueNamespace(), wodBinding.getValue(), wodBinding.getNamespacePosition(), wodBinding.getNamePosition(), wodBinding.getValueNamespacePosition(), wodBinding.getValuePosition(), wodBinding.getLineNumber());
    }

    public SimpleWodBinding(String namespace, String name, String value) {
        this(namespace, name, value, null, null, null, null, null, -1);
    }

    public SimpleWodBinding(String namespace, String name, String value, boolean literal) {
        this(namespace, name, null, literal ? "\"" + value + "\"" : value, null, null, null, null, -1);
    }

    public SimpleWodBinding(String namespace, String name, String valueNamespace, String value, Position namespacePosition, Position namePosition, Position valueNamespacePosition, Position valuePosition, int lineNumber) {
        this._namespace = namespace;
        this._name = name;
        this._value = value;
        this._valueNamespace = valueNamespace;
        this._namePosition = namePosition;
        this._valueNamespacePosition = valueNamespacePosition;
        this._valuePosition = valuePosition;
        this._lineNumber = lineNumber;
        this._startOffset = -1;
        this._endOffset = -1;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public String getValueNamespace() {
        return this._valueNamespace;
    }

    public void setValueNamespace(String valueNamespace) {
        String oldValueNamespace = this._valueNamespace;
        this._valueNamespace = valueNamespace;
        if (this._valueNamespacePosition != null && this._valueNamespace != null) {
            this.setValueNamespacePosition(new Position(this._valueNamespacePosition.getOffset(), this._valueNamespace.length()));
        }
        int oldLength = oldValueNamespace != null ? oldValueNamespace.length() : 0;
        int newLength = valueNamespace.length();
        int diff = newLength - oldLength;
        if (this._valuePosition != null) {
            this.setValuePosition(new Position(this._valuePosition.getOffset() + diff, this._valuePosition.getLength()));
        }
    }

    public void setValue(String value) {
        this._value = value;
        if (this._valuePosition != null && this._value != null) {
            this.setValuePosition(new Position(this._valuePosition.getOffset(), this._value.length()));
        }
    }

    public void setNamespace(String namespace) {
        String oldNamespace = this._namespace;
        this._namespace = namespace;
        if (this._namespacePosition != null && this._namespace != null) {
            this.setNamespacePosition(new Position(this._namespacePosition.getOffset(), this._namespace.length()));
        }
        int oldLength = oldNamespace != null ? oldNamespace.length() : 0;
        int newLength = namespace.length();
        int diff = newLength - oldLength;
        this.setNamePosition(new Position(this._namePosition.getOffset() + diff, this._valuePosition.getLength()));
        if (this._valueNamespacePosition != null) {
            this.setValueNamespacePosition(new Position(this._valueNamespacePosition.getOffset() + diff, this._valueNamespacePosition.getLength()));
        }
        if (this._valuePosition != null) {
            this.setValuePosition(new Position(this._valuePosition.getOffset() + diff, this._valuePosition.getLength()));
        }
    }

    public void setName(String name) {
        String oldName = this._name;
        this._name = name;
        if (this._namePosition != null && this._name != null) {
            this.setNamePosition(new Position(this._namePosition.getOffset(), this._name.length()));
        }
        int oldLength = oldName != null ? oldName.length() : 0;
        int newLength = name.length();
        int diff = newLength - oldLength;
        if (this._valueNamespacePosition != null) {
            this.setValueNamespacePosition(new Position(this._valueNamespacePosition.getOffset() + diff, this._valueNamespacePosition.getLength()));
        }
        if (this._valuePosition != null) {
            this.setValuePosition(new Position(this._valuePosition.getOffset() + diff, this._valuePosition.getLength()));
        }
    }

    public void setEndOffset(int endOffset) {
        this._endOffset = endOffset;
    }

    public int getEndOffset() {
        int endOffset = this._endOffset != -1 ? this._endOffset : (this._valuePosition != null ? this._valuePosition.getOffset() + this._valuePosition.getLength() : this.getStartOffset());
        return endOffset;
    }

    public void setStartOffset(int startOffset) {
        this._startOffset = startOffset;
    }

    public int getStartOffset() {
        int startOffset = this._startOffset != -1 ? this._startOffset : (this._namespacePosition != null ? this._namespacePosition.getOffset() : (this._namePosition != null ? this._namePosition.getOffset() : 0));
        return startOffset;
    }

    public void setNamespacePosition(Position namespacePosition) {
        this._namespacePosition = namespacePosition;
    }

    public Position getNamespacePosition() {
        return this._namespacePosition;
    }

    public void setNamePosition(Position namePosition) {
        this._namePosition = namePosition;
    }

    public Position getNamePosition() {
        return this._namePosition;
    }

    public void setValuePosition(Position valuePosition) {
        this._valuePosition = valuePosition;
    }

    public Position getValuePosition() {
        return this._valuePosition;
    }

    public Position getValueNamespacePosition() {
        return this._valueNamespacePosition;
    }

    public void setValueNamespacePosition(Position valueNamespacePosition) {
        this._valueNamespacePosition = valueNamespacePosition;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }
}

