/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.wod;

import org.eclipse.jface.text.Position;
import org.objectstyle.wolips.bindings.wod.AbstractWodElement;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.SimpleWodBinding;

public class SimpleWodElement
extends AbstractWodElement {
    private String _elementName;
    private String _elementType;
    private Position _elementNamePosition;
    private Position _elementTypePosition;
    private int _startOffset;
    private int _endOffset;
    private int _fullEndOffset;
    private int _newBindingOffset;
    private int _newBindingIndent;

    public SimpleWodElement(IWodElement wodElement) {
        if (wodElement != null) {
            this._elementName = wodElement.getElementName();
            this._elementNamePosition = wodElement.getElementNamePosition();
            this._elementType = wodElement.getElementType();
            this._elementTypePosition = wodElement.getElementTypePosition();
            this.setInline(wodElement.isInline());
            for (IWodBinding binding : wodElement.getBindings()) {
                this.addBinding(new SimpleWodBinding(binding));
            }
            this._startOffset = wodElement.getStartOffset();
            this._endOffset = wodElement.getEndOffset();
            this._fullEndOffset = wodElement.getFullEndOffset();
            this.setNewBindingIndent(wodElement.getNewBindingIndent());
            this.setNewBindingOffset(wodElement.getNewBindingOffset());
        } else {
            this.setInline(true);
        }
    }

    public SimpleWodElement(String name, String type) {
        this._elementName = name;
        this._elementType = type;
    }

    protected SimpleWodElement() {
    }

    protected void _setElementName(String name) {
        this._elementName = name;
    }

    protected void _setElementType(String type) {
        this._elementType = type;
    }

    public void setElementName(String name) {
        String oldElementName = this._elementName;
        this._elementName = name;
        if (this._elementNamePosition != null && this._elementName != null) {
            this.setElementNamePosition(new Position(this._elementNamePosition.getOffset(), this._elementName.length()));
        }
        if (!this.isInline() && oldElementName != null) {
            int oldLength = oldElementName.length();
            int newLength = name.length();
            int diff = newLength - oldLength;
            this.setElementTypePosition(new Position(this._elementTypePosition.getOffset() + diff, this._elementTypePosition.getLength()));
        }
    }

    public String getElementName() {
        return this._elementName;
    }

    public Position getElementNamePosition() {
        return this._elementNamePosition;
    }

    public void setElementNamePosition(Position elementNamePosition) {
        this._elementNamePosition = elementNamePosition;
    }

    public String getElementType() {
        return this._elementType;
    }

    public void setElementType(String elementType) {
        this._elementType = elementType;
        if (this._elementTypePosition != null && this._elementType != null) {
            this.setElementTypePosition(new Position(this._elementTypePosition.getOffset(), this._elementType.length()));
        }
    }

    public void setElementTypePosition(Position elementTypePosition) {
        this._elementTypePosition = elementTypePosition;
    }

    public Position getElementTypePosition() {
        return this._elementTypePosition;
    }

    public void setEndOffset(int endOffset) {
        this._endOffset = endOffset;
    }

    public int getEndOffset() {
        return this._endOffset;
    }

    public int getFullEndOffset() {
        return this._fullEndOffset;
    }

    public void setFullEndOffset(int fullEndOffset) {
        this._fullEndOffset = fullEndOffset;
    }

    public void setStartOffset(int startOffset) {
        this._startOffset = startOffset;
    }

    public int getStartOffset() {
        return this._startOffset;
    }

    public int getLineNumber() {
        return -1;
    }

    public void setNewBindingOffset(int newBindingOffset) {
        this._newBindingOffset = newBindingOffset;
    }

    public int getNewBindingOffset() {
        int newBindingOffset = this._newBindingOffset;
        if (newBindingOffset == -1) {
            newBindingOffset = this.getEndOffset() - 1;
        }
        return newBindingOffset;
    }

    public void setNewBindingIndent(int newBindingIndent) {
        this._newBindingIndent = newBindingIndent;
    }

    public int getNewBindingIndent() {
        return this._newBindingIndent;
    }
}

