/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.bindings.wod;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.objectstyle.wolips.bindings.api.ApiCache;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.BindingValueKey;
import org.objectstyle.wolips.core.resources.types.LimitedLRUCache;
import org.objectstyle.wolips.core.resources.types.SubTypeHierarchyCache;
import org.objectstyle.wolips.core.resources.types.SuperTypeHierarchyCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCache {
    private Map<IJavaProject, ApiCache> _apiCache;
    private LimitedLRUCache<IType, TypeCacheEntry> _typeCacheEntries = new LimitedLRUCache(1000);

    public TypeCache() {
        this._apiCache = new HashMap<IJavaProject, ApiCache>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeCacheEntry getTypeCacheEntry(IType type) throws JavaModelException {
        LimitedLRUCache<IType, TypeCacheEntry> limitedLRUCache = this._typeCacheEntries;
        synchronized (limitedLRUCache) {
            TypeCacheEntry entry = (TypeCacheEntry)this._typeCacheEntries.get((Object)type);
            if (entry == null) {
                entry = new TypeCacheEntry(type);
                this._typeCacheEntries.put((Object)type, (Object)entry);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiCache getApiCache(IJavaProject javaProject) {
        ApiCache apiCache;
        if (javaProject == null) {
            apiCache = new ApiCache();
        } else {
            Map<IJavaProject, ApiCache> map = this._apiCache;
            synchronized (map) {
                apiCache = this._apiCache.get(javaProject);
                if (apiCache == null) {
                    apiCache = new ApiCache();
                    this._apiCache.put(javaProject, apiCache);
                }
            }
        }
        return apiCache;
    }

    public List<BindingValueKey> getBindingValueAccessorKeys(IJavaProject javaProject, IType type, String name) throws JavaModelException {
        return this.getTypeCacheEntry(type).getBindingValueAccessorKeys(javaProject, name);
    }

    public List<BindingValueKey> getBindingValueMutatorKeys(IJavaProject javaProject, IType type, String name) throws JavaModelException {
        return this.getTypeCacheEntry(type).getBindingValueMutatorKeys(javaProject, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheForProject(IProject project) {
        if (project != null) {
            LinkedList typesToClear = new LinkedList();
            LimitedLRUCache<IType, TypeCacheEntry> limitedLRUCache = this._typeCacheEntries;
            synchronized (limitedLRUCache) {
                for (Map.Entry entry : this._typeCacheEntries.entrySet()) {
                    IResource resource = ((TypeCacheEntry)entry.getValue()).getResource();
                    if (resource == null || !project.equals(resource.getProject())) continue;
                    typesToClear.add(entry.getKey());
                }
                for (IType typeToClear : typesToClear) {
                    this.clearCacheForType(typeToClear);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheForResource(IResource resource) {
        if (resource != null) {
            LinkedList typesToClear = new LinkedList();
            LimitedLRUCache<IType, TypeCacheEntry> limitedLRUCache = this._typeCacheEntries;
            synchronized (limitedLRUCache) {
                for (Map.Entry entry : this._typeCacheEntries.entrySet()) {
                    if (!resource.equals((Object)((TypeCacheEntry)entry.getValue()).getResource())) continue;
                    typesToClear.add(entry.getKey());
                }
                for (IType typeToClear : typesToClear) {
                    this.clearCacheForType(typeToClear);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCacheForType(IType declaringType) {
        LimitedLRUCache<IType, TypeCacheEntry> limitedLRUCache = this._typeCacheEntries;
        synchronized (limitedLRUCache) {
            this._typeCacheEntries.remove((Object)declaringType);
        }
    }

    public IType getTypeForNameInType(String typeName, IType declaringType) throws JavaModelException {
        return this.getTypeCacheEntry(declaringType).getTypeForName(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        LimitedLRUCache<IType, TypeCacheEntry> limitedLRUCache = this._typeCacheEntries;
        synchronized (limitedLRUCache) {
            this._typeCacheEntries.clear();
        }
    }

    public List<IType> getSupertypesOf(IType type) throws JavaModelException {
        try {
            return this.getTypeCacheEntry(type).getSupertypes();
        }
        catch (JavaModelException e) {
            this.clearCacheForType(type);
            throw e;
        }
    }

    public List<IType> getSubtypesOfInProject(IType type, IJavaProject project) throws JavaModelException {
        try {
            return this.getTypeCacheEntry(type).getSubtypesInProject(project);
        }
        catch (JavaModelException e) {
            this.clearCacheForType(type);
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TypeCacheEntry {
        private IType _type;
        private IResource _resource;
        private Map<String, IType> _nextTypeCache;
        private Map<String, List<BindingValueKey>> _bindingValueAccessorKeys;
        private Map<String, List<BindingValueKey>> _bindingValueMutatorKeys;

        public TypeCacheEntry(IType type) throws JavaModelException {
            this._type = type;
            this._nextTypeCache = new HashMap<String, IType>();
            this._bindingValueAccessorKeys = new HashMap<String, List<BindingValueKey>>();
            this._bindingValueMutatorKeys = new HashMap<String, List<BindingValueKey>>();
        }

        public IResource getResource() {
            return this._resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<BindingValueKey> getBindingValueAccessorKeys(IJavaProject javaProject, String name) throws JavaModelException {
            Map<String, List<BindingValueKey>> map = this._bindingValueAccessorKeys;
            synchronized (map) {
                List<BindingValueKey> bindingValueAccessorKeys = this._bindingValueAccessorKeys.get(name);
                if (bindingValueAccessorKeys == null) {
                    bindingValueAccessorKeys = BindingReflectionUtils.getBindingKeys(javaProject, this._type, name, true, 2, false, TypeCache.this);
                    if (this._type.getTypeParameters().length == 0 || bindingValueAccessorKeys.size() == 0) {
                        this._bindingValueAccessorKeys.put(name, bindingValueAccessorKeys);
                    }
                }
                return bindingValueAccessorKeys;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<BindingValueKey> getBindingValueMutatorKeys(IJavaProject javaProject, String name) throws JavaModelException {
            Map<String, List<BindingValueKey>> map = this._bindingValueMutatorKeys;
            synchronized (map) {
                List<BindingValueKey> bindingValueMutatorKeys = this._bindingValueMutatorKeys.get(name);
                if (bindingValueMutatorKeys == null) {
                    bindingValueMutatorKeys = BindingReflectionUtils.getBindingKeys(javaProject, this._type, name, true, 1, false, TypeCache.this);
                    if (this._type.getTypeParameters().length == 0 && bindingValueMutatorKeys.size() > 0) {
                        this._bindingValueMutatorKeys.put(name, bindingValueMutatorKeys);
                    }
                }
                return bindingValueMutatorKeys;
            }
        }

        public IType resolveType(String refTypeSig, IType declaringType) throws JavaModelException {
            IJavaProject javaProject = declaringType.getJavaProject();
            int arrayCount = Signature.getArrayCount((String)refTypeSig);
            char type = refTypeSig.charAt(arrayCount);
            if (type == 'Q') {
                IType slowResolvedType;
                String slowResolvedTypeName;
                IImportDeclaration[] importDeclarations;
                String name = "";
                int bracket = refTypeSig.indexOf(60, arrayCount + 1);
                if (bracket > 0) {
                    name = refTypeSig.substring(arrayCount + 1, bracket);
                } else {
                    int semi = refTypeSig.indexOf(59, arrayCount + 1);
                    if (semi == -1) {
                        throw new IllegalArgumentException();
                    }
                    name = refTypeSig.substring(arrayCount + 1, semi);
                }
                String dotTypeName = "." + name;
                String dotBaseTypeName = null;
                String dotExtensionTypeName = null;
                int dotIndex = name.indexOf(46);
                if (dotIndex != -1) {
                    IType resolvedType = javaProject.findType(name);
                    if (resolvedType != null) {
                        return resolvedType;
                    }
                    dotBaseTypeName = "." + name.substring(0, dotIndex);
                    dotExtensionTypeName = name.substring(dotIndex);
                }
                for (IImportDeclaration declaration : importDeclarations = declaringType.getCompilationUnit().getImports()) {
                    IType importNestedType;
                    String importName = declaration.getElementName();
                    if (declaration.isOnDemand()) {
                        String packageName = importName.substring(0, importName.lastIndexOf(46));
                        String possibleTypeName = packageName + dotTypeName;
                        IType onDemandPackageType = javaProject.findType(possibleTypeName);
                        if (onDemandPackageType == null) continue;
                        return onDemandPackageType;
                    }
                    if (importName.endsWith(dotTypeName)) {
                        IType importType = javaProject.findType(importName);
                        if (importType == null) continue;
                        return importType;
                    }
                    if (dotBaseTypeName == null || !importName.endsWith(dotBaseTypeName) || (importNestedType = javaProject.findType(importName + dotExtensionTypeName)) == null) continue;
                    return importNestedType;
                }
                String javaLangTypeName = "java.lang" + dotTypeName;
                IType javaLangType = javaProject.findType(javaLangTypeName);
                if (javaLangType != null) {
                    return javaLangType;
                }
                String innerTypeName = declaringType.getFullyQualifiedName('.') + dotTypeName;
                IType innerType = javaProject.findType(innerTypeName);
                if (innerType != null) {
                    return innerType;
                }
                IPackageFragment declaringTypePackageFragment = declaringType.getPackageFragment();
                if (declaringTypePackageFragment != null) {
                    String samePackageTypeName = declaringTypePackageFragment.getElementName() + dotTypeName;
                    IType samePackageType = javaProject.findType(samePackageTypeName);
                    if (samePackageType != null) {
                        return samePackageType;
                    }
                } else {
                    IType defaultPackageType = javaProject.findType(name);
                    if (defaultPackageType != null) {
                        return defaultPackageType;
                    }
                }
                if ((slowResolvedTypeName = JavaModelUtil.getResolvedTypeName((String)refTypeSig, (IType)this._type)) != null && (slowResolvedType = javaProject.findType(slowResolvedTypeName)) != null) {
                    return slowResolvedType;
                }
                return null;
            }
            String resolvedTypeName = Signature.toString((String)refTypeSig.substring(arrayCount));
            IType resolvedType = javaProject.findType(resolvedTypeName);
            return resolvedType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IType getTypeForName(String typeName) throws JavaModelException {
            IType type;
            if ("void".equals(typeName) || typeName != null && typeName.length() == 1) {
                type = null;
            } else {
                Map<String, IType> map = this._nextTypeCache;
                synchronized (map) {
                    type = this._nextTypeCache.get(typeName);
                }
                if (type == null) {
                    type = this.resolveType(typeName, this._type);
                    if (type == null) {
                        if (!BindingReflectionUtils.isPrimitive(typeName) && !"QKeyValueCodingProtectedAccessor;".equals(typeName)) {
                            // empty if block
                        }
                    } else {
                        map = this._nextTypeCache;
                        synchronized (map) {
                            this._nextTypeCache.put(typeName, type);
                        }
                    }
                }
            }
            return type;
        }

        public List<IType> getSupertypes() throws JavaModelException {
            ITypeHierarchy typeHierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)this._type);
            LinkedList<IType> types = new LinkedList<IType>();
            types.add(this._type);
            for (IType type : typeHierarchy.getAllSupertypes(this._type)) {
                types.add(type);
            }
            return types;
        }

        public List<IType> getSubtypesInProject(IJavaProject project) throws JavaModelException {
            ITypeHierarchy typeHierarchy = SubTypeHierarchyCache.getTypeHierarchyInProject((IType)this._type, (IJavaProject)project);
            LinkedList<IType> types = new LinkedList<IType>();
            IType[] subtypes = typeHierarchy.getAllSubtypes(this._type);
            for (int subtypeNum = subtypes.length - 1; subtypeNum >= 0; --subtypeNum) {
                types.add(subtypes[subtypeNum]);
            }
            types.add(this._type);
            return types;
        }
    }
}

