/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.refactoring;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.variables.BuildProperties;

public class PrincipalClassChange
extends Change {
    private ProjectAdapter _projectAdapter;
    private BuildProperties _buildProperties;
    private String _newName;

    public PrincipalClassChange(ProjectAdapter projectAdapter, String newName) {
        this._projectAdapter = projectAdapter;
        this._buildProperties = projectAdapter.getBuildProperties();
        this._newName = newName;
    }

    public String getName() {
        return "Change Principal Class from " + this._buildProperties.getPrincipalClass(true) + " to " + this._newName;
    }

    public void initializeValidationData(IProgressMonitor _pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor _pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        return status;
    }

    public Change perform(IProgressMonitor _pm) throws CoreException {
        String oldName = this._buildProperties.getPrincipalClass(true);
        this._buildProperties.setPrincipalClass(this._newName);
        try {
            this._buildProperties.save();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save build properties.", e);
        }
        PrincipalClassChange undoChange = new PrincipalClassChange(this._projectAdapter, oldName);
        return undoChange;
    }

    public Object getModifiedElement() {
        return this._buildProperties;
    }
}

