/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.actions.CutOperation;
import org.objectstyle.wolips.eomodeler.actions.EMAction;
import org.objectstyle.wolips.eomodeler.core.model.EOModelReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;
import org.objectstyle.wolips.eomodeler.editors.EOModelErrorDialog;

public class CutAction
extends EMAction {
    public void run() {
        try {
            Control focusControl = Display.getCurrent().getFocusControl();
            if (focusControl instanceof Text) {
                ((Text)focusControl).cut();
                return;
            }
            if (focusControl instanceof StyledText) {
                ((StyledText)focusControl).cut();
                return;
            }
            Object[] selectedObjects = this.getSelectedObjects();
            if (selectedObjects != null) {
                Set<EOModelReferenceFailure> referenceFailures = EOModelUtils.getReferenceFailures(selectedObjects);
                if (!referenceFailures.isEmpty()) {
                    new EOModelErrorDialog(this.getWindow().getShell(), referenceFailures).open();
                } else {
                    CutOperation operation = new CutOperation(selectedObjects);
                    operation.addContext(EOModelUtils.getUndoContext(selectedObjects));
                    IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                    operationHistory.execute((IUndoableOperation)operation, null, null);
                }
            }
        }
        catch (Throwable t) {
            ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)t);
        }
    }

    public void runWithEvent(Event _event) {
        this.run();
    }

    public void run(IAction _action) {
        this.run();
    }
}

