/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.actions.GenerateSQLDialog;
import org.objectstyle.wolips.eomodeler.core.model.EODatabaseConfig;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.sql.MigrationGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateMigrationDialog
extends Dialog {
    private Button _createSelectedEntitiesButton;
    private Text _migrationText;
    private EOModel _model;
    private List<EOEntity> _entities;
    private Set<EODatabaseConfig> _databaseConfigs;
    private ComboViewer _databaseConfigComboViewer;
    private FlagChangedHandler _flagChangeHander;

    public GenerateMigrationDialog(Shell parentShell, EOModel model, List<EOEntity> entities) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this._model = model;
        this._entities = entities;
        this._flagChangeHander = new FlagChangedHandler();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Migration Generation");
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, true);
        layout.marginTop = 10;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        layout.numColumns = 1;
        control.setLayout((Layout)layout);
        this._databaseConfigs = this._model.getDatabaseConfigs();
        if (this._databaseConfigs.size() > 1) {
            this._databaseConfigComboViewer = new ComboViewer(control, 8);
            GridData extraInfoData = new GridData(768);
            this._databaseConfigComboViewer.setContentProvider((IContentProvider)new GenerateSQLDialog.DatabaseConfigContentProvider());
            this._databaseConfigComboViewer.setLabelProvider((IBaseLabelProvider)new GenerateSQLDialog.DatabaseConfigLabelProvider());
            this._databaseConfigComboViewer.setInput(this._databaseConfigs);
            this._databaseConfigComboViewer.getCombo().setLayoutData((Object)extraInfoData);
            EODatabaseConfig activeDatabaseConfig = this._model.getActiveDatabaseConfig();
            if (activeDatabaseConfig != null) {
                this._databaseConfigComboViewer.setSelection((ISelection)new StructuredSelection((Object)activeDatabaseConfig));
            } else {
                this._databaseConfigComboViewer.setSelection((ISelection)new StructuredSelection((Object)this._databaseConfigs.iterator().next()));
            }
            this._databaseConfigComboViewer.addSelectionChangedListener((ISelectionChangedListener)this._flagChangeHander);
        }
        int entityCount = this._entities != null ? this._entities.size() : 0;
        this._createSelectedEntitiesButton = new Button(control, 32);
        this._createSelectedEntitiesButton.setText("Create Only Selected Entities");
        this._createSelectedEntitiesButton.setSelection(entityCount > 0);
        this._createSelectedEntitiesButton.addSelectionListener((SelectionListener)this._flagChangeHander);
        this._createSelectedEntitiesButton.setEnabled(entityCount > 0);
        this._migrationText = new Text(control, 2570);
        GridData sqlTextData = new GridData(1808);
        sqlTextData.heightHint = 300;
        sqlTextData.widthHint = 700;
        sqlTextData.verticalIndent = 10;
        sqlTextData.horizontalSpan = 2;
        this._migrationText.setLayoutData((Object)sqlTextData);
        this._migrationText.setText("Generating Migration. Please Wait ...");
        this.generateMigration();
        return control;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Button closeButton = new Button(composite, 8);
        closeButton.setText("Close");
        closeButton.addSelectionListener((SelectionListener)new CloseHandler());
        this.getShell().setDefaultButton(closeButton);
        return composite;
    }

    protected String yesNo(Button button) {
        return button.getSelection() ? "YES" : "NO";
    }

    protected Text getMigrationText() {
        return this._migrationText;
    }

    protected EODatabaseConfig getSelectedDatabaseConfig() {
        EODatabaseConfig selectedDatabaseConfig = null;
        if (this._databaseConfigComboViewer != null) {
            IStructuredSelection selection = (IStructuredSelection)this._databaseConfigComboViewer.getSelection();
            selectedDatabaseConfig = (EODatabaseConfig)selection.getFirstElement();
        } else {
            selectedDatabaseConfig = this._model.getActiveDatabaseConfig();
        }
        return selectedDatabaseConfig;
    }

    public void generateMigration() {
        try {
            List<EOEntity> entities = this._createSelectedEntitiesButton.getSelection() ? this._entities : null;
            String migrationText = MigrationGenerator.generate(this._model, entities);
            this.getMigrationText().setText(migrationText);
        }
        catch (Throwable t) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    GenerateMigrationDialog.this.getMigrationText().setText("Migration Failed.");
                }
            });
            ErrorUtils.openErrorDialog((Shell)this.getShell(), (Throwable)t);
        }
    }

    protected String getMigrationString() {
        return this._migrationText.getText();
    }

    public class CloseHandler
    implements SelectionListener {
        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            GenerateMigrationDialog.this.close();
        }
    }

    public class FlagChangedHandler
    implements SelectionListener,
    ISelectionChangedListener {
        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            GenerateMigrationDialog.this.generateMigration();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            GenerateMigrationDialog.this.generateMigration();
        }
    }
}

