/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.actions.EMAction;
import org.objectstyle.wolips.eomodeler.core.model.EODatabaseConfig;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.IEOClassLoaderFactory;
import org.objectstyle.wolips.eomodeler.core.sql.IEOSQLReverseEngineer;
import org.objectstyle.wolips.eomodeler.core.sql.IEOSQLReverseEngineerFactory;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;
import org.objectstyle.wolips.eomodeler.editors.EOModelErrorDialog;
import org.objectstyle.wolips.eomodeler.utils.StringLabelProvider;

public class ReverseEngineerAction
extends EMAction {
    public void run(IAction action) {
        try {
            Object selectedObject = this.getSelectedObject();
            EOModel model = EOModelUtils.getRelatedModel(selectedObject);
            if (model == null) {
                MessageDialog.openError((Shell)this.getWindow().getShell(), (String)"Select a Model", (String)"Select a model to reverse engineer into.");
            } else {
                EODatabaseConfig activeDatabaseConfig = model.getActiveDatabaseConfig();
                ClassLoader eomodelClassLoader = IEOClassLoaderFactory.Utility.createClassLoader(model);
                IEOSQLReverseEngineer reverseEngineer = IEOSQLReverseEngineerFactory.Utility.reverseEngineerFactory().reverseEngineer(activeDatabaseConfig, eomodelClassLoader);
                List<String> tableNames = reverseEngineer.reverseEngineerTableNames();
                ListSelectionDialog dlg = new ListSelectionDialog(this.getWindow().getShell(), tableNames, (IStructuredContentProvider)new StringContentProvider(), (ILabelProvider)new StringLabelProvider(), "Select the tables to reverse engineer:");
                dlg.setInitialSelections(tableNames.toArray());
                dlg.setTitle("Reverse Engineer");
                if (dlg.open() == 0) {
                    Object[] selectedTableNameObjs = dlg.getResult();
                    String[] selectedTableNames = new String[selectedTableNameObjs.length];
                    System.arraycopy(selectedTableNameObjs, 0, selectedTableNames, 0, selectedTableNameObjs.length);
                    List<String> selectedTableNamesList = Arrays.asList(selectedTableNames);
                    File reverseEngineeredEOModelFolder = reverseEngineer.reverseEngineerWithTableNamesIntoModel(selectedTableNamesList);
                    HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
                    model.importEntitiesFromModel(reverseEngineeredEOModelFolder.toURL(), failures);
                    if (failures.size() > 0) {
                        EOModelErrorDialog dialog = new EOModelErrorDialog(this.getWindow().getShell(), failures);
                        dialog.open();
                    }
                    model.setReverseEngineered(true);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)e);
        }
    }

    protected class StringContentProvider
    implements IStructuredContentProvider {
        protected StringContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

