/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.entities;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.objectstyle.wolips.baseforuiplugins.utils.KeyComboBoxCellEditor;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.utils.TablePropertyCellModifier;
import org.objectstyle.wolips.eomodeler.utils.TableUtils;

public class EOEntitiesCellModifier
extends TablePropertyCellModifier {
    private static final String NO_PARENT_VALUE = Messages.getString("EOEntitiesCellModifier.noParent");
    private CellEditor[] myCellEditors;
    private List myEntityNames;

    public EOEntitiesCellModifier(TableViewer _modelTableViewer, CellEditor[] _cellEditors) {
        super(_modelTableViewer);
        this.myCellEditors = _cellEditors;
    }

    protected boolean _canModify(Object _element, String _property) {
        if ("parent".equals(_property)) {
            EOModel model = (EOModel)this.getTableViewer().getInput();
            this.myEntityNames = new LinkedList<String>(model.getModelGroup().getEntityNames());
            this.myEntityNames.add(0, NO_PARENT_VALUE);
            String[] entityNames = this.myEntityNames.toArray(new String[this.myEntityNames.size()]);
            int columnNumber = TableUtils.getColumnNumberForTablePropertyNamed(EOEntity.class.getName(), _property);
            if (columnNumber != -1) {
                KeyComboBoxCellEditor cellEditor = (KeyComboBoxCellEditor)this.myCellEditors[columnNumber];
                cellEditor.setItems(entityNames);
            }
        }
        return true;
    }

    public Object getValue(Object _element, String _property) {
        EOEntity entity = (EOEntity)_element;
        Object value = null;
        if ("parent".equals(_property)) {
            EOEntity parent = entity.getParent();
            String parentName = parent == null ? NO_PARENT_VALUE : parent.getName();
            value = this.myEntityNames.indexOf(parentName);
        } else {
            value = super.getValue(_element, _property);
        }
        return value;
    }

    protected boolean _modify(Object _element, String _property, Object _value) throws Throwable {
        boolean modified = false;
        EOEntity entity = (EOEntity)_element;
        if ("parent".equals(_property)) {
            String parentName;
            Integer parentNameIndex = (Integer)_value;
            int parentNameIndexInt = parentNameIndex;
            String string = parentName = parentNameIndexInt == -1 ? null : (String)this.myEntityNames.get(parentNameIndexInt);
            if (NO_PARENT_VALUE.equals(parentName)) {
                entity.setParent(null);
            } else {
                EOEntity parent = entity.getModel().getModelGroup().getEntityNamed(parentName);
                entity.setParent(parent);
            }
            modified = true;
        }
        return modified;
    }
}

