/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.outline;

import java.util.Arrays;
import java.util.TreeSet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.EOArgument;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.EODatabaseConfig;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOEntityIndex;
import org.objectstyle.wolips.eomodeler.core.model.EOFetchSpecification;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelContainer;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.model.EORelationshipPath;
import org.objectstyle.wolips.eomodeler.core.model.EOStoredProcedure;
import org.objectstyle.wolips.eomodeler.outline.EOModelLoading;
import org.objectstyle.wolips.eomodeler.outline.EOSortableEOModelObjectComparator;

public class EOModelOutlineContentProvider
implements ITreeContentProvider {
    private Object _modelContainer;
    private boolean _showEntities;
    private boolean _showAttributes;
    private boolean _showRelationships;
    private boolean _showFetchSpecs;
    private boolean _showStoredProcedures;
    private boolean _showEntityIndexes;
    private boolean _showDatabaseConfigs;
    private boolean _showNonClassProperties;

    public EOModelOutlineContentProvider(boolean showEntities, boolean showAttributes, boolean showRelationships, boolean showFetchSpecs, boolean showStoredProcedures, boolean showDatabaseConfigs, boolean showEntityIndexes, boolean showNonClassProperties) {
        this._showEntities = showEntities;
        this._showAttributes = showAttributes;
        this._showRelationships = showRelationships;
        this._showFetchSpecs = showFetchSpecs;
        this._showStoredProcedures = showStoredProcedures;
        this._showDatabaseConfigs = showDatabaseConfigs;
        this._showEntityIndexes = showEntityIndexes;
        this._showNonClassProperties = showNonClassProperties;
    }

    public void setShowNonClassProperties(boolean showNonClassProperties) {
        this._showNonClassProperties = showNonClassProperties;
    }

    public boolean isShowNonClassProperties() {
        return this._showNonClassProperties;
    }

    public Object[] getChildren(Object _parentElement) {
        Object[] children;
        if (_parentElement instanceof EOModelLoading) {
            EOModelLoading loading = (EOModelLoading)_parentElement;
            children = loading.getModel() == null ? new Object[]{"Please Wait ..."} : new Object[]{"Loading " + loading.getModel().getName() + " ..."};
        } else if (_parentElement instanceof EOModelContainer) {
            EOModelContainer modelContainer = (EOModelContainer)_parentElement;
            EOModel model = modelContainer.getModel();
            children = model == null ? new Object[]{"No Model Loaded"} : new Object[]{model};
        } else if (_parentElement instanceof EOModelGroup) {
            EOModelGroup modelGroup = (EOModelGroup)_parentElement;
            TreeSet<Object> modelGroupChildren = new TreeSet<Object>(new EOSortableEOModelObjectComparator());
            modelGroupChildren.addAll(modelGroup.getModels());
            children = modelGroupChildren.toArray();
        } else if (_parentElement instanceof EOModel) {
            EOModel model = (EOModel)_parentElement;
            TreeSet<Object> modelChildren = new TreeSet<Object>(new EOSortableEOModelObjectComparator());
            if (this._showEntities) {
                modelChildren.addAll(model.getEntities());
            }
            if (this._showStoredProcedures) {
                modelChildren.addAll(model.getStoredProcedures());
            }
            if (this._showDatabaseConfigs) {
                modelChildren.addAll(model.getDatabaseConfigs());
            }
            children = modelChildren.toArray();
        } else if (_parentElement instanceof EOEntity) {
            EOEntity entity = (EOEntity)_parentElement;
            TreeSet<Object> entityChildren = new TreeSet<Object>(new EOSortableEOModelObjectComparator());
            if (this._showAttributes) {
                if (this._showNonClassProperties) {
                    entityChildren.addAll(entity.getAttributes());
                } else {
                    entityChildren.addAll(entity.getClassAttributes());
                }
            }
            if (this._showRelationships) {
                if (this._showNonClassProperties) {
                    entityChildren.addAll(entity.getRelationships());
                } else {
                    entityChildren.addAll(entity.getClassRelationships());
                }
            }
            if (this._showFetchSpecs) {
                entityChildren.addAll(entity.getFetchSpecs());
            }
            if (this._showEntityIndexes) {
                entityChildren.addAll(entity.getEntityIndexes());
            }
            if (this._showAttributes && this._showRelationships) {
                entityChildren.addAll(entity.getChildrenEntities());
            }
            children = entityChildren.toArray();
        } else if (_parentElement instanceof EORelationship) {
            EORelationship relationship = (EORelationship)_parentElement;
            TreeSet<Object> relationshipPathChildren = new TreeSet<Object>(new EOSortableEOModelObjectComparator());
            relationshipPathChildren.addAll(Arrays.asList(new EORelationshipPath(null, relationship).getChildren()));
            children = relationshipPathChildren.toArray();
        } else if (_parentElement instanceof EORelationshipPath) {
            EORelationshipPath relationshipPath = (EORelationshipPath)_parentElement;
            TreeSet<Object> relationshipPathChildren = new TreeSet<Object>(new EOSortableEOModelObjectComparator());
            relationshipPathChildren.addAll(Arrays.asList(relationshipPath.getChildren()));
            children = relationshipPathChildren.toArray();
        } else if (_parentElement instanceof EOStoredProcedure) {
            EOStoredProcedure storedProcedure = (EOStoredProcedure)_parentElement;
            TreeSet<Object> arguments = new TreeSet<Object>(new EOSortableEOModelObjectComparator());
            arguments.addAll(storedProcedure.getArguments());
            children = arguments.toArray();
        } else {
            children = new Object[]{};
        }
        return children;
    }

    public void dispose() {
    }

    public Object[] getElements(Object _inputElement) {
        return this.getChildren(_inputElement);
    }

    public Object getParent(Object _element) {
        EORelationshipPath parentRelationshipPath;
        Object parent = _element instanceof EOModelContainer ? null : (_element instanceof EOModel ? this._modelContainer : (_element instanceof EOEntity ? ((EOEntity)_element).getModel() : (_element instanceof EOAttribute ? ((EOAttribute)_element).getEntity() : (_element instanceof EOFetchSpecification ? ((EOFetchSpecification)_element).getEntity() : (_element instanceof EORelationship ? ((EORelationship)_element).getEntity() : (_element instanceof EOStoredProcedure ? ((EOStoredProcedure)_element).getModel() : (_element instanceof EODatabaseConfig ? ((EODatabaseConfig)_element).getModel() : (_element instanceof EOArgument ? ((EOArgument)_element).getStoredProcedure() : (_element instanceof AbstractEOAttributePath ? ((parentRelationshipPath = ((AbstractEOAttributePath)_element).getParentRelationshipPath()) == null ? ((AbstractEOAttributePath)_element).getChildIEOAttribute().getEntity() : parentRelationshipPath) : (_element instanceof EOEntityIndex ? ((EOEntityIndex)_element).getEntity() : null))))))))));
        return parent;
    }

    public boolean hasChildren(Object _element) {
        boolean hasChildren = true;
        if (_element instanceof EOModelLoading) {
            hasChildren = false;
        } else if (_element instanceof EOFetchSpecification) {
            hasChildren = false;
        } else if (_element instanceof EOAttribute) {
            hasChildren = false;
        } else if (_element instanceof EOAttributePath) {
            hasChildren = false;
        } else if (_element instanceof EOArgument) {
            hasChildren = false;
        } else if (_element instanceof EODatabaseConfig) {
            hasChildren = false;
        } else if (_element instanceof EOEntityIndex) {
            hasChildren = false;
        }
        return hasChildren;
    }

    public void inputChanged(Viewer _viewer, Object _oldInput, Object _newInput) {
        this._modelContainer = _newInput;
    }
}

