/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.deployment.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.objectstyle.wolips.ant.AntPlugin;
import org.objectstyle.wolips.deployment.ui.DeploymentPlugin;
import org.objectstyle.wolips.workbenchutilities.actions.AbstractActionOnIResource;

public abstract class AbstractInstallAction
extends AbstractActionOnIResource {
    protected void install(IProject[] projects) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(new Shell());
        Runnable runnable = new Runnable();
        runnable.projectsToBuild = projects;
        try {
            progressMonitorDialog.run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            DeploymentPlugin.getDefault().log(e);
        }
        catch (InterruptedException e) {
            DeploymentPlugin.getDefault().log(e);
        }
    }

    class Runnable
    implements IRunnableWithProgress {
        IProject[] projectsToBuild;
        String projectName = "";

        Runnable() {
        }

        public void run(IProgressMonitor monitor) {
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, this.projectsToBuild.length);
            for (int i = 0; i < this.projectsToBuild.length && !monitor.isCanceled(); ++i) {
                IProject iProjectToBuild = this.projectsToBuild[i];
                this.projectName = "Installing " + iProjectToBuild.getName();
                subProgressMonitor.subTask(this.projectName);
                IFile iFile = iProjectToBuild.getFile("build.xml");
                try {
                    AntPlugin.getDefault().launchAntInExternalVM(iFile, (IProgressMonitor)subProgressMonitor, true, "install");
                }
                catch (CoreException e) {
                    DeploymentPlugin.getDefault().log(e);
                }
                subProgressMonitor.worked(1);
            }
        }
    }
}

