/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.apieditor.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.FileEditorInput;
import org.objectstyle.wolips.apieditor.ApieditorPlugin;
import org.objectstyle.wolips.apieditor.editor.ApiEditor;
import org.objectstyle.wolips.apieditor.editor.ApiFormPage;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.bindings.api.ApiModel;
import org.objectstyle.wolips.bindings.api.ApiModelException;

public class CreatePage
extends ApiFormPage {
    public static String PAGE_ID = "org.objectstyle.wolips.wodclipse.api.CreatePage";

    public CreatePage(ApiEditor apiEditor, String title) {
        super(apiEditor, PAGE_ID, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        form.getBody().setLayout((Layout)layout);
        SashForm sashForm = new SashForm(form.getBody(), 0);
        toolkit.adapt((Control)sashForm, false, false);
        sashForm.setMenu(form.getBody().getMenu());
        sashForm.setLayoutData((Object)new GridData(1808));
        Section section = toolkit.createSection((Composite)sashForm, 128);
        section.setText("Create Api");
        section.marginWidth = 10;
        section.marginHeight = 5;
        toolkit.createCompositeSeparator((Composite)section);
        Composite client = toolkit.createComposite((Composite)section, 64);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.heightHint = 20;
        gd.widthHint = 100;
        final ApiEditor apiEditor = (ApiEditor)this.getEditor();
        boolean brokenApiFile = false;
        String brokenMessage = null;
        ApiModel apiModel = null;
        try {
            apiModel = apiEditor.getModel();
        }
        catch (Throwable throwable) {
            brokenApiFile = true;
            ApieditorPlugin.getDefault().debug(throwable);
            brokenMessage = StringUtils.getErrorMessage((Throwable)throwable);
        }
        if (apiModel == null) {
            if (brokenApiFile) {
                Label brokenLabel = new Label(client, 64);
                brokenLabel.setBackground(client.getBackground());
                brokenLabel.setText(brokenMessage);
                GridData labelData = new GridData(768);
                labelData.horizontalSpan = 2;
                brokenLabel.setLayoutData((Object)labelData);
            }
            Button createApiFileButton = brokenApiFile ? toolkit.createButton(client, "Recreate Api File", 8) : toolkit.createButton(client, "Create Api File", 8);
            gd = new GridData(2);
            createApiFileButton.setLayoutData((Object)gd);
            createApiFileButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    FileEditorInput fileEditorInput = (FileEditorInput)apiEditor.getEditorInput();
                    try {
                        IFile file = fileEditorInput.getFile();
                        if (file.exists()) {
                            file.delete(false, null);
                        }
                        new ApiModel(file);
                    }
                    catch (ApiModelException coreException) {
                        throw new RuntimeException("Failed to create .api file.", coreException);
                    }
                    catch (CoreException coreException) {
                        throw new RuntimeException("Failed to delete existing .api file.", coreException);
                    }
                    apiEditor.removePage(0);
                    apiEditor.addPages();
                    apiEditor.activateFirstPage();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        section.setClient((Control)client);
        form.updateToolBar();
    }
}

