/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wooeditor.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.objectstyle.wolips.wodclipse.core.woo.DisplayGroup;
import org.objectstyle.wolips.wodclipse.core.woo.WooModel;
import org.objectstyle.wolips.wooeditor.editor.DisplayGroupDetailsPage;
import org.objectstyle.wolips.wooeditor.editor.WooEditor;

public class DisplayGroupPageBlock
extends MasterDetailsBlock {
    private FormPage page;
    private TableViewer viewer;
    private IManagedForm myManagedForm;

    public DisplayGroupPageBlock(FormPage formPage) {
        this.page = formPage;
    }

    public void createContent(IManagedForm managedForm) {
        super.createContent(managedForm);
        PropertyChangeListener displayGroupListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("DISPLAY_GROUP_NAME".equals(event.getPropertyName())) {
                    DisplayGroupPageBlock.this.viewer.update(event.getSource(), null);
                }
            }
        };
        WooEditor wooEditor = (WooEditor)this.page.getEditor();
        WooModel wooModel = wooEditor.getModel();
        wooModel.addPropertyChangeListener(displayGroupListener);
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        this.myManagedForm = managedForm;
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(parent, 256);
        section.setText("Display Groups");
        section.setDescription("The list contains display groups from the component whose details are editable on the right");
        section.marginWidth = 10;
        section.marginHeight = 5;
        Composite displayGroupsClient = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        displayGroupsClient.setLayout((Layout)layout);
        Table t = toolkit.createTable(displayGroupsClient, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 20;
        gd.widthHint = 80;
        gd.horizontalSpan = 1;
        t.setLayoutData((Object)gd);
        toolkit.paintBordersFor(displayGroupsClient);
        Composite buttonsGroup = new Composite(displayGroupsClient, 0);
        GridData buttonsLayoutData = new GridData(2);
        buttonsGroup.setLayoutData((Object)buttonsLayoutData);
        buttonsGroup.setBackground(displayGroupsClient.getBackground());
        RowLayout buttonsLayout = new RowLayout(512);
        buttonsLayout.fill = true;
        buttonsLayout.justify = true;
        buttonsLayout.marginTop = 0;
        buttonsLayout.marginRight = 0;
        buttonsLayout.marginBottom = 0;
        buttonsLayout.marginLeft = 0;
        buttonsGroup.setLayout((Layout)buttonsLayout);
        Button addButton = toolkit.createButton(buttonsGroup, "Add", 8);
        addButton.addSelectionListener((SelectionListener)new AddButtonListener());
        Button removeButton = toolkit.createButton(buttonsGroup, "Remove", 8);
        removeButton.addSelectionListener((SelectionListener)new RemoveButtonListener());
        section.setClient((Control)displayGroupsClient);
        final SectionPart spart = new SectionPart(section);
        managedForm.addPart((IFormPart)spart);
        this.viewer = new TableViewer(t);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
        this.viewer.setContentProvider((IContentProvider)new MasterContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MasterLabelProvider());
        this.viewer.setInput((Object)this.page.getEditor().getEditorInput());
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    public SashForm getParentSashForm() {
        return this.sashForm;
    }

    protected void registerPages(DetailsPart details) {
        details.registerPage(DisplayGroup.class, (IDetailsPage)new DisplayGroupDetailsPage());
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void update() {
        this.viewer.update((Object)this.viewer.getSelection(), null);
    }

    private class RemoveButtonListener
    implements SelectionListener {
        private RemoveButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                Object element;
                WooEditor wooEditor = (WooEditor)DisplayGroupPageBlock.this.page.getEditor();
                StructuredSelection selection = (StructuredSelection)DisplayGroupPageBlock.this.viewer.getSelection();
                int selectionIndex = DisplayGroupPageBlock.this.viewer.getTable().getSelectionIndex();
                for (Object displayGroup : selection.toList()) {
                    wooEditor.getModel().removeDisplayGroup((DisplayGroup)displayGroup);
                }
                DisplayGroupPageBlock.this.viewer.refresh();
                int count = DisplayGroupPageBlock.this.viewer.getTable().getItemCount();
                if (count <= selectionIndex) {
                    selectionIndex = count - 1;
                }
                if ((element = DisplayGroupPageBlock.this.viewer.getElementAt(selectionIndex)) != null) {
                    DisplayGroupPageBlock.this.viewer.editElement(element, selectionIndex);
                }
                DisplayGroupPageBlock.this.myManagedForm.dirtyStateChanged();
            }
            catch (Throwable tx) {
                tx.printStackTrace();
                throw new RuntimeException("Failed to open .woo file.", tx);
            }
        }
    }

    protected static class MasterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected MasterLabelProvider() {
        }

        public Image getColumnImage(Object obj, int index) {
            if (obj instanceof DisplayGroup) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            }
            return null;
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof DisplayGroup) {
                DisplayGroup displayGroup = (DisplayGroup)obj;
                return displayGroup.getName();
            }
            return obj.toString();
        }
    }

    protected class MasterContentProvider
    implements IStructuredContentProvider {
        protected MasterContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            try {
                if (inputElement instanceof IEditorInput) {
                    WooEditor wooEditor = (WooEditor)DisplayGroupPageBlock.this.page.getEditor();
                    Object[] displayGroups = wooEditor.getModel().getDisplayGroups();
                    return displayGroups;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return new Object[0];
        }

        public void inputChanged(Viewer inViewer, Object oldInput, Object newInput) {
        }
    }

    private class AddButtonListener
    implements SelectionListener {
        private AddButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                WooEditor wooEditor = (WooEditor)DisplayGroupPageBlock.this.page.getEditor();
                int nextId = 1;
                for (DisplayGroup dg : wooEditor.getModel().getDisplayGroups()) {
                    String index;
                    int j;
                    if (!dg.getName().matches("^displayGroup[0-9]*$") || nextId > (j = Integer.valueOf(index = dg.getName().replaceAll("^displayGroup([0-9]*)$", "$1")).intValue())) continue;
                    nextId = j + 1;
                }
                wooEditor.getModel().createDisplayGroup("displayGroup" + nextId);
                DisplayGroupPageBlock.this.viewer.refresh();
                int count = DisplayGroupPageBlock.this.viewer.getTable().getItemCount();
                Object element = DisplayGroupPageBlock.this.viewer.getElementAt(count - 1);
                DisplayGroupPageBlock.this.viewer.editElement(element, count - 1);
                DisplayGroupPageBlock.this.myManagedForm.dirtyStateChanged();
            }
            catch (Throwable tx) {
                throw new RuntimeException("Failed to open .woo file.", tx);
            }
        }
    }
}

