/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wooeditor.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadioGroup {
    private ListenerList selectionEventListeners = new ListenerList();
    private List<Button> group = new ArrayList<Button>();
    private Button selected;
    private SelectionListener changeListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            RadioGroup.this.setSelection(((Button)e.getSource()).getText());
        }

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            if (b.getSelection()) {
                RadioGroup.this.setSelection(b.getText());
            }
        }
    };

    public boolean add(Button button) {
        button.addSelectionListener(this.changeListener);
        return this.group.add(button);
    }

    public void add(int index, Button button) {
        button.addSelectionListener(this.changeListener);
        this.group.add(index, button);
    }

    public boolean addAll(Collection<Button> collection) {
        for (Button button : collection) {
            button.addSelectionListener(this.changeListener);
        }
        return this.group.addAll(collection);
    }

    public boolean addAll(int index, Collection<Button> collection) {
        for (Button button : collection) {
            button.addSelectionListener(this.changeListener);
        }
        return this.group.addAll(index, collection);
    }

    public void clear() {
        for (Button button : this.group) {
            button.removeSelectionListener(this.changeListener);
        }
        this.group.clear();
    }

    public boolean contains(Object value) {
        return this.group.contains(value);
    }

    public boolean containsAll(Collection<Button> collection) {
        return this.group.containsAll(collection);
    }

    public Object get(int index) {
        return this.group.get(index);
    }

    public int indexOf(Object value) {
        return this.group.indexOf(value);
    }

    public boolean isEmpty() {
        return this.group.isEmpty();
    }

    public Iterator<Button> iterator() {
        return this.group.iterator();
    }

    public int lastIndexOf(Object value) {
        return this.group.lastIndexOf(value);
    }

    public ListIterator<Button> listIterator() {
        return this.group.listIterator();
    }

    public ListIterator<Button> listIterator(int arg0) {
        return this.group.listIterator(arg0);
    }

    public boolean remove(Button button) {
        button.removeSelectionListener(this.changeListener);
        return this.group.remove(button);
    }

    public Object remove(int index) {
        this.group.get(index).removeSelectionListener(this.changeListener);
        return this.group.remove(index);
    }

    public boolean removeAll(Collection<Button> arg0) {
        for (Button button : this.group) {
            button.removeSelectionListener(this.changeListener);
        }
        return this.group.removeAll(arg0);
    }

    public int size() {
        return this.group.size();
    }

    public List<Button> subList(int arg0, int arg1) {
        return this.group.subList(arg0, arg1);
    }

    public Object[] toArray() {
        return this.group.toArray();
    }

    public Object[] toArray(Object[] arg0) {
        return this.group.toArray(arg0);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionEventListeners.remove((Object)selectionListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionEventListeners.add((Object)selectionListener);
    }

    public void setSelection(Object value) {
        if (this.group.size() < 1) {
            return;
        }
        for (Button i : this.group) {
            if (i.getText().equals(value)) {
                this.selected = i;
                continue;
            }
            i.setSelection(false);
        }
        if (this.selected != null) {
            this.selected.setSelection(true);
            Event e = new Event();
            e.type = 13;
            e.item = this.selected;
            e.widget = this.selected;
            e.text = this.selected.getText();
            this.fireSelectionEvent(new SelectionEvent(e));
        }
    }

    private void fireSelectionEvent(SelectionEvent e) {
        if (e.item != null && e.item.isDisposed()) {
            return;
        }
        Object[] l = this.selectionEventListeners.getListeners();
        for (int i = 0; i < l.length; ++i) {
            ((SelectionListener)l[i]).widgetSelected(e);
        }
    }

    public Object getSelection() {
        if (this.group.size() < 1) {
            return null;
        }
        return this.selected.getText();
    }
}

