/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.launching.antlauncher.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Display;
import org.objectstyle.wolips.launching.LaunchingPlugin;

public class BuildFailedConsoleLineTracker
implements IConsoleLineTracker {
    public static final String ATTR_BUILD_FAILED_CONSOLE_LINE_TRACKER_ENABLED = "org.objectstyle.wolips.launching.antlauncher.internal.BuildFailedConsoleLineTrackerEnabled";
    private boolean isDefaultAntLauncherConsole;
    private IConsole currentConsole;

    public void init(IConsole console) {
        this.currentConsole = console;
        this.isDefaultAntLauncherConsole = false;
        try {
            this.isDefaultAntLauncherConsole = console.getProcess().getLaunch().getLaunchConfiguration().getAttribute(ATTR_BUILD_FAILED_CONSOLE_LINE_TRACKER_ENABLED, false);
        }
        catch (CoreException e) {
            LaunchingPlugin.getDefault().log(e);
        }
    }

    public void lineAppended(IRegion line) {
        if (!this.isDefaultAntLauncherConsole) {
            return;
        }
        int offset = line.getOffset();
        int length = line.getLength();
        String text = null;
        try {
            text = this.currentConsole.getDocument().get(offset, length);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        if (text != null && text.startsWith("BUILD FAILED")) {
            try {
                final String projectName = this.currentConsole.getProcess().getLaunch().getLaunchConfiguration().getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "UNKNOWN");
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        Status status = new Status(4, "org.objectstyle.wolips.launching", 4, "Error while building project: " + projectName + " with the ant builder. Take a look into the console for details.\n\nYou mave have to enable the logging of the ant output in the WOLips preferences.", null);
                        ErrorDialog.openError(null, (String)"Error", (String)"BUILD FAILED", (IStatus)status);
                    }
                });
            }
            catch (CoreException e) {
                LaunchingPlugin.getDefault().log(e);
            }
        }
    }

    public void dispose() {
        this.currentConsole = null;
    }
}

