/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.launching.classpath;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver2;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;

public class WORuntimeClasspathEntryResolver
implements IRuntimeClasspathEntryResolver2 {
    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        IJavaProject project = entry.getJavaProject();
        if (project == null) {
            project = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        }
        if (project == null || entry == null) {
            return new IRuntimeClasspathEntry[0];
        }
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
        if (container == null) {
            this.abort(MessageFormat.format(LaunchingMessages.JavaRuntime_Could_not_resolve_classpath_container___0__1, entry.getPath().toString()), null);
            return null;
        }
        IClasspathEntry[] cpes = container.getClasspathEntries();
        int property = -1;
        switch (container.getKind()) {
            case 1: {
                property = 3;
                break;
            }
            case 3: {
                property = 1;
                break;
            }
            case 2: {
                property = 2;
            }
        }
        ArrayList<Object> resolved = new ArrayList<Object>(cpes.length);
        for (IClasspathEntry cpe : cpes) {
            if (cpe.getEntryKind() == 2) {
                IRuntimeClasspathEntry[] entries;
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(cpe.getPath().segment(0));
                IJavaProject jp = JavaCore.create((IProject)p);
                IRuntimeClasspathEntry classpath = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)jp);
                for (IRuntimeClasspathEntry e : entries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)classpath, (IJavaProject)jp)) {
                    if (resolved.contains(e)) continue;
                    resolved.add(e);
                }
                continue;
            }
            RuntimeClasspathEntry e = new RuntimeClasspathEntry(cpe);
            if (resolved.contains(e)) continue;
            resolved.add(e);
        }
        IRuntimeClasspathEntry[] result = new IRuntimeClasspathEntry[resolved.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (IRuntimeClasspathEntry)resolved.get(i);
            result[i].setClasspathProperty(property);
        }
        return result;
    }

    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project) throws CoreException {
        if (project == null || entry == null) {
            return new IRuntimeClasspathEntry[0];
        }
        ProjectAdapter projectAdapter = (ProjectAdapter)project.getProject().getAdapter(ProjectAdapter.class);
        IClasspathEntry cp = entry.getClasspathEntry();
        if (projectAdapter != null && projectAdapter.isFramework() && cp != null && !cp.isExported() && cp.getPath() != null && cp.getPath().segmentCount() > 0 && "WOFramework".equals(cp.getPath().segment(0))) {
            return new IRuntimeClasspathEntry[0];
        }
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
        if (container == null) {
            this.abort(MessageFormat.format(LaunchingMessages.JavaRuntime_Could_not_resolve_classpath_container___0__1, entry.getPath().toString()), null);
            return null;
        }
        IClasspathEntry[] cpes = container.getClasspathEntries();
        int property = -1;
        switch (container.getKind()) {
            case 1: {
                property = 3;
                break;
            }
            case 3: {
                property = 1;
                break;
            }
            case 2: {
                property = 2;
            }
        }
        ArrayList<Object> resolved = new ArrayList<Object>(cpes.length);
        for (IClasspathEntry cpe : cpes) {
            if (cpe.getEntryKind() == 2) {
                IRuntimeClasspathEntry[] entries;
                IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(cpe.getPath().segment(0));
                IJavaProject jp = JavaCore.create((IProject)p);
                IRuntimeClasspathEntry classpath = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)jp);
                for (IRuntimeClasspathEntry e : entries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)classpath, (IJavaProject)jp)) {
                    if (resolved.contains(e)) continue;
                    resolved.add(e);
                }
                continue;
            }
            RuntimeClasspathEntry e = new RuntimeClasspathEntry(cpe);
            if (resolved.contains(e)) continue;
            resolved.add(e);
        }
        IRuntimeClasspathEntry[] result = new IRuntimeClasspathEntry[resolved.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (IRuntimeClasspathEntry)resolved.get(i);
            result[i].setClasspathProperty(property);
        }
        return result;
    }

    private void abort(String message, Throwable exception) throws CoreException {
        this.abort(message, 150, exception);
    }

    private void abort(String message, int code, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public IVMInstall resolveVMInstall(IClasspathEntry entry) throws CoreException {
        return null;
    }

    public boolean isVMInstallReference(IClasspathEntry entry) {
        return false;
    }
}

