/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.launching.ui;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.objectstyle.wolips.baseforplugins.util.ArrayUtilities;
import org.objectstyle.wolips.baseforplugins.util.StringUtilities;
import org.objectstyle.wolips.launching.LaunchingMessages;
import org.objectstyle.wolips.launching.LaunchingPlugin;
import org.objectstyle.wolips.launching.ui.AbstractWOArgumentsTab;
import org.objectstyle.wolips.preferences.ILaunchInfo;
import org.objectstyle.wolips.preferences.Preferences;
import org.objectstyle.wolips.preferences.PreferencesMessages;

public class CommonWOArgumentsTab
extends AbstractWOArgumentsTab {
    private Table includeTable;
    private Button addButton;
    private Button removeButton;
    private Button changeButton;
    private Vector<String> allParameter;
    private Vector<String> allArguments;
    protected static final String EMPTY_STRING = "";

    public void createControl(Composite parentComposite) {
        Composite parent = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        parent.setLayoutData((Object)data);
        Label l1 = new Label(parent, 0);
        l1.setText(PreferencesMessages.getString((String)"LaunchPreferencesPage.label"));
        data = new GridData(2);
        data.horizontalSpan = 3;
        l1.setLayoutData((Object)data);
        this.includeTable = new Table(parent, 2080);
        GridData gd = new GridData(768);
        gd.widthHint = 150;
        gd.heightHint = 250;
        this.includeTable.setLayoutData((Object)gd);
        this.includeTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CommonWOArgumentsTab.this.handleSelection();
                CommonWOArgumentsTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(PreferencesMessages.getString((String)"LaunchPreferencesPage.add"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = 20;
        data.heightHint = Math.max(data.heightHint, this.addButton.computeSize((int)-1, (int)-1, (boolean)true).y);
        int widthHint = 100;
        data.widthHint = Math.max(widthHint, this.addButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CommonWOArgumentsTab.this.addIgnore();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(PreferencesMessages.getString((String)"LaunchPreferencesPage.remove"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = 20;
        data.heightHint = Math.max(data.heightHint, this.removeButton.computeSize((int)-1, (int)-1, (boolean)true).y);
        widthHint = 100;
        data.widthHint = Math.max(widthHint, this.removeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CommonWOArgumentsTab.this.removeIgnore();
            }
        });
        this.changeButton = new Button(buttons, 8);
        this.changeButton.setText(PreferencesMessages.getString((String)"LaunchPreferencesPage.change"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = 20;
        data.heightHint = Math.max(data.heightHint, this.changeButton.computeSize((int)-1, (int)-1, (boolean)true).y);
        widthHint = 100;
        data.widthHint = Math.max(widthHint, this.changeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.changeButton.setLayoutData((Object)data);
        this.changeButton.setEnabled(false);
        this.changeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CommonWOArgumentsTab.this.changeArgument();
            }
        });
        Dialog.applyDialogFont((Control)parent);
        this.setControl((Control)parent);
    }

    private void fillTable(ILaunchInfo[] launchInfoArray) {
        this.allArguments = new Vector();
        this.allParameter = new Vector();
        this.includeTable.removeAll();
        Arrays.sort(launchInfoArray);
        for (int i = 0; i < launchInfoArray.length; ++i) {
            ILaunchInfo launchInfo = launchInfoArray[i];
            TableItem item = new TableItem(this.includeTable, 0);
            item.setText(StringUtilities.toCommandlineParameterFormat((String)launchInfo.getParameter(), (String)launchInfo.getArgument(), (boolean)false));
            this.allParameter.add(launchInfo.getParameter());
            this.allArguments.add(launchInfo.getArgument());
            item.setChecked(launchInfo.isEnabled());
        }
    }

    protected void addIgnore() {
        InputDialog parameterDialog = new InputDialog(this.getShell(), PreferencesMessages.getString((String)"LaunchPreferencesPage.enterParameterShort"), Preferences.getString((String)"IgnorePreferencePage.enterPatternLong"), null, null);
        parameterDialog.open();
        if (parameterDialog.getReturnCode() != 0) {
            return;
        }
        InputDialog argumentDialog = new InputDialog(this.getShell(), PreferencesMessages.getString((String)"LaunchPreferencesPage.enterArgumentShort"), Preferences.getString((String)"IgnorePreferencePage.enterPatternLong"), null, null);
        argumentDialog.open();
        if (argumentDialog.getReturnCode() != 0) {
            return;
        }
        String parameter = parameterDialog.getValue();
        String argument = argumentDialog.getValue();
        if (parameter.equals(EMPTY_STRING) || argument.equals(EMPTY_STRING)) {
            return;
        }
        if (this.itemExist(parameter)) {
            return;
        }
        TableItem item = new TableItem(this.includeTable, 0);
        item.setText(StringUtilities.toCommandlineParameterFormat((String)parameter, (String)argument, (boolean)false));
        this.allParameter.add(parameter);
        this.allArguments.add(argument);
        item.setChecked(true);
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    private boolean itemExist(String item) {
        TableItem[] items = this.includeTable.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getText(1).equals(item)) continue;
            MessageDialog.openWarning((Shell)this.getShell(), (String)PreferencesMessages.getString((String)"LaunchPreferencesPage.parameterExistsShort"), (String)Preferences.getString((String)"IgnorePreferencePage.patternExistsLong"));
            return true;
        }
        return false;
    }

    protected void removeIgnore() {
        int[] selection = this.includeTable.getSelectionIndices();
        this.includeTable.remove(selection);
        if (selection == null) {
            return;
        }
        int[] newIndices = new int[selection.length];
        System.arraycopy(selection, 0, newIndices, 0, selection.length);
        ArrayUtilities.sort((int[])selection);
        int last = -1;
        for (int i = 0; i < newIndices.length; ++i) {
            int index = newIndices[i];
            if (index != last || i == 0) {
                this.allParameter.remove(index);
                this.allArguments.remove(index);
            }
            last = index;
        }
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    protected void changeArgument() {
        int[] selection = this.includeTable.getSelectionIndices();
        if (selection.length != 1) {
            return;
        }
        int index = selection[0];
        String parameter = this.allParameter.elementAt(index);
        InputDialog argumentDialog = new InputDialog(this.getShell(), parameter + " " + PreferencesMessages.getString((String)"LaunchPreferencesPage.enterArgumentShort"), Preferences.getString((String)"IgnorePreferencePage.enterPatternLong"), this.allArguments.elementAt(index), null);
        argumentDialog.open();
        if (argumentDialog.getReturnCode() != 0) {
            return;
        }
        String argument = argumentDialog.getValue();
        TableItem item = this.includeTable.getItem(index);
        item.setText(StringUtilities.toCommandlineParameterFormat((String)parameter, (String)argument, (boolean)false));
        this.allArguments.setElementAt(argument, index);
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    protected void handleSelection() {
        if (this.includeTable.getSelectionCount() > 0) {
            this.removeButton.setEnabled(true);
            this.changeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.changeButton.setEnabled(false);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public boolean isValid(ILaunchConfiguration config) {
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        String string = this.getDefaultArguments(config);
        config.setAttribute("org.objectstyle.wolips.launchinfo", string);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String string = configuration.getAttribute("org.objectstyle.wolips.launchinfo", Preferences.getLaunchGlobal());
            this.fillTable(Preferences.getLaunchInfoFrom((String)string));
        }
        catch (CoreException e) {
            this.setErrorMessage(LaunchingMessages.getString("WOArgumentsTab.Exception_occurred_reading_configuration___15") + e.getStatus().getMessage());
            LaunchingPlugin.getDefault().log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int count = this.includeTable.getItemCount();
        String[] parameter = new String[count];
        String[] arguments = new String[count];
        boolean[] enabled = new boolean[count];
        TableItem[] items = this.includeTable.getItems();
        for (int i = 0; i < count; ++i) {
            parameter[i] = this.allParameter.get(i);
            arguments[i] = this.allArguments.get(i);
            enabled[i] = items[i].getChecked();
        }
        String string = Preferences.LaunchInfoToString((String[])parameter, (String[])arguments, (boolean[])enabled);
        configuration.setAttribute("org.objectstyle.wolips.launchinfo", string);
    }

    public String getName() {
        return LaunchingMessages.getString("CommonWOArgumentsTab.Name");
    }

    public Image getImage() {
        return LaunchingPlugin.getImageDescriptor("icons/launching/arguments-tab.gif").createImage();
    }

    private String getDefaultArguments(ILaunchConfigurationWorkingCopy config) {
        try {
            IResource distFolder;
            IResource product;
            String path = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (resource != null && resource instanceof IContainer && resource.exists() && (product = (distFolder = ((IContainer)resource).findMember("dist")) instanceof IContainer && distFolder.exists() ? ((IContainer)distFolder).findMember(path.toString() + ".woa") : ((IContainer)resource).findMember(path.toString() + ".woa")) != null && product instanceof IContainer && product.exists()) {
                config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, ((IContainer)product).getFullPath().toString().substring(1));
            }
        }
        catch (Exception anException) {
            LaunchingPlugin.getDefault().log(anException);
        }
        return Preferences.getLaunchGlobal();
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
        this.getControl().update();
        this.includeTable.update();
    }
}

