/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.completion;

import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.bindings.api.ApiCache;
import org.objectstyle.wolips.bindings.api.ApiModelException;
import org.objectstyle.wolips.bindings.api.ApiUtils;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.BindingValidationRule;
import org.objectstyle.wolips.bindings.wod.ITypeOwner;
import org.objectstyle.wolips.bindings.wod.TagShortcut;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.core.resources.types.LimitedLRUCache;
import org.objectstyle.wolips.locate.LocateException;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;
import org.objectstyle.wolips.wodclipse.core.builder.WodBuilder;
import org.objectstyle.wolips.wodclipse.core.completion.HtmlCacheEntry;
import org.objectstyle.wolips.wodclipse.core.completion.WodCacheEntry;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCacheInvalidator;
import org.objectstyle.wolips.wodclipse.core.completion.WooCacheEntry;
import org.objectstyle.wolips.wodclipse.core.util.EOModelGroupCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WodParserCache
implements ITypeOwner {
    private static TypeCache _typeCache = new TypeCache();
    private static EOModelGroupCache _modelGroupCache = new EOModelGroupCache();
    private static LimitedLRUCache<String, WodParserCache> _parsers;
    private WodCacheEntry _wodEntry;
    private HtmlCacheEntry _htmlEntry;
    private WooCacheEntry _wooEntry;
    private TextViewerUndoManager _undoManager;
    private LocalizedComponentsLocateResult _componentsLocateResults;
    private IProject _project;
    private IJavaProject _javaProject;
    private IType _componentType;
    private IContainer _woFolder;
    private IFile _apiFile;
    private long _lastJavaParseTime;
    private boolean _validated;
    private boolean _validating;
    private Object _validationLock = new Object();

    public static WodParserCache parser(IProject project, String componentName) throws CoreException, LocateException {
        LocalizedComponentsLocateResult locateResult = LocatePlugin.getDefault().getLocalizedComponentsLocateResult(project, componentName);
        IFile resource = locateResult.getFirstWodFile();
        if (resource == null) {
            resource = locateResult.getFirstHtmlFile();
        }
        WodParserCache parserCache = WodParserCache.parser((IResource)resource, true);
        if (parserCache._componentsLocateResults == null) {
            parserCache._componentsLocateResults = locateResult;
        }
        return parserCache;
    }

    public static WodParserCache parser(IResource resource) throws CoreException, LocateException {
        return WodParserCache.parser(resource, true);
    }

    public static synchronized WodParserCache parser(IResource resource, boolean createIfMissing) throws CoreException, LocateException {
        String key;
        WodParserCache cache;
        if (_parsers == null) {
            _parsers = new LimitedLRUCache(10);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new WodParserCacheInvalidator());
        }
        if ((cache = (WodParserCache)_parsers.get((Object)(key = WodParserCache.getCacheKey(resource)))) == null && createIfMissing) {
            cache = new WodParserCache(WodParserCache.getWoFolder(resource));
            _parsers.put((Object)key, (Object)cache);
        }
        return cache;
    }

    public static void invalidateResource(IResource resource) {
        try {
            WodParserCache cacheEntry = WodParserCache.parser(resource, false);
            if (cacheEntry != null) {
                String key = WodParserCache.getCacheKey(resource);
                _parsers.remove((Object)key);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (LocateException e) {
            e.printStackTrace();
        }
    }

    private static String getCacheKey(IResource resource) {
        IContainer woFolder = WodParserCache.getWoFolder(resource);
        String cacheKey = woFolder == null ? resource.getLocation().toPortableString() : woFolder.getLocation().toPortableString();
        return cacheKey;
    }

    private static IContainer getWoFolder(IResource resource) {
        IContainer woFolder = resource instanceof IFolder ? (IContainer)resource : resource.getParent();
        return woFolder;
    }

    protected WodParserCache(IContainer woFolder) throws CoreException, LocateException {
        this._woFolder = woFolder;
        this.init();
    }

    public WodParserCache() throws CoreException, LocateException {
        this.init();
    }

    protected void init() throws CoreException, LocateException {
        this._undoManager = new TextViewerUndoManager(25);
        this._wodEntry = new WodCacheEntry(this);
        this._htmlEntry = new HtmlCacheEntry(this);
        this._wooEntry = new WooCacheEntry(this);
        this.clearCache();
    }

    public IContainer getWoFolder() {
        return this._woFolder;
    }

    public IType getComponentType() throws CoreException, LocateException {
        this.checkLocateResults();
        if (this._componentType == null) {
            this._componentType = this._componentsLocateResults.getDotJavaType();
        }
        return this._componentType;
    }

    public IProject getProject() {
        return this._project;
    }

    public IJavaProject getJavaProject() {
        return this._javaProject;
    }

    public WodParserCache cloneCache() throws CoreException, LocateException {
        WodParserCache cache = new WodParserCache();
        cache._componentsLocateResults = this._componentsLocateResults;
        cache._javaProject = this._javaProject;
        cache._project = this._project;
        cache._componentType = this._componentType;
        cache._woFolder = this._woFolder;
        cache._apiFile = this._apiFile;
        cache._htmlEntry.setFile(this._htmlEntry.getFile());
        cache._wodEntry.setFile(this._wodEntry.getFile());
        cache._wooEntry.setFile(this._wooEntry.getFile());
        return cache;
    }

    protected void checkLocateResults() throws CoreException, LocateException {
        if (this._componentsLocateResults != null && !this._componentsLocateResults.isValid()) {
            this.clearLocateResultsCache();
        }
    }

    public void clearLocateResultsCache() throws CoreException, LocateException {
        if (this._woFolder != null && this._woFolder.exists() && LocatePlugin.getDefault() != null) {
            this._componentsLocateResults = LocatePlugin.getDefault().getLocalizedComponentsLocateResult((IResource)this._woFolder);
            this._project = this._woFolder.getProject();
            this._javaProject = JavaCore.create((IProject)this._project);
            this._htmlEntry.setFile(this._componentsLocateResults.getFirstHtmlFile());
            this._wodEntry.setFile(this._componentsLocateResults.getFirstWodFile());
            this._apiFile = this._componentsLocateResults.getDotApi(true);
            this._componentType = null;
            this._wooEntry.setFile(this._componentsLocateResults.getFirstWooFile());
        } else {
            this._woFolder = null;
        }
    }

    public void clearCache() throws CoreException, LocateException {
        this.clearLocateResultsCache();
        this.clearParserCache();
        this.clearValidationCache();
    }

    public void clearParserCache() throws CoreException, LocateException {
        this._htmlEntry.clear();
        this._wodEntry.clear();
        this._wooEntry.clear();
    }

    public void clearValidationCache() {
        this._setValidated(false);
    }

    public LocalizedComponentsLocateResult getComponentsLocateResults() {
        if (this._componentsLocateResults.isValid()) {
            // empty if block
        }
        return this._componentsLocateResults;
    }

    public ApiCache getApiCache() {
        return WodParserCache.getTypeCache().getApiCache(this._javaProject);
    }

    public static TypeCache getTypeCache() {
        return _typeCache;
    }

    public static EOModelGroupCache getModelGroupCache() {
        return _modelGroupCache;
    }

    public IType getType() throws CoreException, LocateException {
        return this.getComponentType();
    }

    public TypeCache getCache() {
        return WodParserCache.getTypeCache();
    }

    public Wo getWo(String elementName) throws ApiModelException, JavaModelException {
        IType elementType = this.getElementType(elementName);
        return this.getWo(elementType);
    }

    public IType getElementType(String elementName) throws JavaModelException {
        return BindingReflectionUtils.findElementType((IJavaProject)this._javaProject, (String)elementName, (boolean)false, (TypeCache)WodParserCache.getTypeCache());
    }

    public Wo getWo(IType type) throws ApiModelException {
        return ApiUtils.findApiModelWo((IType)type, (ApiCache)this.getApiCache());
    }

    public synchronized void parse() throws Exception {
        if (this._htmlEntry.shouldParse()) {
            this._htmlEntry.parse();
        }
        if (this._wodEntry.shouldParse()) {
            this._wodEntry.parse();
        }
        if (this._wooEntry.shouldParse()) {
            this._wooEntry.parse();
        }
    }

    public void scheduleValidate(final boolean force, final boolean threaded) {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    try {
                        WodParserCache.this.parse();
                        WodParserCache.this.validate(force, threaded);
                    }
                    catch (Exception ex) {
                        Activator.getDefault().log((Throwable)ex);
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            Activator.getDefault().log((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(boolean force, boolean threaded) throws CoreException {
        block9: {
            boolean validate = false;
            Object object = this._validationLock;
            synchronized (object) {
                if (force || !this._validating) {
                    this._validating = true;
                    validate = true;
                }
            }
            if (validate && (force || !this._validated)) {
                if (threaded) {
                    WodBuilder.validateComponent((IResource)this._woFolder, true, null);
                } else {
                    try {
                        this._validate();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Activator activator = Activator.getDefault();
                        if (activator == null) break block9;
                        activator.log((Throwable)e);
                    }
                }
            }
        }
    }

    public HtmlCacheEntry getHtmlEntry() {
        return this._htmlEntry;
    }

    public WodCacheEntry getWodEntry() {
        return this._wodEntry;
    }

    public WooCacheEntry getWooEntry() {
        return this._wooEntry;
    }

    public void _setValidated(boolean validated) {
        if (validated || !this._validating) {
            this._validated = validated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _validate() throws Exception {
        Object object = this._validationLock;
        synchronized (object) {
            this._validated = true;
            this._validating = true;
        }
        try {
            this._htmlEntry.deleteProblems();
            this._wodEntry.deleteProblems();
            this._wooEntry.deleteProblems();
            if (Activator.getDefault().getPreferenceStore().getBoolean("ValidateTemplatesKey")) {
                this._htmlEntry.validate();
                this._wodEntry.validate();
                this._wooEntry.validate();
            }
        }
        finally {
            object = this._validationLock;
            synchronized (object) {
                this._validated = true;
                this._validating = false;
            }
        }
    }

    public IFile getApiFile() throws CoreException, LocateException {
        this.checkLocateResults();
        return this._apiFile;
    }

    public TagShortcut getTagShortcutNamed(String shortcut) {
        return ApiCache.getTagShortcutNamed((String)shortcut);
    }

    public List<TagShortcut> getTagShortcuts() {
        return ApiCache.getTagShortcuts();
    }

    public List<BindingValidationRule> getBindingValidationRules() {
        return ApiCache.getBindingValidationRules();
    }
}

