/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.objectstyle.wolips.wodclipse.WodclipsePlugin;
import org.objectstyle.wolips.wodclipse.core.parser.ElementNameRule;
import org.objectstyle.wolips.wodclipse.core.parser.RulePosition;
import org.objectstyle.wolips.wodclipse.core.parser.WodScanner;

public class WodContentOutlinePage
extends ContentOutlinePage {
    Image image;
    protected Object fInput;
    protected IDocumentProvider fDocumentProvider;
    protected ITextEditor fTextEditor;

    public WodContentOutlinePage(IDocumentProvider provider, ITextEditor editor) {
        this.fDocumentProvider = provider;
        this.fTextEditor = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        viewer.setContentProvider((IContentProvider)new ContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                ImageDescriptor desc;
                if (WodContentOutlinePage.this.image == null && (desc = WodclipsePlugin.getImageDescriptor("icons/wod-element.gif")) != null) {
                    WodContentOutlinePage.this.image = desc.createImage();
                }
                if (WodContentOutlinePage.this.image != null && element instanceof Segment) {
                    return WodContentOutlinePage.this.image;
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof Segment) {
                    Segment segment = (Segment)element;
                    return segment.getName();
                }
                return super.getText(element);
            }
        });
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fInput != null) {
            viewer.setInput(this.fInput);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.fTextEditor.resetHighlightRange();
        } else {
            Segment segment = (Segment)((IStructuredSelection)selection).getFirstElement();
            int start = segment.position.getOffset();
            int length = segment.position.getLength();
            try {
                this.fTextEditor.setHighlightRange(start, length, true);
            }
            catch (IllegalArgumentException e) {
                WodclipsePlugin.getDefault().log(e);
                this.fTextEditor.resetHighlightRange();
            }
        }
    }

    public void setInput(Object input) {
        this.fInput = input;
        this.update();
    }

    public void update() {
        Control control;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (control = viewer.getControl()) != null && !control.isDisposed()) {
            control.setRedraw(false);
            viewer.setInput(this.fInput);
            viewer.expandAll();
            control.setRedraw(true);
        }
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        protected static final String SEGMENTS = "__wod_segments";
        protected IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("__wod_segments");
        protected List<Segment> fContent = new ArrayList<Segment>(10);

        protected ContentProvider() {
        }

        protected void parse(IDocument document) {
            try {
                List<RulePosition> elementNameRulePositions = WodScanner.getRulePositionsOfType(document, ElementNameRule.class);
                for (RulePosition rulePosition : elementNameRulePositions) {
                    Position p = rulePosition.getPosition();
                    document.addPosition(SEGMENTS, p);
                    this.fContent.add(new Segment(rulePosition.getText(), p));
                }
            }
            catch (BadPositionCategoryException e) {
                WodclipsePlugin.getDefault().log(e);
            }
            catch (BadLocationException e) {
                WodclipsePlugin.getDefault().log(e);
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            IDocument document;
            if (oldInput != null && (document = WodContentOutlinePage.this.fDocumentProvider.getDocument(oldInput)) != null) {
                try {
                    document.removePositionCategory(SEGMENTS);
                }
                catch (BadPositionCategoryException e) {
                    WodclipsePlugin.getDefault().log(e);
                }
                document.removePositionUpdater(this.fPositionUpdater);
            }
            this.fContent.clear();
            if (newInput != null && (document = WodContentOutlinePage.this.fDocumentProvider.getDocument(newInput)) != null) {
                document.addPositionCategory(SEGMENTS);
                document.addPositionUpdater(this.fPositionUpdater);
                this.parse(document);
            }
        }

        public void dispose() {
            if (this.fContent != null) {
                this.fContent.clear();
                this.fContent = null;
            }
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public Object[] getElements(Object element) {
            return this.fContent.toArray();
        }

        public boolean hasChildren(Object element) {
            return element == WodContentOutlinePage.this.fInput;
        }

        public Object getParent(Object element) {
            if (element instanceof Segment) {
                return WodContentOutlinePage.this.fInput;
            }
            return null;
        }

        public Object[] getChildren(Object element) {
            if (element == WodContentOutlinePage.this.fInput) {
                return this.fContent.toArray();
            }
            return new Object[0];
        }
    }

    protected static class Segment {
        public String name;
        public Position position;

        public Segment(String name, Position position) {
            this.name = name;
            this.position = position;
        }

        public String getName() {
            return this.name;
        }
    }
}

