/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.editor;

import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.objectstyle.wolips.wodclipse.core.parser.WodScanner;
import org.objectstyle.wolips.wodclipse.editor.WodAnnotationHover;
import org.objectstyle.wolips.wodclipse.editor.WodCompletionProcessor;
import org.objectstyle.wolips.wodclipse.editor.WodEditor;
import org.objectstyle.wolips.wodclipse.editor.WodElementHyperlinkDetector;

public class WodSourceViewerConfiguration
extends SourceViewerConfiguration {
    private WodScanner myScanner;
    private WodEditor myEditor;
    private MonoReconciler myReconciler;
    private PresentationReconciler myPresentationReconciler;
    private ContentAssistant myContentAssistant;

    public WodSourceViewerConfiguration(WodEditor _editor) {
        this.myEditor = _editor;
    }

    protected WodScanner getWODScanner() {
        if (this.myScanner == null) {
            this.myScanner = WodScanner.newWODScanner();
        }
        return this.myScanner;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer _sourceViewer) {
        return new WodAnnotationHover(_sourceViewer.getAnnotationModel());
    }

    public IReconciler getReconciler(ISourceViewer _sourceViewer) {
        if (this.myReconciler == null) {
            // empty if block
        }
        return this.myReconciler;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceView) {
        if (this.myPresentationReconciler == null) {
            this.myPresentationReconciler = new PresentationReconciler();
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getWODScanner());
            this.myPresentationReconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
            this.myPresentationReconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        }
        return this.myPresentationReconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer _sourceViewer) {
        if (this.myContentAssistant == null) {
            WodCompletionProcessor completionProcessor = new WodCompletionProcessor(this.myEditor);
            this.myContentAssistant = new ContentAssistant();
            this.myContentAssistant.setContentAssistProcessor((IContentAssistProcessor)completionProcessor, "__dftl_partition_content_type");
            this.myContentAssistant.enableAutoActivation(true);
            this.myContentAssistant.setAutoActivationDelay(500);
            this.myContentAssistant.enableAutoInsert(true);
            this.myContentAssistant.setProposalPopupOrientation(10);
            this.myContentAssistant.enableColoredLabels(true);
        }
        return this.myContentAssistant;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] detectors = super.getHyperlinkDetectors(sourceViewer);
        IHyperlinkDetector[] result = new IHyperlinkDetector[detectors.length + 1];
        System.arraycopy(detectors, 0, result, 0, detectors.length);
        result[result.length - 1] = new WodElementHyperlinkDetector(this.myEditor);
        return result;
    }
}

