/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.actions.EMAction;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNewObjectAction<T extends EOModelObject, U extends EOModelObject>
extends EMAction {
    private Class<T> _parentType;
    private String _label;

    public AbstractNewObjectAction(Class<T> parentType, String label) {
        this._label = label;
        this._parentType = parentType;
    }

    public String getLabel() {
        return this._label;
    }

    @Override
    public void run(IAction action) {
        try {
            Object firstElement;
            EOModelObject selectedObject = null;
            IStructuredSelection selection = this.getSelection();
            if (selection != null && (firstElement = selection.getFirstElement()) instanceof EOModelObject) {
                selectedObject = EOModelUtils.getRelated(this._parentType, (EOModelObject)firstElement);
            }
            if (selectedObject != null) {
                NewOperation operation = new NewOperation(this, selectedObject);
                operation.addContext(EOModelUtils.getUndoContext(selectedObject));
                IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                operationHistory.execute((IUndoableOperation)operation, null, null);
            } else {
                MessageDialog.openError((Shell)this.getWindow().getShell(), (String)this.getNoSelectionTitle(), (String)this.getNoSelectionMessage());
            }
        }
        catch (Throwable e) {
            ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)e);
        }
    }

    protected abstract String getNoSelectionTitle();

    protected abstract String getNoSelectionMessage();

    protected abstract U createChild(T var1, Set<EOModelVerificationFailure> var2) throws EOModelException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NewOperation
    extends AbstractOperation {
        private T _parent;
        private U _child;
        final /* synthetic */ AbstractNewObjectAction this$0;

        public NewOperation(T parent) {
            this.this$0 = this$0;
            super(this$0.getLabel());
            this._parent = parent;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
                this._child = this.this$0.createChild(this._parent, failures);
                return Status.OK_STATUS;
            }
            catch (EOModelException e) {
                throw new ExecutionException("Failed to add new object.", (Throwable)e);
            }
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
                ((EOModelObject)this._child)._removeFromModelParent(failures);
                return Status.OK_STATUS;
            }
            catch (EOModelException e) {
                throw new ExecutionException("Failed to remove object.", (Throwable)e);
            }
        }
    }
}

