/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.actions.EMAction;
import org.objectstyle.wolips.eomodeler.core.model.EOModelObject;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;

public class CopyAction
extends EMAction {
    public void run() {
        try {
            Control focusControl = Display.getCurrent().getFocusControl();
            if (focusControl instanceof Text) {
                ((Text)focusControl).copy();
                return;
            }
            if (focusControl instanceof StyledText) {
                ((StyledText)focusControl).copy();
                return;
            }
            Object[] selectedObjects = this.getSelectedObjects();
            if (selectedObjects != null) {
                LinkedList<EOModelObject> selectedObjectsList = new LinkedList<EOModelObject>();
                for (Object selectedObject : selectedObjects) {
                    if (!(selectedObject instanceof EOModelObject)) continue;
                    EOModelObject object = (EOModelObject)selectedObject;
                    selectedObjectsList.add(object._cloneModelObject());
                }
                CopyOperation operation = new CopyOperation(selectedObjectsList);
                operation.addContext(EOModelUtils.getUndoContext(selectedObjects));
                IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                operationHistory.execute((IUndoableOperation)operation, null, null);
            }
        }
        catch (Throwable t) {
            ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)t);
        }
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    public void run(IAction action) {
        this.run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CopyOperation
    extends AbstractOperation {
        private List<EOModelObject> _objects;
        private ISelection _previousSelection;
        private long _previousSelectionTime;

        public CopyOperation(List<EOModelObject> objects) {
            super(EOModelUtils.getOperationLabel("Copy", objects));
            this._objects = objects;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            this._previousSelection = LocalSelectionTransfer.getTransfer().getSelection();
            this._previousSelectionTime = LocalSelectionTransfer.getTransfer().getSelectionSetTime();
            LocalSelectionTransfer.getTransfer().setSelection((ISelection)new StructuredSelection(this._objects));
            LocalSelectionTransfer.getTransfer().setSelectionSetTime(System.currentTimeMillis());
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
            LocalSelectionTransfer.getTransfer().setSelection(this._previousSelection);
            LocalSelectionTransfer.getTransfer().setSelectionSetTime(this._previousSelectionTime);
            return Status.OK_STATUS;
        }
    }
}

