/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.actions.EMAction;
import org.objectstyle.wolips.eomodeler.actions.GenerateMigrationDialog;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;

public class GenerateMigrationAction
extends EMAction {
    public void run(IAction action) {
        try {
            IStructuredSelection selection = this.getSelection();
            if (selection != null) {
                EOModel model = null;
                boolean modelSelected = false;
                LinkedList<EOEntity> entities = new LinkedList<EOEntity>();
                Iterator selectionIter = selection.iterator();
                while (!modelSelected && selectionIter.hasNext()) {
                    Object obj = selectionIter.next();
                    EOEntity entity = EOModelUtils.getRelatedEntity(obj);
                    if (entity != null) {
                        model = entity.getModel();
                        entities.add(entity);
                        continue;
                    }
                    model = EOModelUtils.getRelatedModel(obj);
                    if (model == null) continue;
                    modelSelected = true;
                }
                if (modelSelected) {
                    entities = null;
                }
                if (model != null) {
                    GenerateMigrationDialog dialog = new GenerateMigrationDialog(this.getWindow().getShell(), model, entities);
                    dialog.open();
                }
            }
        }
        catch (Throwable e) {
            ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)e);
        }
    }
}

