/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.actions;

import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.actions.EMAction;
import org.objectstyle.wolips.eomodeler.actions.SubclassOperation;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.IEOEntityRelative;
import org.objectstyle.wolips.eomodeler.core.model.InheritanceType;
import org.objectstyle.wolips.eomodeler.core.utils.EOModelUtils;
import org.objectstyle.wolips.eomodeler.editors.entity.SubclassEntityDialog;

public class SubclassEntityAction
extends EMAction {
    public void run(IAction action) {
        EOModel model = null;
        EOEntity entity = null;
        Object selectedObject = this.getSelectedObject();
        if (selectedObject instanceof EOModel) {
            model = (EOModel)selectedObject;
        } else if (selectedObject instanceof IEOEntityRelative) {
            entity = ((IEOEntityRelative)selectedObject).getEntity();
            model = entity.getModel();
        }
        if (model != null) {
            SubclassEntityDialog dialog = new SubclassEntityDialog(this.getWindow().getShell(), model, entity, model.getModelGroup().getEditingModel());
            dialog.setBlockOnOpen(true);
            int results = dialog.open();
            if (results == 0) {
                String entityName = dialog.getEntityName();
                if (entityName != null && entityName.trim().length() > 0) {
                    try {
                        EOEntity parentEntity = dialog.getParentEntity();
                        InheritanceType inheritanceType = dialog.getInheritanceType();
                        String restrictingQualifier = dialog.getRestrictingQualifier();
                        EOModel destinationModel = dialog.getDestinationModel();
                        SubclassOperation operation = new SubclassOperation(parentEntity, inheritanceType, destinationModel, entityName, restrictingQualifier);
                        operation.addContext(EOModelUtils.getUndoContext(model));
                        IOperationHistory operationHistory = PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
                        operationHistory.execute((IUndoableOperation)operation, null, null);
                    }
                    catch (Throwable e) {
                        ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)e);
                    }
                } else {
                    MessageDialog.openError((Shell)this.getWindow().getShell(), (String)Messages.getString("Subclass.noEntityNameTitle"), (String)Messages.getString("Subclass.noEntityNameMessage"));
                }
            }
        } else {
            MessageDialog.openError((Shell)this.getWindow().getShell(), (String)Messages.getString("Subclass.noModelSelectedTitle"), (String)Messages.getString("Subclass.noModelSelectedMessage"));
        }
    }
}

