/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.math.BigDecimal;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eomodeler.core.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EODataType
implements Comparable<EODataType> {
    public static final EODataType STRING = new EODataType("NSString", String.class.getName(), new String[]{null, "", "S"}, Messages.getString("EODataType.string"));
    public static final EODataType STRING_CHAR = new EODataType("NSString", String.class.getName(), "C", Messages.getString("EODataType.stringChar"));
    public static final EODataType STRING_UTF = new EODataType("NSString", String.class.getName(), "E", Messages.getString("EODataType.stringUTF"));
    public static final EODataType STRING_RTRIM = new EODataType("NSString", String.class.getName(), "c", Messages.getString("EODataType.stringRTRIM"));
    public static final EODataType BYTE = new EODataType("NSNumber", Byte.class.getName(), "b", Messages.getString("EODataType.byte"));
    public static final EODataType SHORT = new EODataType("NSNumber", Short.class.getName(), "s", Messages.getString("EODataType.short"));
    public static final EODataType INTEGER = new EODataType("NSNumber", Integer.class.getName(), new String[]{"i", null, ""}, Messages.getString("EODataType.integer"));
    public static final EODataType LONG = new EODataType("NSNumber", Long.class.getName(), "l", Messages.getString("EODataType.long"));
    public static final EODataType FLOAT = new EODataType("NSNumber", Float.class.getName(), "f", Messages.getString("EODataType.float"));
    public static final EODataType DOUBLE = new EODataType("NSNumber", Double.class.getName(), "d", Messages.getString("EODataType.double"));
    public static final EODataType BOOLEAN = new EODataType("NSNumber", "boolean", "c", Messages.getString("EODataType.boolean"));
    public static final EODataType BIGDECIMAL = new EODataType("NSDecimalNumber", BigDecimal.class.getName(), "B", Messages.getString("EODataType.bigDecimal"));
    public static final EODataType DECIMAL_NUMBER = new EODataType("NSDecimalNumber", Integer.class.getName(), (String)null, Messages.getString("EODataType.decimalNumber"));
    public static final EODataType DATE_OBJ = new EODataType("NSCalendarDate", "com.webobjects.foundation.NSTimestamp", new String[]{null, ""}, Messages.getString("EODataType.dateObj"));
    public static final EODataType DATE = new EODataType("NSCalendarDate", "com.webobjects.foundation.NSTimestamp", new String[]{"D"}, Messages.getString("EODataType.date"));
    public static final EODataType TIME = new EODataType("NSCalendarDate", "com.webobjects.foundation.NSTimestamp", "t", Messages.getString("EODataType.time"));
    public static final EODataType TIMESTAMP = new EODataType("NSCalendarDate", "com.webobjects.foundation.NSTimestamp", "T", Messages.getString("EODataType.timestamp"));
    public static final EODataType DATE_MSSQL = new EODataType("NSCalendarDate", "com.webobjects.foundation.NSTimestamp", "M", Messages.getString("EODataType.dateMSSQL"));
    public static final EODataType DATA = new EODataType("NSData", "com.webobjects.foundation.NSData", (String)null, Messages.getString("EODataType.data"));
    public static final EODataType CUSTOM = new EODataType(null, "Custom", (String)null, Messages.getString("EODataType.custom"));
    public static final EODataType[] DATA_TYPES = new EODataType[]{STRING, STRING_CHAR, STRING_UTF, STRING_RTRIM, BYTE, SHORT, INTEGER, LONG, FLOAT, DOUBLE, BIGDECIMAL, DECIMAL_NUMBER, BOOLEAN, DATE_OBJ, DATE, TIME, TIMESTAMP, DATE_MSSQL, DATA, CUSTOM};
    private String myValueClass;
    private String myJavaValueClass;
    private String[] myValueTypes;
    private String myName;

    public EODataType(String _valueClass, String _javaValueClass, String _valueType, String _name) {
        this(_valueClass, _javaValueClass, new String[]{_valueType}, _name);
    }

    public EODataType(String _valueClass, String _javaValueClass, String[] _valueTypes, String _name) {
        this.myValueClass = _valueClass;
        this.myJavaValueClass = _javaValueClass;
        this.myValueTypes = _valueTypes;
        this.myName = _name;
    }

    public String getShortJavaValueClass() {
        int lastDotIndex;
        String javaValueClass = this.myJavaValueClass;
        if (javaValueClass != null && (lastDotIndex = javaValueClass.lastIndexOf(46)) != -1) {
            javaValueClass = javaValueClass.substring(lastDotIndex + 1);
        }
        return javaValueClass;
    }

    public String getJavaValueClass() {
        return this.myJavaValueClass;
    }

    public String getValueClass() {
        return this.myValueClass;
    }

    public String getFirstValueType() {
        return this.myValueTypes[0];
    }

    public String[] getValueTypes() {
        return this.myValueTypes;
    }

    public String getName() {
        return this.myName;
    }

    public String toString() {
        return "[EODataType: name = " + this.myName + "]";
    }

    @Override
    public int compareTo(EODataType o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public static EODataType getDataTypeByValueClassAndType(String _valueClass, String _valueType) {
        EODataType matchingDataType = null;
        for (int dataTypeNum = 0; matchingDataType == null && dataTypeNum < DATA_TYPES.length; ++dataTypeNum) {
            EODataType dataType = DATA_TYPES[dataTypeNum];
            if (!ComparisonUtils.equals((Object)dataType.myValueClass, (Object)_valueClass)) continue;
            for (int valueTypeNum = 0; matchingDataType == null && valueTypeNum < dataType.myValueTypes.length; ++valueTypeNum) {
                if (!ComparisonUtils.equals((Object)dataType.myValueTypes[valueTypeNum], (Object)_valueType)) continue;
                matchingDataType = dataType;
            }
        }
        if (matchingDataType == null) {
            matchingDataType = CUSTOM;
        }
        return matchingDataType;
    }

    public static EODataType getDataTypeByValueClass(String _valueClass) {
        EODataType matchingDataType = null;
        for (int dataTypeNum = 0; matchingDataType == null && dataTypeNum < DATA_TYPES.length; ++dataTypeNum) {
            EODataType dataType = DATA_TYPES[dataTypeNum];
            if (!ComparisonUtils.equals((Object)dataType.myValueClass, (Object)_valueClass)) continue;
            matchingDataType = dataType;
        }
        if (matchingDataType == null) {
            matchingDataType = CUSTOM;
        }
        return matchingDataType;
    }
}

