/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eomodeler.core.Messages;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateDatabaseConfigNameException;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.EOModelReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.utils.NotificationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EODatabaseConfig
extends EOModelObject<EOModel> {
    public static final String JDBC_ADAPTOR_NAME = "JDBC";
    public static final String JNDI_ADAPTOR_NAME = "JNDI";
    public static final String MEMORY_ADAPTOR_NAME = "Memory";
    public static final String REST_ADAPTOR_NAME = "REST";
    public static final String NONE_AUTHENTICATION_METHOD = "None";
    public static final String SIMPLE_AUTHENTICATION_METHOD = "Simple";
    public static final String OBJECT_SCOPE = "Object";
    public static final String SUBTREE_SCOPE = "Subtree";
    public static final String ONE_LEVEL_SCOPE = "One Level";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String URL = "URL";
    public static final String DRIVER = "driver";
    public static final String PLUGIN = "plugin";
    public static final String CONNECTION_DICTIONARY = "connectionDictionary";
    public static final String NAME = "name";
    public static final String PROTOTYPE = "prototype";
    public static final String ADAPTOR_NAME = "adaptorName";
    public static final String AUTHENTICATION_METHOD = "authenticationMethod";
    public static final String INITIAL_CONTEXT_FACTORY = "initialContextFactory";
    public static final String SCOPE = "scope";
    public static final String TIMEOUT = "timeout";
    public static final String PRIORITY = "priority";
    public static final String DEPLOYMENT_PROFILE = "deploymentProfile";
    private EOModel myModel;
    private String myAdaptorName = "JDBC";
    private String myName;
    private String myPrototypeName;
    private EOEntity myCachedPrototype;
    private NotificationMap<Object, Object> myConnectionDictionary;
    private EOModelObject.PropertyChangeRepeater myConnectionDictionaryRepeater = new EOModelObject.PropertyChangeRepeater(this, "connectionDictionary");
    private EOModelMap myDatabaseConfigMap = new EOModelMap();

    public EODatabaseConfig() {
        this.setConnectionDictionary(new NotificationMap<Object, Object>(), false);
    }

    public EODatabaseConfig(String _name) {
        this();
        this.myName = _name;
    }

    public boolean isActive() {
        return this.myModel != null && this.myModel.getActiveDatabaseConfig() == this;
    }

    public void setActive() {
        if (this.myModel != null) {
            this.myModel.setActiveDatabaseConfig(this);
        }
    }

    public boolean isEquivalent(EODatabaseConfig config, boolean comparePrototypes) {
        boolean equivalent = false;
        if (config != null) {
            boolean bl = equivalent = this.myConnectionDictionary != null && config.myConnectionDictionary != null;
            if (equivalent) {
                equivalent = ComparisonUtils.equals((Object)this.myAdaptorName, (Object)config.myAdaptorName);
            }
            if (equivalent) {
                equivalent = ComparisonUtils.equals((Object)this.myConnectionDictionary.get(URL), (Object)config.myConnectionDictionary.get(URL));
            }
            if (equivalent) {
                equivalent = ComparisonUtils.equals((Object)this.myConnectionDictionary.get(USERNAME), (Object)config.myConnectionDictionary.get(USERNAME));
            }
            if (equivalent) {
                equivalent = ComparisonUtils.equals((Object)this.myConnectionDictionary.get(PASSWORD), (Object)config.myConnectionDictionary.get(PASSWORD));
            }
            if (equivalent) {
                equivalent = ComparisonUtils.equals((Object)this.myConnectionDictionary.get(PLUGIN), (Object)config.myConnectionDictionary.get(PLUGIN));
            }
            if (equivalent) {
                equivalent = ComparisonUtils.equals((Object)this.myConnectionDictionary.get(DRIVER), (Object)config.myConnectionDictionary.get(DRIVER));
            }
            if (equivalent) {
                equivalent = ComparisonUtils.equals((Object)this.myConnectionDictionary.get("serverUrl"), (Object)config.myConnectionDictionary.get("serverUrl"));
            }
            if (equivalent) {
                equivalent = ComparisonUtils.equals((Object)this.myConnectionDictionary.get(INITIAL_CONTEXT_FACTORY), (Object)config.myConnectionDictionary.get(INITIAL_CONTEXT_FACTORY));
            }
            if (equivalent) {
                equivalent = ComparisonUtils.equals((Object)this.myConnectionDictionary.get(AUTHENTICATION_METHOD), (Object)config.myConnectionDictionary.get(AUTHENTICATION_METHOD));
            }
            if (equivalent) {
                equivalent = ComparisonUtils.equals((Object)this.myConnectionDictionary.get("plugInClassName"), (Object)config.myConnectionDictionary.get("plugInClassName"));
            }
            if (equivalent) {
                equivalent = ComparisonUtils.equals((Object)this.myConnectionDictionary.get(SCOPE), (Object)config.myConnectionDictionary.get(SCOPE));
            }
            if (equivalent && comparePrototypes) {
                equivalent = this.myPrototypeName == null || config.myPrototypeName == null || this.myPrototypeName.length() == 0 || config.myPrototypeName.length() == 0 || ComparisonUtils.equals((Object)this.myPrototypeName, (Object)config.myPrototypeName);
            }
        }
        return equivalent;
    }

    public void pasted() {
    }

    public void _setModel(EOModel _model) {
        this.myModel = _model;
    }

    public EOModel getModel() {
        return this.myModel;
    }

    @Override
    protected void _propertyChanged(String _propertyName, Object _oldValue, Object _newValue) {
        if (this.myModel != null) {
            this.myModel._databaseConfigChanged(this, _propertyName, _oldValue, _newValue);
        }
    }

    @Override
    public String getName() {
        return this.myName;
    }

    public void setAdaptorName(String _adaptorName) {
        String oldAdaptorName = this.myAdaptorName;
        this.myAdaptorName = _adaptorName;
        if (JNDI_ADAPTOR_NAME.equals(this.myAdaptorName)) {
            if (this.getPlugin() == null || this.getPlugin().length() == 0) {
                this.setPlugin("com.webobjects.jndiadaptor.LDAPPlugIn");
            }
            if (this.getInitialContextFactory() == null || this.getInitialContextFactory().length() == 0) {
                this.setInitialContextFactory("com.sun.jndi.ldap.LdapCtxFactory");
            }
            if (this.getTimeout() == null) {
                this.setTimeout(3600);
            }
            if (this.getScope() == null || this.getScope().length() == 0) {
                this.setScope(SUBTREE_SCOPE);
            }
            if (this.getAuthenticationMethod() == null || this.getAuthenticationMethod().length() == 0) {
                this.setAuthenticationMethod(NONE_AUTHENTICATION_METHOD);
            }
        }
        this.firePropertyChange(ADAPTOR_NAME, oldAdaptorName, this.myAdaptorName);
    }

    public String getAdaptorName() {
        return this.myAdaptorName;
    }

    public void setName(String _name) throws DuplicateDatabaseConfigNameException {
        this.setName(_name, true);
    }

    public void setName(String _name, boolean _fireEvents) throws DuplicateDatabaseConfigNameException {
        if (_name == null) {
            throw new NullPointerException(Messages.getString("EODatabaseConfig.noBlankDatabaseConfigNames"));
        }
        String oldName = this.myName;
        if (this.myModel != null) {
            this.myModel._checkForDuplicateDatabaseConfigName(this, _name, null);
        }
        this.myName = _name;
        if (_fireEvents) {
            this.firePropertyChange(NAME, oldName, this.myName);
        }
    }

    public EOEntity getPrototype() {
        if (this.myCachedPrototype == null && this.myModel != null) {
            this.myCachedPrototype = this.myModel.getModelGroup().getEntityNamed(this.myPrototypeName);
        }
        return this.myCachedPrototype;
    }

    public void setPrototype(EOEntity _prototype) {
        Map exampleConnectionDictionary;
        EOEntity oldPrototype = this.getPrototype();
        if (_prototype == null) {
            this.myPrototypeName = null;
            this.myCachedPrototype = null;
        } else {
            this.myPrototypeName = _prototype.getName();
            this.myCachedPrototype = null;
        }
        EOEntity newPrototype = this.getPrototype();
        this.firePropertyChange(PROTOTYPE, oldPrototype, newPrototype);
        if (newPrototype != null && (exampleConnectionDictionary = (Map)newPrototype.getUserInfo().get("exampleConnectionDictionary")) != null) {
            for (Map.Entry entry : exampleConnectionDictionary.entrySet()) {
                Object oldValue = this.getConnectionDictionary().get(entry.getKey());
                this.getConnectionDictionary().put(entry.getKey(), entry.getValue());
                this.firePropertyChange((String)entry.getKey(), oldValue, entry.getValue());
            }
        }
    }

    public void setUsername(String _userName) {
        this.getConnectionDictionary().put(USERNAME, _userName);
    }

    public String getUsername() {
        return (String)this.getConnectionDictionary().get(USERNAME);
    }

    public void setPassword(String _password) {
        this.getConnectionDictionary().put(PASSWORD, _password);
    }

    public String getPassword() {
        return (String)this.getConnectionDictionary().get(PASSWORD);
    }

    public void setPlugin(String _plugin) {
        if (JNDI_ADAPTOR_NAME.equals(this.myAdaptorName)) {
            this.getConnectionDictionary().put("plugInClassName", _plugin.trim());
        } else {
            this.getConnectionDictionary().put(PLUGIN, _plugin.trim());
        }
    }

    public String getPlugin() {
        String plugin = JNDI_ADAPTOR_NAME.equals(this.myAdaptorName) ? (String)this.getConnectionDictionary().get("plugInClassName") : (String)this.getConnectionDictionary().get(PLUGIN);
        return plugin;
    }

    public void setDriver(String _driver) {
        this.getConnectionDictionary().put(DRIVER, _driver.trim());
    }

    public String getDriver() {
        return (String)this.getConnectionDictionary().get(DRIVER);
    }

    public void setURL(String _url) {
        if (JNDI_ADAPTOR_NAME.equals(this.myAdaptorName)) {
            this.getConnectionDictionary().put("serverUrl", _url.trim());
        } else {
            this.getConnectionDictionary().put(URL, _url.trim());
        }
    }

    public String getURL() {
        String url = JNDI_ADAPTOR_NAME.equals(this.myAdaptorName) ? (String)this.getConnectionDictionary().get("serverUrl") : (String)this.getConnectionDictionary().get(URL);
        return url;
    }

    public void setTimeout(Integer _timeout) {
        this.getConnectionDictionary().put(TIMEOUT, _timeout);
    }

    public Integer getTimeout() {
        return (Integer)this.getConnectionDictionary().get(TIMEOUT);
    }

    public void setInitialContextFactory(String _initialContextFactory) {
        this.getConnectionDictionary().put(INITIAL_CONTEXT_FACTORY, _initialContextFactory);
    }

    public String getInitialContextFactory() {
        return (String)this.getConnectionDictionary().get(INITIAL_CONTEXT_FACTORY);
    }

    public void setAuthenticationMethod(String _authenticationMethod) {
        this.getConnectionDictionary().put(AUTHENTICATION_METHOD, _authenticationMethod);
    }

    public String getAuthenticationMethod() {
        return (String)this.getConnectionDictionary().get(AUTHENTICATION_METHOD);
    }

    public void setScope(String _scope) {
        this.getConnectionDictionary().put(SCOPE, _scope);
    }

    public String getScope() {
        return (String)this.getConnectionDictionary().get(SCOPE);
    }

    public void setPriority(Integer priority) {
        this.getConnectionDictionary().put(PRIORITY, priority);
    }

    public Integer getPriority() {
        return (Integer)this.getConnectionDictionary().get(PRIORITY);
    }

    public void setDeploymentProfile(String deploymentProfile) {
        this.getConnectionDictionary().put(DEPLOYMENT_PROFILE, deploymentProfile);
    }

    public String getDeploymentProfile() {
        return (String)this.getConnectionDictionary().get(DEPLOYMENT_PROFILE);
    }

    public void setConnectionDictionary(Map<Object, Object> _connectionDictionary) {
        this.setConnectionDictionary(_connectionDictionary, true);
    }

    public void setConnectionDictionary(Map<Object, Object> _connectionDictionary, boolean _fireEvents) {
        Object password;
        NotificationMap<Object, Object> oldConnectionDictionary = this.myConnectionDictionary;
        if (_connectionDictionary != null && (password = _connectionDictionary.get(PASSWORD)) != null && !(password instanceof String)) {
            _connectionDictionary.put(PASSWORD, String.valueOf(password));
        }
        this.myConnectionDictionary = this.mapChanged(this.myConnectionDictionary, _connectionDictionary, this.myConnectionDictionaryRepeater, false);
        if (_fireEvents) {
            this.firePropertyChange(this.myConnectionDictionaryRepeater.getPropertyName(), oldConnectionDictionary, this.myConnectionDictionary);
        }
    }

    public Map<Object, Object> getConnectionDictionary() {
        return this.myConnectionDictionary;
    }

    @Override
    public String getFullyQualifiedName() {
        return (this.myModel == null ? "?" : this.myModel.getFullyQualifiedName()) + "/dbconfig: " + this.myName;
    }

    public void resolve(Set<EOModelVerificationFailure> _failures) {
    }

    public void verify(Set<EOModelVerificationFailure> _failures) {
        if (this.myPrototypeName != null && this.myPrototypeName.length() > 0 && this.getPrototype() == null) {
            _failures.add(new EOModelVerificationFailure(this.getModel(), this, "The database config " + this.getName() + " references the prototype entity '" + this.myPrototypeName + "' which no longer appears to exist.", true));
        }
    }

    @Override
    public Set<EOModelReferenceFailure> getReferenceFailures() {
        return new HashSet<EOModelReferenceFailure>();
    }

    public void loadFromMap(EOModelMap _map, Set<EOModelVerificationFailure> _failures) {
        this.myDatabaseConfigMap = _map;
        this.myAdaptorName = _map.getString(ADAPTOR_NAME, true);
        if (this.myAdaptorName == null) {
            this.myAdaptorName = JDBC_ADAPTOR_NAME;
        }
        this.myPrototypeName = _map.getString("prototypeEntityName", true);
        this.setConnectionDictionary(_map.getMap(CONNECTION_DICTIONARY, true), false);
    }

    public EOModelMap toMap() {
        EOModelMap modelMap = this.myDatabaseConfigMap.cloneModelMap();
        if (this.myAdaptorName == null) {
            modelMap.setString(ADAPTOR_NAME, JDBC_ADAPTOR_NAME, true);
        } else {
            modelMap.setString(ADAPTOR_NAME, this.myAdaptorName, true);
        }
        modelMap.setString("prototypeEntityName", this.myPrototypeName, true);
        HashMap<Object, Object> connectionDictionary = new HashMap<Object, Object>(this.getConnectionDictionary());
        if (JNDI_ADAPTOR_NAME.equals(this.myAdaptorName)) {
            connectionDictionary.remove(URL);
            connectionDictionary.remove(PLUGIN);
            connectionDictionary.remove(DRIVER);
        } else if (JDBC_ADAPTOR_NAME.equals(this.myAdaptorName) || this.myAdaptorName == null) {
            connectionDictionary.remove("serverUrl");
            connectionDictionary.remove("plugInClassName");
            connectionDictionary.remove(INITIAL_CONTEXT_FACTORY);
            connectionDictionary.remove(AUTHENTICATION_METHOD);
            connectionDictionary.remove(SCOPE);
            connectionDictionary.remove(TIMEOUT);
        }
        modelMap.setMap(CONNECTION_DICTIONARY, connectionDictionary, true);
        return modelMap;
    }

    public EODatabaseConfig _cloneModelObject() {
        EODatabaseConfig databaseConfig = new EODatabaseConfig(this.myName);
        databaseConfig.myAdaptorName = this.myAdaptorName;
        databaseConfig.myPrototypeName = this.myPrototypeName;
        databaseConfig.setConnectionDictionary(new HashMap<Object, Object>(this.myConnectionDictionary));
        return databaseConfig;
    }

    @Override
    public Class<EOModel> _getModelParentType() {
        return EOModel.class;
    }

    @Override
    public EOModel _getModelParent() {
        return this.getModel();
    }

    @Override
    public void _removeFromModelParent(Set<EOModelVerificationFailure> failures) {
        this.getModel().removeDatabaseConfig(this);
    }

    @Override
    public void _addToModelParent(EOModel modelParent, boolean findUniqueName, Set<EOModelVerificationFailure> failures) throws EOModelException {
        if (findUniqueName) {
            this.setName(modelParent.findUnusedDatabaseConfigName(this.getName()));
        }
        modelParent.addDatabaseConfig(this);
    }

    public boolean canConvertToConnectionDictionary() {
        return this.getPrototype() == null;
    }
}

