/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectstyle.woenvironment.plist.ParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.eomodeler.core.Messages;
import org.objectstyle.wolips.eomodeler.core.kvc.KeyPath;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateAttributeFailure;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateAttributeNameException;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateEntityIndexFailure;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateEntityIndexNameException;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateEntityNameException;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateFetchSpecFailure;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateFetchSpecNameException;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateNameException;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateRelationshipFailure;
import org.objectstyle.wolips.eomodeler.core.model.DuplicateRelationshipNameException;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.EODeleteRule;
import org.objectstyle.wolips.eomodeler.core.model.EOEntityIndex;
import org.objectstyle.wolips.eomodeler.core.model.EOEntityParentReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOEntityRelationshipReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOFetchSpecification;
import org.objectstyle.wolips.eomodeler.core.model.EOJoin;
import org.objectstyle.wolips.eomodeler.core.model.EOLastModified;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelParserDataStructureFactory;
import org.objectstyle.wolips.eomodeler.core.model.EOModelReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOModelRenderContext;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOQualifierFactory;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.model.EORelationshipPath;
import org.objectstyle.wolips.eomodeler.core.model.EOStoredProcedure;
import org.objectstyle.wolips.eomodeler.core.model.IEOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.IEOEntityRelative;
import org.objectstyle.wolips.eomodeler.core.model.ISortableEOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.InheritanceType;
import org.objectstyle.wolips.eomodeler.core.model.MissingEntityFailure;
import org.objectstyle.wolips.eomodeler.core.model.PropertyListSet;
import org.objectstyle.wolips.eomodeler.core.model.UserInfoableEOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.VerificationContext;
import org.objectstyle.wolips.eomodeler.core.model.history.EOAttributeAddedEvent;
import org.objectstyle.wolips.eomodeler.core.model.history.EOAttributeDeletedEvent;
import org.objectstyle.wolips.eomodeler.core.model.history.EOEntityRenamedEvent;
import org.objectstyle.wolips.eomodeler.core.utils.BooleanUtils;
import org.objectstyle.wolips.eomodeler.core.utils.NamingConvention;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOEntity
extends UserInfoableEOModelObject<EOModel>
implements IEOEntityRelative,
ISortableEOModelObject,
Comparable<EOEntity> {
    private static final String EONEXT_PRIMARY_KEY_PROCEDURE = "EONextPrimaryKeyProcedure";
    private static final String EOFETCH_WITH_PRIMARY_KEY_PROCEDURE = "EOFetchWithPrimaryKeyProcedure";
    private static final String EOFETCH_ALL_PROCEDURE = "EOFetchAllProcedure";
    private static final String EOINSERT_PROCEDURE = "EOInsertProcedure";
    private static final String EODELETE_PROCEDURE = "EODeleteProcedure";
    private static final String FETCH_ALL = "FetchAll";
    public static final String ATTRIBUTE = "attribute";
    public static final String RELATIONSHIP = "relationship";
    public static final String FETCH_SPECIFICATION = "fetchSpecification";
    public static final String ENTITY_INDEX = "entityIndex";
    public static final String NAME = "name";
    public static final String CLASS_NAME = "className";
    public static final String CLIENT_CLASS_NAME = "clientClassName";
    public static final String PARENT_CLASS_NAME = "parentClassName";
    public static final String PARENT = "parent";
    public static final String PARTIAL_ENTITY = "partialEntity";
    public static final String GENERATE_SOURCE = "generateSource";
    public static final String EXTERNAL_QUERY = "externalQuery";
    public static final String MAX_NUMBER_OF_INSTANCES_TO_BATCH_FETCH = "maxNumberOfInstancesToBatchFetch";
    public static final String READ_ONLY = "readOnly";
    public static final String IMMUTABLE = "immutable";
    public static final String RAW_ROWS_ONLY = "rawRowsOnly";
    public static final String EXTERNAL_NAME = "externalName";
    public static final String ABSTRACT_ENTITY = "abstractEntity";
    public static final String CACHES_OBJECTS = "cachesObjects";
    public static final String RESTRICTING_QUALIFIER = "restrictingQualifier";
    public static final String FETCH_SPECIFICATIONS = "fetchSpecifications";
    public static final String ENTITY_INDEXES = "entityIndexes";
    public static final String ATTRIBUTES = "attributes";
    public static final String RELATIONSHIPS = "relationships";
    public static final String DELETE_PROCEDURE = "deleteProcedure";
    public static final String FETCH_ALL_PROCEDURE = "fetchAllProcedure";
    public static final String FETCH_WITH_PRIMARY_KEY_PROCEDURE = "fetchWithPrimaryKeyProcedure";
    public static final String INSERT_PROCEDURE = "insertProcedure";
    public static final String NEXT_PRIMARY_KEY_PROCEDURE = "nextPrimaryKeyProcedure";
    private EOModel myModel;
    private EOEntity myParent;
    private EOEntity myPartialEntity;
    private boolean myGenerateSource = true;
    private String myOriginalName;
    private String myName;
    private String myExternalName;
    private String myClassName;
    private String myClientClassName;
    private String myParentClassName;
    private String myRestrictingQualifier;
    private String myExternalQuery;
    private Boolean myCachesObjects;
    private Boolean myAbstractEntity;
    private Boolean myReadOnly;
    private Boolean myImmutable;
    private Boolean myRawRowsOnly;
    private Integer myMaxNumberOfInstancesToBatchFetch;
    private Set<EOAttribute> myAttributes = new LinkedHashSet<EOAttribute>();
    private Set<EORelationship> myRelationships = new LinkedHashSet<EORelationship>();
    private Set<EOFetchSpecification> myFetchSpecs = new LinkedHashSet<EOFetchSpecification>();
    private Set<EOEntityIndex> myEntityIndexes = new LinkedHashSet<EOEntityIndex>();
    private EOModelMap myEntityMap = new EOModelMap();
    private EOModelMap myFetchSpecsMap = new EOModelMap();
    private EOStoredProcedure myDeleteProcedure;
    private EOStoredProcedure myFetchAllProcedure;
    private EOStoredProcedure myFetchWithPrimaryKeyProcedure;
    private EOStoredProcedure myInsertProcedure;
    private EOStoredProcedure myNextPrimaryKeyProcedure;
    private boolean _entityDirty = true;
    private boolean _fetchSpecsDirty = true;
    private EOLastModified _lastModified;
    private EOLastModified _fspecLastModified;
    private String _cardinality;

    public EOEntity() {
    }

    public EOEntity(String _name) {
        this();
        this.myName = _name;
    }

    public EOModelMap _getEntityMap() {
        return this.myEntityMap;
    }

    public void setEntityDirty(boolean entityDirty) {
        this._entityDirty = entityDirty;
        if (!this._entityDirty) {
            this.setFetchSpecsDirty(false);
        }
    }

    public boolean isEntityDirty() {
        return this._entityDirty;
    }

    public void setFetchSpecsDirty(boolean fetchSpecsDirty) {
        this._fetchSpecsDirty = fetchSpecsDirty;
        if (this._fetchSpecsDirty) {
            this.setEntityDirty(true);
        }
    }

    public boolean isFetchSpecsDirty() {
        return this._fetchSpecsDirty;
    }

    public void setCardinality(String cardinality) {
        this._cardinality = cardinality;
        this.setEntityDirty(true);
    }

    public String getCardinality() {
        return this._cardinality;
    }

    public AbstractEOAttributePath resolveKeyPath(String _keyPath) {
        AbstractEOAttributePath targetAttribute = this.resolveKeyPath(_keyPath, null, new HashSet<EORelationship>());
        return targetAttribute;
    }

    public AbstractEOAttributePath resolveKeyPath(String _keyPath, EORelationshipPath _parentRelationshipPath, Set<EORelationship> _visitedRelationships) {
        AbstractEOAttributePath targetAttributePath = null;
        if (_keyPath != null && _keyPath.length() > 0) {
            int dotIndex = _keyPath.indexOf(46);
            if (dotIndex == -1) {
                IEOAttribute attribute = this.getAttributeOrRelationshipNamed(_keyPath);
                targetAttributePath = attribute instanceof EOAttribute ? new EOAttributePath(_parentRelationshipPath, (EOAttribute)attribute) : new EORelationshipPath(_parentRelationshipPath, (EORelationship)attribute);
            } else {
                EORelationship relationship = this.getRelationshipNamed(_keyPath.substring(0, dotIndex));
                if (relationship != null) {
                    if (_visitedRelationships.contains(relationship)) {
                        System.out.println("EOEntity.resolveKeyPath: you have an invalid flattened relationship '" + _keyPath + "' which creates a loop.");
                    } else {
                        _visitedRelationships.add(relationship);
                        EOEntity destination = relationship.getDestination();
                        if (destination != null) {
                            EORelationshipPath nextRelationshipPath = new EORelationshipPath(_parentRelationshipPath, relationship);
                            targetAttributePath = destination.resolveKeyPath(_keyPath.substring(dotIndex + 1), nextRelationshipPath, _visitedRelationships);
                        }
                    }
                }
            }
        }
        return targetAttributePath;
    }

    public void pasted() throws DuplicateNameException {
        for (EOAttribute attribute : this.getAttributes()) {
            attribute.pasted();
        }
        for (EORelationship relationship : this.getRelationships()) {
            relationship.pasted();
        }
    }

    public String _findUnusedRelationshipName(String _name, boolean _toMany) {
        String name = StringUtils.toLowercaseFirstLetter((String)_name);
        if (_toMany) {
            name = StringUtils.toPlural((String)name);
        }
        name = this.findUnusedRelationshipName(name);
        return name;
    }

    public EOEntity joinInManyToManyWith(EOEntity _entity2) throws DuplicateNameException {
        String relationshipName = this.findUnusedRelationshipName(StringUtils.toPlural((String)StringUtils.toLowercaseFirstLetter((String)_entity2.getName())));
        String inverseRelationshipName = _entity2.findUnusedRelationshipName(StringUtils.toPlural((String)StringUtils.toLowercaseFirstLetter((String)this.getName())));
        String joinEntityName = this.getModel().findUnusedEntityName(this.getName() + _entity2.getName());
        return this.joinInManyToManyWith(_entity2, true, relationshipName, true, inverseRelationshipName, joinEntityName, true);
    }

    public EOEntity joinInManyToManyWith(EOEntity _entity2, boolean createRelationship, String _relationshipName, boolean createInverseRelationship, String _inverseRelationshipName, String _joinEntityName, boolean _flatten) throws DuplicateNameException {
        EOEntity manyToManyEntity = new EOEntity(_joinEntityName);
        manyToManyEntity.setExternalName(this.getModel().getEntityNamingConvention().format(null, manyToManyEntity.getName(), null));
        HashSet<EOEntity> joiningEntitiesSet = new HashSet<EOEntity>();
        joiningEntitiesSet.add(this);
        joiningEntitiesSet.add(_entity2);
        String packageName = this.getModel().guessPackageName(joiningEntitiesSet);
        if (_flatten) {
            manyToManyEntity.setClassName("EOGenericRecord");
        } else {
            String className = manyToManyEntity.getName();
            if (packageName != null && packageName.length() > 0) {
                className = packageName + "." + className;
            }
            manyToManyEntity.setClassName(className);
        }
        EORelationship entity1Relationship = manyToManyEntity.addBlankRelationship(StringUtils.toLowercaseFirstLetter((String)this.getName()));
        entity1Relationship.setToMany(Boolean.FALSE);
        entity1Relationship.setDestination(this);
        entity1Relationship.setClassProperty(!_flatten);
        entity1Relationship.setMandatory(Boolean.TRUE);
        Iterator<EOAttribute> entity1PrimaryKeyAttributesIter = this.getPrimaryKeyAttributes().iterator();
        if (!entity1PrimaryKeyAttributesIter.hasNext()) {
            throw new IllegalStateException("The entity " + this.getFullyQualifiedName() + " does not have any primary keys.");
        }
        while (entity1PrimaryKeyAttributesIter.hasNext()) {
            EOAttribute entity1PrimaryKeyAttribute = entity1PrimaryKeyAttributesIter.next();
            EOAttribute manyToManyPrimaryKeyAttribute = entity1PrimaryKeyAttribute._cloneModelObject();
            manyToManyPrimaryKeyAttribute.setName(manyToManyEntity.findUnusedAttributeName(StringUtils.toLowercaseFirstLetter((String)this.getName()) + StringUtils.toUppercaseFirstLetter((String)manyToManyPrimaryKeyAttribute.getName())));
            manyToManyPrimaryKeyAttribute.setColumnName(this.getModel().getAttributeNamingConvention().format(null, manyToManyPrimaryKeyAttribute.getName(), null));
            EOJoin entity1Join = new EOJoin();
            entity1Join.setSourceAttribute(manyToManyPrimaryKeyAttribute);
            entity1Join.setDestinationAttribute(entity1PrimaryKeyAttribute);
            entity1Relationship.addJoin(entity1Join, false);
            manyToManyEntity.addAttribute(manyToManyPrimaryKeyAttribute);
        }
        manyToManyEntity.addRelationship(entity1Relationship);
        EORelationship entity2Relationship = manyToManyEntity.addBlankRelationship(StringUtils.toLowercaseFirstLetter((String)_entity2.getName()));
        entity2Relationship.setToMany(Boolean.FALSE);
        entity2Relationship.setDestination(_entity2);
        entity2Relationship.setClassProperty(!_flatten);
        entity2Relationship.setMandatory(Boolean.TRUE);
        Iterator<EOAttribute> entity2PrimaryKeyAttributesIter = _entity2.getPrimaryKeyAttributes().iterator();
        if (!entity2PrimaryKeyAttributesIter.hasNext()) {
            throw new IllegalStateException("The entity " + _entity2.getFullyQualifiedName() + " does not have any primary keys.");
        }
        while (entity2PrimaryKeyAttributesIter.hasNext()) {
            EOAttribute entity2PrimaryKeyAttribute = entity2PrimaryKeyAttributesIter.next();
            EOAttribute manyToManyPrimaryKeyAttribute = entity2PrimaryKeyAttribute._cloneModelObject();
            manyToManyPrimaryKeyAttribute.setName(manyToManyEntity.findUnusedAttributeName(StringUtils.toLowercaseFirstLetter((String)_entity2.getName()) + StringUtils.toUppercaseFirstLetter((String)manyToManyPrimaryKeyAttribute.getName())));
            manyToManyPrimaryKeyAttribute.setColumnName(this.getModel().getAttributeNamingConvention().format(null, manyToManyPrimaryKeyAttribute.getName(), null));
            EOJoin entity2Join = new EOJoin();
            entity2Join.setSourceAttribute(manyToManyPrimaryKeyAttribute);
            entity2Join.setDestinationAttribute(entity2PrimaryKeyAttribute);
            entity2Relationship.addJoin(entity2Join, false);
            manyToManyEntity.addAttribute(manyToManyPrimaryKeyAttribute);
        }
        manyToManyEntity.addRelationship(entity2Relationship);
        if (createRelationship) {
            String entity1ToManyName = _flatten ? StringUtils.toPlural((String)StringUtils.toLowercaseFirstLetter((String)manyToManyEntity.getName())) : _relationshipName;
            EORelationship entity1ToManyRelationship = entity1Relationship.createInverseRelationshipNamed(entity1ToManyName, true);
            entity1ToManyRelationship.setClassProperty(!_flatten);
            entity1ToManyRelationship.setPropagatesPrimaryKey(Boolean.TRUE);
            entity1ToManyRelationship.setDeleteRule(EODeleteRule.CASCADE);
            this.addRelationship(entity1ToManyRelationship);
            if (_flatten) {
                EORelationship entity1ToManyFlattenedRelationship = new EORelationship(_relationshipName, new KeyPath(new String[]{entity1ToManyRelationship.getName(), entity2Relationship.getName()}).toKeyPath());
                entity1ToManyFlattenedRelationship.setClassProperty(Boolean.TRUE);
                this.addRelationship(entity1ToManyFlattenedRelationship);
            }
        }
        if (createInverseRelationship) {
            String entity2ToManyName = _flatten ? StringUtils.toPlural((String)StringUtils.toLowercaseFirstLetter((String)manyToManyEntity.getName())) : _inverseRelationshipName;
            EORelationship entity2ToManyRelationship = entity2Relationship.createInverseRelationshipNamed(entity2ToManyName, true);
            entity2ToManyRelationship.setClassProperty(!_flatten);
            entity2ToManyRelationship.setPropagatesPrimaryKey(Boolean.TRUE);
            entity2ToManyRelationship.setDeleteRule(EODeleteRule.CASCADE);
            _entity2.addRelationship(entity2ToManyRelationship);
            if (_flatten) {
                EORelationship entity2ToManyFlattenedRelationship = new EORelationship(_inverseRelationshipName, new KeyPath(new String[]{entity2ToManyRelationship.getName(), entity1Relationship.getName()}).toKeyPath());
                entity2ToManyFlattenedRelationship.setClassProperty(Boolean.TRUE);
                _entity2.addRelationship(entity2ToManyFlattenedRelationship);
            }
        }
        this.getModel().addEntity(manyToManyEntity);
        return manyToManyEntity;
    }

    public EOAttribute getSinglePrimaryKeyAttribute() throws EOModelException {
        Set<EOAttribute> destinationPrimaryKeys = this.getPrimaryKeyAttributes();
        if (destinationPrimaryKeys.size() > 1) {
            throw new EOModelException(this.getName() + " has a compound primary key.");
        }
        EOAttribute primaryKey = destinationPrimaryKeys.iterator().next();
        return primaryKey;
    }

    public EOAttribute createForeignKeyTo(EOEntity foreignEntity, String foreignKeyName, String foreignKeyColumnName, boolean allowsNull) throws EOModelException {
        EOAttribute foreignPrimaryKey = foreignEntity.getSinglePrimaryKeyAttribute();
        EOAttribute foreignKeyAttribute = foreignPrimaryKey._cloneModelObject();
        foreignKeyAttribute.setName(foreignKeyName);
        foreignKeyAttribute.setColumnName(foreignKeyColumnName);
        foreignKeyAttribute.setAllowsNull(allowsNull);
        foreignKeyAttribute.setPrimaryKey(Boolean.FALSE);
        this.addAttribute(foreignKeyAttribute);
        return foreignKeyAttribute;
    }

    public EORelationship createRelationshipTo(EOEntity _destinationEntity, boolean _toMany) {
        return this.createRelationshipTo(_destinationEntity, _toMany, this._findUnusedRelationshipName(_destinationEntity.getName(), _toMany));
    }

    public EORelationship createRelationshipTo(EOEntity _destinationEntity, boolean _toMany, String _name) {
        EORelationship relationship = new EORelationship(_name);
        relationship.setDestination(_destinationEntity, false);
        relationship.setClassProperty(Boolean.TRUE);
        relationship.setToMany(_toMany);
        for (EOAttribute destinationPrimaryKeyAttribute : _destinationEntity.getPrimaryKeyAttributes()) {
            EOJoin inverseJoin = new EOJoin();
            inverseJoin.setDestinationAttribute(destinationPrimaryKeyAttribute, false);
            relationship.addJoin(inverseJoin, false);
        }
        relationship._setEntity(this);
        return relationship;
    }

    public EOEntity subclass(String _subclassName, InheritanceType _inheritanceType) throws DuplicateNameException {
        EOEntity subclassEntity;
        if (_inheritanceType == InheritanceType.HORIZONTAL) {
            subclassEntity = this._horizontalSubclass(_subclassName);
        } else if (_inheritanceType == InheritanceType.SINGLE_TABLE) {
            subclassEntity = this._singleTableSubclass(_subclassName);
        } else if (_inheritanceType == InheritanceType.VERTICAL) {
            subclassEntity = this._verticalSubclass(_subclassName);
        } else {
            throw new IllegalArgumentException("Unknown inheritance type " + _inheritanceType + ".");
        }
        return subclassEntity;
    }

    protected String _toSubclassName(String _subclassName) {
        String className = this.getClassName();
        if (className != null) {
            int lastDotIndex = className.lastIndexOf(46);
            className = className.substring(0, lastDotIndex + 1) + _subclassName;
        }
        return className;
    }

    public EOEntity _horizontalSubclass(String _subclassName) throws DuplicateNameException {
        EOEntity subclassEntity = this._cloneJustEntity();
        subclassEntity.setName(_subclassName, false);
        subclassEntity.myClassName = this._toSubclassName(_subclassName);
        subclassEntity.myParent = this;
        subclassEntity.myExternalName = _subclassName;
        if (subclassEntity.isAbstractEntity() != null) {
            subclassEntity.myAbstractEntity = Boolean.FALSE;
        }
        subclassEntity._cloneAttributesAndRelationshipsFrom(this, false, null, false);
        return subclassEntity;
    }

    public EOEntity _singleTableSubclass(String _subclassName) throws DuplicateNameException {
        EOEntity subclassEntity = this._cloneJustEntity();
        subclassEntity.setName(_subclassName, false);
        subclassEntity.myClassName = this._toSubclassName(_subclassName);
        subclassEntity.myParent = this;
        if (subclassEntity.isAbstractEntity() != null) {
            subclassEntity.myAbstractEntity = Boolean.FALSE;
        }
        subclassEntity._cloneAttributesAndRelationshipsFrom(this, false, null, false);
        return subclassEntity;
    }

    public EOEntity _verticalSubclass(String _subclassName) throws DuplicateNameException {
        EOEntity subclassEntity = this._cloneJustEntity();
        subclassEntity.setName(_subclassName, false);
        subclassEntity.myClassName = this._toSubclassName(_subclassName);
        subclassEntity.myParent = this;
        subclassEntity.myExternalName = _subclassName;
        if (subclassEntity.isAbstractEntity() != null) {
            subclassEntity.myAbstractEntity = Boolean.FALSE;
        }
        List<EOEntity> ancestors = this.getAncestors();
        Collections.reverse(ancestors);
        ancestors.add(this);
        for (EOEntity ancestor : ancestors) {
            EORelationship superclassRelationship = EOEntity._subclassParentRelationship(ancestor, subclassEntity);
            EOEntity._flattenParentAttributes(ancestor, subclassEntity, superclassRelationship);
            EOEntity._flattenParentRelationships(ancestor, subclassEntity, superclassRelationship);
        }
        return subclassEntity;
    }

    protected static EORelationship _subclassParentRelationship(EOEntity parent, EOEntity subclassEntity) throws DuplicateNameException {
        EORelationship superclassRelationship = subclassEntity.addBlankRelationship(subclassEntity.findUnusedRelationshipName(StringUtils.toLowercaseFirstLetter((String)parent.getName())));
        superclassRelationship.setToMany(Boolean.FALSE);
        superclassRelationship.setDestination(parent);
        superclassRelationship.setClassProperty(Boolean.FALSE, false);
        superclassRelationship.setMandatory(Boolean.TRUE);
        superclassRelationship.setOwnsDestination(Boolean.TRUE);
        superclassRelationship.setDeleteRule(EODeleteRule.CASCADE);
        boolean clonePK = subclassEntity.getPrimaryKeyAttributes().isEmpty();
        Set<EOAttribute> primaryKeyAttributes = parent.getPrimaryKeyAttributes();
        for (EOAttribute superclassPrimaryKeyAttribute : primaryKeyAttributes) {
            EOAttribute subclassPrimaryKeyAttribute = clonePK ? superclassPrimaryKeyAttribute._cloneModelObject() : subclassEntity.getAttributeNamed(superclassPrimaryKeyAttribute.getName());
            EOJoin superclassJoin = new EOJoin();
            superclassJoin.setSourceAttribute(subclassPrimaryKeyAttribute);
            superclassJoin.setDestinationAttribute(superclassPrimaryKeyAttribute);
            superclassRelationship.addJoin(superclassJoin, false);
            if (!clonePK) continue;
            subclassEntity.addAttribute(subclassPrimaryKeyAttribute);
        }
        return superclassRelationship;
    }

    protected static void _flattenParentAttributes(EOEntity parent, EOEntity subclassEntity, EORelationship superclassRelationship) throws DuplicateNameException {
        Set<EOAttribute> primaryKeyAttributes = parent.getPrimaryKeyAttributes();
        for (EOAttribute parentAttribute : parent.getAttributes()) {
            if (primaryKeyAttributes.contains(parentAttribute) || parentAttribute.isInherited()) continue;
            EOAttributePath inheritedAttributePath = new EOAttributePath(new EORelationshipPath(null, superclassRelationship), parentAttribute);
            EOAttribute inheritedAttribute = subclassEntity.addBlankAttribute(parentAttribute.getName(), inheritedAttributePath);
            inheritedAttribute.setClassProperty(parentAttribute.isClassProperty());
        }
    }

    protected static void _flattenParentRelationships(EOEntity parent, EOEntity subclassEntity, EORelationship superclassRelationship) throws DuplicateNameException {
        for (EORelationship parentRelationship : parent.getRelationships()) {
            if (!BooleanUtils.isTrue(parentRelationship.isClassProperty()) || parentRelationship.isInherited()) continue;
            EORelationshipPath inheritedRelationshipPath = new EORelationshipPath(new EORelationshipPath(null, superclassRelationship), parentRelationship);
            subclassEntity.addBlankRelationship(parentRelationship.getName(), inheritedRelationshipPath);
        }
    }

    protected void _cloneFetchSpecificationsFrom(EOEntity _entity, boolean _skipExistingNames) throws DuplicateNameException {
        for (EOFetchSpecification fetchSpec : _entity.getFetchSpecs()) {
            if (_skipExistingNames && this.getFetchSpecNamed(fetchSpec.getName()) != null) continue;
            EOFetchSpecification clonedFetchSpec = fetchSpec._cloneModelObject();
            clonedFetchSpec.setName(this.findUnusedFetchSpecificationName(clonedFetchSpec.getName()));
            this.addFetchSpecification(clonedFetchSpec);
        }
    }

    protected void _cloneEntityIndexesFrom(EOEntity _entity, boolean _skipExistingNames) throws DuplicateNameException {
        for (EOEntityIndex entityIndex : _entity.getEntityIndexes()) {
            if (_skipExistingNames && this.getEntityIndexNamed(entityIndex.getName()) != null) continue;
            EOEntityIndex clonedEntityIndex = entityIndex._cloneModelObject();
            clonedEntityIndex.setName(this.findUnusedEntityIndexName(clonedEntityIndex.getName()));
            this.addEntityIndex(clonedEntityIndex);
        }
    }

    protected void _cloneAttributesAndRelationshipsFrom(EOEntity _entity, boolean _skipExistingNames, Set<EOModelVerificationFailure> failures, boolean warnOnly) throws DuplicateNameException {
        for (EOAttribute attribute : _entity.getAttributes()) {
            if (_skipExistingNames && this.getAttributeNamed(attribute.getName()) != null) continue;
            if (failures != null) {
                failures.add(new EOModelVerificationFailure(this.getModel(), this, "The entity " + this.getName() + " was missing the inherited attribute '" + attribute.getName() + "'.", true));
            }
            if (warnOnly) continue;
            EOAttribute clonedAttribute = attribute._cloneModelObject();
            clonedAttribute.setName(this.findUnusedAttributeName(clonedAttribute.getName()), false);
            this.addAttribute(clonedAttribute);
        }
        for (EORelationship relationship : _entity.getRelationships()) {
            if (_skipExistingNames && this.getRelationshipNamed(relationship.getName()) != null) continue;
            if (failures != null) {
                failures.add(new EOModelVerificationFailure(this.getModel(), this, "The entity " + this.getName() + " was missing the inherited relationship '" + relationship.getName() + "'.", true));
            }
            if (warnOnly) continue;
            EORelationship clonedRelationship = relationship._cloneModelObject();
            clonedRelationship.setName(this.findUnusedRelationshipName(clonedRelationship.getName()), false);
            this.addRelationship(clonedRelationship, false, null, true);
        }
    }

    protected void _cloneAttributesAndRelationships(Set<IEOAttribute> attributesAndRelationships) throws DuplicateNameException {
        for (IEOAttribute attributeOrRelationship : attributesAndRelationships) {
            if (attributeOrRelationship instanceof EOAttribute) {
                EOAttribute attribute = (EOAttribute)attributeOrRelationship;
                EOAttribute clonedAttribute = attribute._cloneModelObject();
                clonedAttribute.setName(this.findUnusedAttributeName(clonedAttribute.getName()));
                this.addAttribute(clonedAttribute);
                continue;
            }
            EORelationship relationship = (EORelationship)attributeOrRelationship;
            EORelationship clonedRelationship = relationship._cloneModelObject();
            clonedRelationship.setName(this.findUnusedRelationshipName(clonedRelationship.getName()));
            this.addRelationship(clonedRelationship, false, null, true);
        }
    }

    protected Set<IEOAttribute> _findMissingInheritedAttributesAndRelationships() {
        HashSet<IEOAttribute> missingInheritedAttributesAndRelationships = new HashSet<IEOAttribute>();
        EOEntity parentEntity = this.getParent();
        if (parentEntity != null) {
            for (EOAttribute attribute : parentEntity.getAttributes()) {
                if (this.getAttributeNamed(attribute.getName()) != null) continue;
                missingInheritedAttributesAndRelationships.add(attribute);
            }
            for (EORelationship relationship : parentEntity.getRelationships()) {
                if (this.getRelationshipNamed(relationship.getName()) != null) continue;
                missingInheritedAttributesAndRelationships.add(relationship);
            }
        }
        return missingInheritedAttributesAndRelationships;
    }

    @Override
    public EOEntity getEntity() {
        return this;
    }

    public IEOAttribute addBlankIEOAttribute(AbstractEOAttributePath _flattenAttribute) throws DuplicateNameException {
        if (_flattenAttribute instanceof EORelationshipPath) {
            return this.addBlankRelationship((EORelationshipPath)_flattenAttribute);
        }
        if (_flattenAttribute instanceof EOAttributePath) {
            return this.addBlankAttribute((EOAttributePath)_flattenAttribute);
        }
        throw new IllegalArgumentException("Unknown attribute path: " + _flattenAttribute);
    }

    public EORelationship addBlankRelationship(String _name) throws DuplicateNameException {
        return this.addBlankRelationship(_name, null);
    }

    public EORelationship addBlankRelationship(EORelationshipPath _flattenRelationship) throws DuplicateNameException {
        return this.addBlankRelationship(_flattenRelationship.toKeyPath().replace('.', '_'), _flattenRelationship);
    }

    public EORelationship addBlankRelationship(String _name, EORelationshipPath _flattenRelationship) throws DuplicateNameException {
        String newRelationshipName = this.findUnusedRelationshipName(_name);
        EORelationship relationship = _flattenRelationship != null ? new EORelationship(newRelationshipName, _flattenRelationship.toKeyPath()) : new EORelationship(newRelationshipName);
        relationship.setClassProperty(Boolean.TRUE);
        this.addRelationship(relationship);
        return relationship;
    }

    public EOAttribute _getTemplateNameAttribute(boolean checkOtherEntities) {
        EOAttribute templateNameAttribute = null;
        Set<EOAttribute> attributes = this.getAttributes();
        for (EOAttribute attribute : attributes) {
            String attributeName = attribute.getName();
            if (StringUtils.camelCaseToUnderscore((String)attributeName).indexOf(95) == -1) continue;
            templateNameAttribute = attribute;
            break;
        }
        if (templateNameAttribute == null && checkOtherEntities) {
            EOModel model = this.getModel();
            if (model != null) {
                for (EOEntity entity : model.getEntities()) {
                    if (entity != this && (templateNameAttribute = entity._getTemplateNameAttribute(false)) != null) break;
                }
            }
            if (templateNameAttribute == null && !attributes.isEmpty()) {
                templateNameAttribute = attributes.iterator().next();
            }
        }
        return templateNameAttribute;
    }

    public EOAttribute addBlankAttribute(String _name) throws DuplicateNameException {
        return this.addBlankAttribute(_name, null);
    }

    public EOAttribute addBlankAttribute(EOAttributePath _flattenAttribute) throws DuplicateNameException {
        return this.addBlankAttribute(_flattenAttribute.toKeyPath().replace('.', '_'), _flattenAttribute);
    }

    public EOAttribute addBlankAttribute(String _name, EOAttributePath _flattenAttribute) throws DuplicateNameException {
        EOAttribute attribute;
        String newAttributeName = this.findUnusedAttributeName(_name);
        if (_flattenAttribute != null) {
            EOAttribute attributeToFlatten = _flattenAttribute.getChildAttribute();
            attribute = attributeToFlatten._cloneModelObject();
            attribute.setName(newAttributeName);
            attribute.setColumnName("");
            attribute.setClassProperty(Boolean.TRUE);
            this.addAttribute(attribute);
            attribute.setDefinition(_flattenAttribute.toKeyPath());
        } else {
            attribute = new EOAttribute(newAttributeName);
            attribute.setUsedForLocking(Boolean.TRUE);
            attribute.synchronizeNameChange(newAttributeName, newAttributeName);
            attribute.guessColumnNameInEntity(this);
            attribute.setClassProperty(Boolean.TRUE);
            this.addAttribute(attribute);
        }
        return attribute;
    }

    public EOFetchSpecification addBlankFetchSpec(String _name) throws DuplicateFetchSpecNameException {
        String newFetchSpecName = this.findUnusedFetchSpecificationName(_name);
        EOFetchSpecification fetchSpec = new EOFetchSpecification(newFetchSpecName);
        this.addFetchSpecification(fetchSpec);
        return fetchSpec;
    }

    @Override
    protected void _propertyChanged(String _propertyName, Object _oldValue, Object _newValue) {
        if (this.myModel != null) {
            this.setEntityDirty(true);
            if (FETCH_SPECIFICATIONS.equals(_propertyName)) {
                this.setFetchSpecsDirty(true);
            }
            this.myModel._entityChanged(this, _propertyName, _oldValue, _newValue);
        }
    }

    public boolean hasSharedObjects() {
        boolean hasSharedObjects = false;
        Iterator<EOFetchSpecification> fetchSpecsIter = this.myFetchSpecs.iterator();
        while (!hasSharedObjects && fetchSpecsIter.hasNext()) {
            EOFetchSpecification fetchSpec = fetchSpecsIter.next();
            hasSharedObjects = BooleanUtils.isTrue(fetchSpec.isSharesObjects());
        }
        return hasSharedObjects;
    }

    public void shareNoObjects() {
        for (EOFetchSpecification fetchSpec : this.myFetchSpecs) {
            fetchSpec.setSharesObjects(Boolean.FALSE);
        }
    }

    public boolean isSharesAllObjectsOnly() {
        boolean sharesAllObjects = false;
        int sharedFetchSpecCount = 0;
        for (EOFetchSpecification fetchSpec : this.myFetchSpecs) {
            if (!BooleanUtils.isTrue(fetchSpec.isSharesObjects())) continue;
            ++sharedFetchSpecCount;
            if (!FETCH_ALL.equals(fetchSpec.getName())) continue;
            sharesAllObjects = true;
        }
        return sharesAllObjects && sharedFetchSpecCount == 1;
    }

    public void shareAllObjects() throws DuplicateFetchSpecNameException {
        EOFetchSpecification fetchAllFetchSpec = this.getFetchSpecNamed(FETCH_ALL);
        if (fetchAllFetchSpec != null) {
            fetchAllFetchSpec.setSharesObjects(Boolean.TRUE);
        } else {
            fetchAllFetchSpec = new EOFetchSpecification(FETCH_ALL);
            fetchAllFetchSpec.setSharesObjects(Boolean.TRUE, false);
            this.addFetchSpecification(fetchAllFetchSpec);
        }
    }

    @Override
    public Object getAdapter(Class _adapter) {
        Object adapter = null;
        return adapter;
    }

    public void _setModel(EOModel _model) {
        this.myModel = _model;
    }

    public EOModel getModel() {
        return this.myModel;
    }

    public boolean isPrototype() {
        return this.myName != null && this.myName.startsWith("EO") && this.myName.indexOf("Prototypes") != -1;
    }

    public String getExternalQuery() {
        return this.myExternalQuery;
    }

    public void setExternalQuery(String _externalQuery) {
        String oldExternalQuery = this.myExternalQuery;
        this.myExternalQuery = _externalQuery;
        this.firePropertyChange(EXTERNAL_QUERY, oldExternalQuery, this.myExternalQuery);
    }

    public Integer getMaxNumberOfInstancesToBatchFetch() {
        return this.myMaxNumberOfInstancesToBatchFetch;
    }

    public void setMaxNumberOfInstancesToBatchFetch(Integer _maxNumberOfInstancesToBatchFetch) {
        Integer oldMaxNumberOfInstancesToBatchFetch = this.myMaxNumberOfInstancesToBatchFetch;
        this.myMaxNumberOfInstancesToBatchFetch = _maxNumberOfInstancesToBatchFetch;
        this.firePropertyChange(MAX_NUMBER_OF_INSTANCES_TO_BATCH_FETCH, oldMaxNumberOfInstancesToBatchFetch, this.myMaxNumberOfInstancesToBatchFetch);
    }

    public Boolean getReadOnly() {
        return this.isReadOnly();
    }

    public Boolean isReadOnly() {
        return this.myReadOnly;
    }

    public void setReadOnly(Boolean _readOnly) {
        Boolean oldReadOnly = this.myReadOnly;
        this.myReadOnly = _readOnly;
        this.firePropertyChange(READ_ONLY, oldReadOnly, this.myReadOnly);
    }

    public Boolean getImmutable() {
        return this.isImmutable();
    }

    public Boolean isImmutable() {
        return this.myImmutable;
    }

    public void setImmutable(Boolean _immutable) {
        Boolean oldImmutable = this.myImmutable;
        this.myImmutable = _immutable;
        this.firePropertyChange(IMMUTABLE, oldImmutable, this.myImmutable);
    }

    public Boolean getRawRowsOnly() {
        return this.isRawRowsOnly();
    }

    public Boolean isRawRowsOnly() {
        return this.myRawRowsOnly;
    }

    public void setRawRowsOnly(Boolean _rawRowsOnly) {
        Boolean oldRawRowsOnly = this.myRawRowsOnly;
        this.myRawRowsOnly = _rawRowsOnly;
        this.firePropertyChange(RAW_ROWS_ONLY, oldRawRowsOnly, this.myRawRowsOnly);
    }

    public String getPluralName() {
        return StringUtils.toPlural((String)this.myName);
    }

    public String getInitialLowercaseName() {
        return StringUtils.toLowercaseFirstLetter((String)this.getName());
    }

    public String getPluralInitialLowercaseName() {
        return StringUtils.toLowercaseFirstLetter((String)StringUtils.toPlural((String)this.getName()));
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void setName(String _name) throws DuplicateEntityNameException {
        this.setName(_name, true);
    }

    public void setName(String _name, boolean _fireEvents) throws DuplicateEntityNameException {
        if (_name == null) {
            throw new NullPointerException(Messages.getString("EOEntity.noBlankEntityNames"));
        }
        String oldName = this.myName;
        if (this.myModel != null) {
            this.myModel._checkForDuplicateEntityName(this, _name, null);
            this.myModel._entityNameChanged(this.myOriginalName, oldName, _name);
            this.myModel.getModelEvents().addEvent(new EOEntityRenamedEvent(this));
        }
        this.myName = _name;
        if (_fireEvents) {
            this.synchronizeNameChange(oldName, this.myName);
            this.firePropertyChange(NAME, oldName, this.myName);
            if (this.myModel != null) {
                for (EORelationship relationship : this.getReferencingRelationships()) {
                    if (relationship.getEntity().getModel() != this.myModel) {
                        relationship.getEntity().getModel().setDirty(true);
                    }
                    relationship.getEntity().setEntityDirty(true);
                }
                for (EOEntity childEntity : this.getChildrenEntities()) {
                    if (childEntity.getModel() != this.myModel) {
                        childEntity.getModel().setDirty(true);
                    }
                    childEntity.setEntityDirty(true);
                }
            }
        }
    }

    public String getOriginalName() {
        return this.myOriginalName;
    }

    public boolean isGenericRecord() {
        String className = EOModelRenderContext.getInstance().getClassNameForEntity(this);
        boolean isGenericRecord = className == null || className.length() == 0 || className.endsWith("GenericRecord");
        return isGenericRecord;
    }

    public String getClassNameWithDefault() {
        String className = EOModelRenderContext.getInstance().getClassNameForEntity(this);
        if (className == null) {
            className = EOModelRenderContext.getInstance().getEOGenericRecordClassName();
        }
        return className;
    }

    public String getPackageName() {
        int lastDotIndex;
        String className = this.getClassNameWithDefault();
        String packageName = className == null ? null : ((lastDotIndex = className.lastIndexOf(46)) == -1 ? null : className.substring(0, lastDotIndex));
        return packageName;
    }

    public String getSuperclassPackageName() {
        String packageName = this.getPackageName();
        String superclassPackage = EOModelRenderContext.getInstance().getSuperclassPackage();
        String superclassPackageName = superclassPackage != null ? (packageName != null ? packageName + "." + superclassPackage : superclassPackage) : packageName;
        return superclassPackageName;
    }

    public String getInitialLowercaseClassNameWithoutPackage() {
        return StringUtils.toLowercaseFirstLetter((String)this.getClassNameWithoutPackage());
    }

    public String getPluralInitialLowercaseClassNameWithoutPackage() {
        return StringUtils.toLowercaseFirstLetter((String)StringUtils.toPlural((String)this.getClassNameWithoutPackage()));
    }

    public String getClassNameWithOptionalPackage() {
        String className = EOModelRenderContext.getInstance().getSuperclassPackage() != null ? EOModelRenderContext.getInstance().getClassNameForEntity(this) : this.getClassNameWithoutPackage();
        return className;
    }

    public String getClassNameWithoutPackage() {
        int lastDotIndex;
        String className = this.getClassNameWithDefault();
        String classNameWithoutPackage = className == null ? null : ((lastDotIndex = className.lastIndexOf(46)) == -1 ? className : className.substring(lastDotIndex + 1));
        return classNameWithoutPackage;
    }

    public String getPrefixClassNameWithOptionalPackage() {
        String prefixClassName = EOModelRenderContext.getInstance().getSuperclassPackage() != null ? this.getPrefixClassName() : this.getPrefixClassNameWithoutPackage();
        return prefixClassName;
    }

    public String getPrefixClassNameWithoutPackage() {
        String prefixClassNameWithoutPackage = this.getClassNameWithoutPackage();
        if (prefixClassNameWithoutPackage != null) {
            String prefix = EOModelRenderContext.getInstance().getPrefix();
            prefixClassNameWithoutPackage = prefix + prefixClassNameWithoutPackage;
        }
        return prefixClassNameWithoutPackage;
    }

    public String getPrefixClassName() {
        String prefixClassName;
        String className = this.getClassNameWithDefault();
        if (className == null) {
            prefixClassName = null;
        } else {
            String superclassPackage = EOModelRenderContext.getInstance().getSuperclassPackage();
            superclassPackage = superclassPackage != null && superclassPackage.trim().length() > 0 ? superclassPackage + "." : "";
            String prefix = EOModelRenderContext.getInstance().getPrefix();
            int lastDotIndex = className.lastIndexOf(46);
            prefixClassName = lastDotIndex == -1 ? superclassPackage + prefix + className : className.substring(0, lastDotIndex + 1) + superclassPackage + prefix + className.substring(lastDotIndex + 1);
        }
        return prefixClassName;
    }

    public boolean isClassNameSet() {
        return EOModelRenderContext.getInstance().getClassNameForEntity(this) != null;
    }

    public String getClassName() {
        return this.myClassName;
    }

    public String getClassNamePath() {
        String classNamePath = this.getClassName();
        if (classNamePath != null && classNamePath.length() > 0) {
            classNamePath = classNamePath.replace('.', '/');
        }
        return classNamePath;
    }

    public void guessClassNameInModel(EOModel model) {
        String className = this.getName();
        String packageName = null;
        if (model != null) {
            packageName = model.guessPackageName();
        }
        if (packageName != null && packageName.length() > 0) {
            className = packageName + "." + className;
        }
        this.setClassName(className);
    }

    public void setClassName(String _className) {
        String oldClassName = this.myClassName;
        this.myClassName = _className;
        this.firePropertyChange(CLASS_NAME, oldClassName, this.myClassName);
    }

    public String getClientClassName() {
        return this.myClientClassName;
    }

    public void setClientClassName(String _clientClassName) {
        String oldClientClassName = this.myClientClassName;
        this.myClientClassName = _clientClassName;
        this.firePropertyChange(CLIENT_CLASS_NAME, oldClientClassName, this.myClientClassName);
    }

    public boolean isParentClassNameSet() {
        return this.myParentClassName != null;
    }

    public String getParentClassName() {
        return this.myParentClassName;
    }

    public void setParentClassName(String _parentClassName) {
        String oldParentClassName = this.myParentClassName;
        this.myParentClassName = _parentClassName;
        this.firePropertyChange(PARENT_CLASS_NAME, oldParentClassName, this.myParentClassName);
    }

    public String getExternalName() {
        return this.myExternalName;
    }

    public void guessExternalNameInModel(EOModel model) {
        String externalName = this.getName();
        if (model != null) {
            externalName = model.getEntityNamingConvention().format(externalName);
        }
        this.setExternalName(externalName);
    }

    public void setExternalName(String _externalName) {
        String oldExternalName = this.myExternalName;
        this.myExternalName = _externalName;
        this.firePropertyChange(EXTERNAL_NAME, oldExternalName, this.myExternalName);
    }

    @Override
    public Set<EOModelReferenceFailure> getReferenceFailures() {
        HashSet<EOModelReferenceFailure> referenceFailures = new HashSet<EOModelReferenceFailure>();
        for (EOEntity referencingEntity : this.getChildrenEntities()) {
            referenceFailures.add(new EOEntityParentReferenceFailure(referencingEntity, this));
        }
        for (EORelationship referencingRelationship : this.getReferencingRelationships()) {
            referenceFailures.add(new EOEntityRelationshipReferenceFailure(referencingRelationship, this));
        }
        return referenceFailures;
    }

    public Set<EOEntity> getReferencedEntities(boolean recursive) {
        HashSet<EOEntity> referencedEntities = new HashSet<EOEntity>();
        this.fillInReferencedEntities(recursive, referencedEntities);
        return referencedEntities;
    }

    public void fillInReferencedEntities(boolean recursive, Set<EOEntity> allReferencedEntities) {
        PropertyListSet referencedEntities = new PropertyListSet();
        referencedEntities.addAll(this.getAncestors());
        if (this.getPartialEntity() != null) {
            referencedEntities.add(this.getPartialEntity());
        }
        for (EOAttribute attribute : this.getAttributes()) {
            if (!attribute.isFlattened()) continue;
            for (AbstractEOAttributePath path : attribute.getDefinitionPath().getPathElements()) {
                referencedEntities.add(path.getEntity());
            }
        }
        for (EORelationship relationship : this.getRelationships()) {
            if (!relationship.isToOne().booleanValue()) continue;
            if (relationship.isFlattened()) {
                for (AbstractEOAttributePath path : relationship.getDefinitionPath().getPathElements()) {
                    referencedEntities.add(path.getEntity());
                }
                continue;
            }
            EOEntity destination = relationship.getDestination();
            referencedEntities.add(destination);
        }
        if (recursive) {
            HashSet<EOEntity> existingReferencedEntities = new HashSet<EOEntity>(allReferencedEntities);
            allReferencedEntities.addAll(referencedEntities);
            for (EOEntity e : referencedEntities) {
                if (e == this || existingReferencedEntities.contains(e)) continue;
                e.fillInReferencedEntities(recursive, allReferencedEntities);
            }
        } else {
            allReferencedEntities.addAll(referencedEntities);
        }
    }

    public Set<EOEntity> getReferencingEntities() {
        PropertyListSet<EOEntity> referencingEntities = new PropertyListSet<EOEntity>();
        for (EORelationship relationship : this.getReferencingRelationships()) {
            referencingEntities.add(relationship.getEntity());
        }
        return referencingEntities;
    }

    public Set<EORelationship> getReferencingRelationships() {
        LinkedHashSet<EORelationship> referencingRelationships = new LinkedHashSet<EORelationship>();
        for (EOModel model : this.getModel().getModelGroup().getModels()) {
            for (EOEntity entity : model.getEntities()) {
                if (entity.equals(this)) continue;
                for (EORelationship relationship : entity.getRelationships()) {
                    if (!relationship.isRelatedTo(this)) continue;
                    referencingRelationships.add(relationship);
                }
            }
        }
        return referencingRelationships;
    }

    public Set<EOEntity> getChildrenEntities() {
        PropertyListSet<EOEntity> children = new PropertyListSet<EOEntity>();
        if (this.myModel != null) {
            for (EOModel model : this.getModel().getModelGroup().getModels()) {
                for (EOEntity entity : model.getEntities()) {
                    if (entity.getParent() != this) continue;
                    children.add(entity);
                }
            }
        }
        return children;
    }

    public boolean isParentSet() {
        return this.myParent != null;
    }

    public List<EOEntity> getAncestors() {
        LinkedList<EOEntity> ancestors = new LinkedList<EOEntity>();
        EOEntity parent = this;
        while ((parent = parent.getParent()) != null) {
            ancestors.add(parent);
        }
        return ancestors;
    }

    public EOEntity getParent() {
        return this.myParent;
    }

    public void setParent(EOEntity _parent) {
        EOEntity oldParent = this.myParent;
        this.myParent = _parent;
        this.firePropertyChange(PARENT, oldParent, this.myParent);
    }

    public boolean isPartialBase() {
        for (EOModel model : this.getModel().getModelGroup().getModels()) {
            for (EOEntity entity : model.getEntities()) {
                if (entity.getPartialEntity() != this) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPartialEntitySet() {
        return this.myPartialEntity != null;
    }

    public EOEntity getPartialEntity() {
        return this.myPartialEntity;
    }

    public void setPartialEntity(EOEntity partialEntity) {
        EOEntity oldPartialEntity = this.myPartialEntity;
        this.myPartialEntity = partialEntity;
        this.firePropertyChange(PARTIAL_ENTITY, oldPartialEntity, this.myPartialEntity);
    }

    public boolean isGenerateSource() {
        return this.myGenerateSource;
    }

    public void setGenerateSource(boolean generateSource) {
        boolean oldGenerateSource = this.myGenerateSource;
        this.myGenerateSource = generateSource;
        this.firePropertyChange(GENERATE_SOURCE, oldGenerateSource, this.myGenerateSource);
    }

    public void inheritParentAttributesAndRelationships(Set<EOModelVerificationFailure> failures, boolean warnOnly) throws DuplicateNameException {
        EOEntity parent = this.getParent();
        if (parent != null) {
            if (parent.getModel() == this.getModel()) {
                parent.inheritParentAttributesAndRelationships(failures, warnOnly);
            }
            if (!this.isVerticalInheritance()) {
                this._cloneAttributesAndRelationshipsFrom(parent, true, failures, warnOnly);
            }
        }
    }

    public Boolean getAbstractEntity() {
        return this.isAbstractEntity();
    }

    public Boolean isAbstractEntity() {
        return this.myAbstractEntity;
    }

    public boolean isInherited() {
        return this.getParent() != null;
    }

    public boolean isSingleTableInheritance() {
        return this.isInherited() && ComparisonUtils.equals((Object)this.getExternalName(), (Object)this.getParent().getExternalName());
    }

    public boolean isVerticalInheritance() {
        boolean verticalInheritance = false;
        if (this.isInherited() && !this.isSingleTableInheritance()) {
            EOEntity parent = this.getParent();
            Iterator<EORelationship> relationshipsIter = this.getRelationships().iterator();
            while (!verticalInheritance && relationshipsIter.hasNext()) {
                EORelationship relationship = relationshipsIter.next();
                verticalInheritance = ComparisonUtils.equals((Object)relationship.getDestination(), (Object)parent) && (relationship.getClassProperty() == null || relationship.getClassProperty() == false);
            }
        }
        return verticalInheritance;
    }

    public boolean isHorizontalInheritance() {
        return this.isInherited() && !this.isSingleTableInheritance() && !this.isVerticalInheritance();
    }

    public void setAbstractEntity(Boolean _abstractEntity) {
        Boolean oldAbstractEntity = this.myAbstractEntity;
        this.myAbstractEntity = _abstractEntity;
        this.firePropertyChange(ABSTRACT_ENTITY, oldAbstractEntity, this.myAbstractEntity);
    }

    public Boolean getCachesObjects() {
        return this.isCachesObjects();
    }

    public Boolean isCachesObjects() {
        return this.myCachesObjects;
    }

    public void setCachesObjects(Boolean _cachesObjects) {
        Boolean oldCachesObjects = this.myCachesObjects;
        this.myCachesObjects = _cachesObjects;
        this.firePropertyChange(CACHES_OBJECTS, oldCachesObjects, this.myCachesObjects);
    }

    public String getRestrictingQualifier() {
        return this.myRestrictingQualifier;
    }

    public void setRestrictingQualifier(String _restrictingQualifier) {
        String oldRestrictingQualifier = this.myRestrictingQualifier;
        this.myRestrictingQualifier = _restrictingQualifier;
        this.firePropertyChange(RESTRICTING_QUALIFIER, oldRestrictingQualifier, this.myRestrictingQualifier);
    }

    public Set<String> getRestrictingQualifierKeys() {
        Set<Object> restrictingQualifierKeys = this.myRestrictingQualifier == null ? new LinkedHashSet() : EOQualifierFactory.getQualifierKeysFromQualifierString(this.myRestrictingQualifier);
        return restrictingQualifierKeys;
    }

    public void clearCachedPrototypes(Set<EOModelVerificationFailure> _failures, boolean _reload) {
        for (EOAttribute attribute : this.myAttributes) {
            attribute.clearCachedPrototype(_failures, _reload);
        }
    }

    public Set<EOAttribute> getPrimaryKeyAttributes() {
        LinkedHashSet<EOAttribute> primaryKeyAttributes = new LinkedHashSet<EOAttribute>();
        for (EOAttribute attribute : this.myAttributes) {
            Boolean primaryKey = attribute.isPrimaryKey();
            if (!BooleanUtils.isTrue(primaryKey)) continue;
            primaryKeyAttributes.add(attribute);
        }
        return primaryKeyAttributes;
    }

    public void setAttributes(Set<EOAttribute> _attributes) {
        this.myAttributes = _attributes;
        this.firePropertyChange(ATTRIBUTES, null, null);
    }

    public Set<EOAttribute> getClientClassAttributes() {
        LinkedHashSet<EOAttribute> clientClassAttributes = new LinkedHashSet<EOAttribute>();
        for (EOAttribute attribute : this.getAttributes()) {
            if (attribute.isClientClassProperty() == null || !attribute.isClientClassProperty().booleanValue()) continue;
            clientClassAttributes.add(attribute);
        }
        return clientClassAttributes;
    }

    public Set<EOAttribute> getSortedClientClassAttributes() {
        return new PropertyListSet<EOAttribute>((Collection<EOAttribute>)this.getClientClassAttributes());
    }

    public Set<EOAttribute> getCommonClassAttributes() {
        LinkedHashSet<EOAttribute> commonClassAttributes = new LinkedHashSet<EOAttribute>();
        for (EOAttribute attribute : this.getAttributes()) {
            if (attribute.isCommonClassProperty() == null || !attribute.isCommonClassProperty().booleanValue()) continue;
            commonClassAttributes.add(attribute);
        }
        return commonClassAttributes;
    }

    public Set<EOAttribute> getSortedCommonClassAttributes() {
        return new PropertyListSet<EOAttribute>((Collection<EOAttribute>)this.getCommonClassAttributes());
    }

    public Set<EOAttribute> getClassAttributes() {
        LinkedHashSet<EOAttribute> classAttributes = new LinkedHashSet<EOAttribute>();
        for (EOAttribute attribute : this.getAttributes()) {
            if (attribute.isClassProperty() == null || !attribute.isClassProperty().booleanValue()) continue;
            classAttributes.add(attribute);
        }
        return classAttributes;
    }

    public Set<EOAttribute> getSortedClassAttributes() {
        return new PropertyListSet<EOAttribute>((Collection<EOAttribute>)this.getClassAttributes());
    }

    public Set<EOAttribute> getNonClassAttributes() {
        LinkedHashSet<EOAttribute> nonClassAttributes = new LinkedHashSet<EOAttribute>();
        for (EOAttribute attribute : this.getAttributes()) {
            if (attribute.isClassProperty() != null && attribute.isClassProperty().booleanValue()) continue;
            nonClassAttributes.add(attribute);
        }
        return nonClassAttributes;
    }

    public Set<EOAttribute> getInheritedAttributes() {
        LinkedHashSet<EOAttribute> inheritedAttributes = new LinkedHashSet<EOAttribute>();
        for (EOAttribute attribute : this.getAttributes()) {
            if (!attribute.isInherited()) continue;
            inheritedAttributes.add(attribute);
        }
        return inheritedAttributes;
    }

    public Set<EOAttribute> getAttributes() {
        return this.myAttributes;
    }

    public Set<EOAttribute> getSortedAttributes() {
        return new PropertyListSet<EOAttribute>((Collection<EOAttribute>)this.myAttributes);
    }

    public String[] getAttributeNames() {
        Set<EOAttribute> attributes = this.getAttributes();
        Object[] attributeNames = new String[attributes.size()];
        Iterator<EOAttribute> attributeIter = attributes.iterator();
        int attributeNum = 0;
        while (attributeIter.hasNext()) {
            EOAttribute attribute = attributeIter.next();
            attributeNames[attributeNum] = attribute.getName();
            ++attributeNum;
        }
        Arrays.sort(attributeNames);
        return attributeNames;
    }

    public Set<EORelationship> getClientClassRelationships() {
        LinkedHashSet<EORelationship> clientClassRelationships = new LinkedHashSet<EORelationship>();
        for (EORelationship relationship : this.getRelationships()) {
            if (relationship.isClientClassProperty() == null || !relationship.isClientClassProperty().booleanValue()) continue;
            clientClassRelationships.add(relationship);
        }
        return clientClassRelationships;
    }

    public Set<EORelationship> getSortedClientClassRelationships() {
        return new PropertyListSet<EORelationship>((Collection<EORelationship>)this.getClientClassRelationships());
    }

    public Set<EORelationship> getCommonClassRelationships() {
        LinkedHashSet<EORelationship> commonClassRelationships = new LinkedHashSet<EORelationship>();
        for (EORelationship relationship : this.getRelationships()) {
            if (relationship.isCommonClassProperty() == null || !relationship.isCommonClassProperty().booleanValue()) continue;
            commonClassRelationships.add(relationship);
        }
        return commonClassRelationships;
    }

    public Set<EORelationship> getSortedCommonClassRelationships() {
        return new PropertyListSet<EORelationship>((Collection<EORelationship>)this.getCommonClassRelationships());
    }

    public Set<EORelationship> getClassRelationships() {
        LinkedHashSet<EORelationship> classRelationships = new LinkedHashSet<EORelationship>();
        for (EORelationship relationship : this.getRelationships()) {
            if (relationship.isClassProperty() == null || !relationship.isClassProperty().booleanValue()) continue;
            classRelationships.add(relationship);
        }
        return classRelationships;
    }

    public Set<EORelationship> getSortedClassRelationships() {
        return new PropertyListSet<EORelationship>((Collection<EORelationship>)this.getClassRelationships());
    }

    public Set<EORelationship> getNonClassRelationships() {
        LinkedHashSet<EORelationship> nonClassRelationships = new LinkedHashSet<EORelationship>();
        for (EORelationship relationship : this.getRelationships()) {
            if (relationship.isClassProperty() != null && relationship.isClassProperty().booleanValue()) continue;
            nonClassRelationships.add(relationship);
        }
        return nonClassRelationships;
    }

    public Set<EORelationship> getInheritedRelationships() {
        LinkedHashSet<EORelationship> inheritedRelationships = new LinkedHashSet<EORelationship>();
        for (EORelationship relationship : this.getRelationships()) {
            if (!relationship.isInherited()) continue;
            inheritedRelationships.add(relationship);
        }
        return inheritedRelationships;
    }

    public Set<EORelationship> getToOneRelationships() {
        LinkedHashSet<EORelationship> toOneRelationships = new LinkedHashSet<EORelationship>();
        for (EORelationship relationship : this.getRelationships()) {
            if (relationship.isToOne() == null || !relationship.isToOne().booleanValue()) continue;
            toOneRelationships.add(relationship);
        }
        return toOneRelationships;
    }

    public Set<EORelationship> getSortedToOneRelationships() {
        return new PropertyListSet<EORelationship>((Collection<EORelationship>)this.getToOneRelationships());
    }

    public Set<EORelationship> getClassToOneRelationships() {
        LinkedHashSet<EORelationship> toOneRelationships = new LinkedHashSet<EORelationship>();
        for (EORelationship relationship : this.getRelationships()) {
            if (relationship.isToOne() == null || !relationship.isToOne().booleanValue() || relationship.isClassProperty() == null || !relationship.isClassProperty().booleanValue()) continue;
            toOneRelationships.add(relationship);
        }
        return toOneRelationships;
    }

    public Set<EORelationship> getSortedClassToOneRelationships() {
        return new PropertyListSet<EORelationship>((Collection<EORelationship>)this.getClassToOneRelationships());
    }

    public Set<EORelationship> getSortedClientClassToOneRelationships() {
        return new PropertyListSet<EORelationship>((Collection<EORelationship>)this.getClientClassToOneRelationships());
    }

    public Set<EORelationship> getClientClassToOneRelationships() {
        LinkedHashSet<EORelationship> toOneRelationships = new LinkedHashSet<EORelationship>();
        for (EORelationship relationship : this.getRelationships()) {
            if (relationship.isToOne() == null || !relationship.isToOne().booleanValue() || relationship.isClientClassProperty() == null || !relationship.isClientClassProperty().booleanValue()) continue;
            toOneRelationships.add(relationship);
        }
        return toOneRelationships;
    }

    public Set<EORelationship> getSortedCommonClassToOneRelationships() {
        return new PropertyListSet<EORelationship>((Collection<EORelationship>)this.getCommonClassToOneRelationships());
    }

    public Set<EORelationship> getCommonClassToOneRelationships() {
        LinkedHashSet<EORelationship> toOneRelationships = new LinkedHashSet<EORelationship>();
        for (EORelationship relationship : this.getRelationships()) {
            if (relationship.isToOne() == null || !relationship.isToOne().booleanValue() || relationship.isCommonClassProperty() == null || !relationship.isCommonClassProperty().booleanValue()) continue;
            toOneRelationships.add(relationship);
        }
        return toOneRelationships;
    }

    public Set<EORelationship> getToManyRelationships() {
        LinkedHashSet<EORelationship> toManyRelationships = new LinkedHashSet<EORelationship>();
        for (EORelationship relationship : this.getRelationships()) {
            if (relationship.isToMany() == null || !relationship.isToMany().booleanValue()) continue;
            toManyRelationships.add(relationship);
        }
        return toManyRelationships;
    }

    public Set<EORelationship> getSortedToManyRelationships() {
        return new PropertyListSet<EORelationship>((Collection<EORelationship>)this.getToManyRelationships());
    }

    public Set<EORelationship> getClassToManyRelationships() {
        LinkedHashSet<EORelationship> toManyRelationships = new LinkedHashSet<EORelationship>();
        for (EORelationship relationship : this.getRelationships()) {
            if (relationship.isToMany() == null || !relationship.isToMany().booleanValue() || relationship.isClassProperty() == null || !relationship.isClassProperty().booleanValue()) continue;
            toManyRelationships.add(relationship);
        }
        return toManyRelationships;
    }

    public Set<EORelationship> getSortedClassToManyRelationships() {
        return new PropertyListSet<EORelationship>((Collection<EORelationship>)this.getClassToManyRelationships());
    }

    public Set<EORelationship> getClientClassToManyRelationships() {
        LinkedHashSet<EORelationship> toManyRelationships = new LinkedHashSet<EORelationship>();
        for (EORelationship relationship : this.getRelationships()) {
            if (relationship.isToMany() == null || !relationship.isToMany().booleanValue() || relationship.isClientClassProperty() == null || !relationship.isClientClassProperty().booleanValue()) continue;
            toManyRelationships.add(relationship);
        }
        return toManyRelationships;
    }

    public Set<EORelationship> getSortedClientClassToManyRelationships() {
        return new PropertyListSet<EORelationship>((Collection<EORelationship>)this.getClientClassToManyRelationships());
    }

    public Set<EORelationship> getCommonClassToManyRelationships() {
        LinkedHashSet<EORelationship> toManyRelationships = new LinkedHashSet<EORelationship>();
        for (EORelationship relationship : this.getRelationships()) {
            if (relationship.isToMany() == null || !relationship.isToMany().booleanValue() || relationship.isCommonClassProperty() == null || !relationship.isCommonClassProperty().booleanValue()) continue;
            toManyRelationships.add(relationship);
        }
        return toManyRelationships;
    }

    public Set<EORelationship> getSortedCommonClassToManyRelationships() {
        return new PropertyListSet<EORelationship>((Collection<EORelationship>)this.getCommonClassToManyRelationships());
    }

    public Set<EORelationship> getRelationships() {
        return this.myRelationships;
    }

    public Set<EORelationship> getSortedRelationships() {
        return new PropertyListSet<EORelationship>((Collection<EORelationship>)this.myRelationships);
    }

    public Set<EOFetchSpecification> getFetchSpecs() {
        return this.myFetchSpecs;
    }

    public Set<EOFetchSpecification> getSortedFetchSpecs() {
        return new PropertyListSet<EOFetchSpecification>((Collection<EOFetchSpecification>)this.myFetchSpecs);
    }

    public Set<EOEntityIndex> getEntityIndexes() {
        return this.myEntityIndexes;
    }

    public Set<EOEntityIndex> getSortedEntityIndexes() {
        return new PropertyListSet<EOEntityIndex>((Collection<EOEntityIndex>)this.myEntityIndexes);
    }

    public String findUnusedAttributeName(String _newName) {
        return this._findUnusedName(_newName, "getAttributeOrRelationshipNamed");
    }

    public IEOAttribute getAttributeOrRelationshipNamed(String _name) {
        UserInfoableEOModelObject attribute = this.getAttributeNamed(_name);
        if (attribute == null) {
            attribute = this.getRelationshipNamed(_name);
        }
        return attribute;
    }

    public void _checkForDuplicateAttributeName(EOAttribute _attribute, String _newName, Set<EOModelVerificationFailure> _failures) throws DuplicateNameException {
        IEOAttribute existingAttribute = this.getAttributeOrRelationshipNamed(_newName);
        if (existingAttribute != null && existingAttribute != _attribute) {
            if (_failures == null) {
                throw new DuplicateAttributeNameException(_newName, this);
            }
            String unusedName = this.findUnusedAttributeName(_newName);
            existingAttribute.setName(unusedName, true);
            _failures.add(new DuplicateAttributeFailure(this, _newName, unusedName));
        }
    }

    public void addAttribute(EOAttribute _attribute) throws DuplicateNameException {
        this.addAttribute(_attribute, true, null);
    }

    public synchronized void addAttribute(EOAttribute _attribute, boolean _fireEvents, Set<EOModelVerificationFailure> _failures) throws DuplicateNameException {
        _attribute._setEntity(this);
        this._checkForDuplicateAttributeName(_attribute, _attribute.getName(), _failures);
        _attribute.pasted();
        Set<EOAttribute> oldAttributes = null;
        if (_fireEvents) {
            oldAttributes = this.myAttributes;
            LinkedHashSet<EOAttribute> newAttributes = new LinkedHashSet<EOAttribute>();
            newAttributes.addAll(this.myAttributes);
            newAttributes.add(_attribute);
            this.myAttributes = newAttributes;
            if (this.myModel != null) {
                this.myModel.getModelEvents().addEvent(new EOAttributeAddedEvent(_attribute));
            }
            this.firePropertyChange(ATTRIBUTES, oldAttributes, this.myAttributes);
        } else {
            this.myAttributes.add(_attribute);
        }
    }

    public void removeAttribute(EOAttribute _attribute, boolean _removeFromSubclasses) {
        String attributeName = _attribute.getName();
        Set<EOAttribute> oldAttributes = this.myAttributes;
        LinkedHashSet<EOAttribute> newAttributes = new LinkedHashSet<EOAttribute>();
        newAttributes.addAll(this.myAttributes);
        newAttributes.remove(_attribute);
        this.myAttributes = newAttributes;
        if (this.myModel != null) {
            this.myModel.getModelEvents().addEvent(new EOAttributeDeletedEvent(_attribute));
        }
        this.firePropertyChange(ATTRIBUTES, oldAttributes, newAttributes);
        if (_removeFromSubclasses) {
            for (EOEntity childEntity : this.getChildrenEntities()) {
                EOAttribute childAttribute = childEntity.getAttributeNamed(attributeName);
                if (childAttribute == null) continue;
                childEntity.removeAttribute(childAttribute, _removeFromSubclasses);
            }
        }
        _attribute._setEntity(null);
    }

    public EOAttribute getAttributeNamed(String _name) {
        EOAttribute matchingAttribute = null;
        Iterator<EOAttribute> attributesIter = this.myAttributes.iterator();
        while (matchingAttribute == null && attributesIter.hasNext()) {
            EOAttribute attribute = attributesIter.next();
            if (!ComparisonUtils.equals((Object)attribute.getName(), (Object)_name)) continue;
            matchingAttribute = attribute;
        }
        return matchingAttribute;
    }

    public String findUnusedRelationshipName(String _newName) {
        return this._findUnusedName(_newName, "getAttributeOrRelationshipNamed");
    }

    public void _checkForDuplicateRelationshipName(EORelationship _relationship, String _newName, Set<EOModelVerificationFailure> _failures) throws DuplicateNameException {
        IEOAttribute existingRelationship = this.getAttributeOrRelationshipNamed(_newName);
        if (existingRelationship != null && existingRelationship != _relationship) {
            if (_failures == null) {
                throw new DuplicateRelationshipNameException(_newName, this);
            }
            String unusedName = this.findUnusedRelationshipName(_newName);
            existingRelationship.setName(unusedName, true);
            _failures.add(new DuplicateRelationshipFailure(this, _newName, unusedName));
        }
    }

    protected void _attributeChanged(EOAttribute _attribute, String _propertyName, Object _oldValue, Object _newValue) {
        this.firePropertyChange(ATTRIBUTE, null, _attribute);
    }

    protected void _relationshipChanged(EORelationship _relationship, String _propertyName, Object _oldValue, Object _newValue) {
        this.firePropertyChange(RELATIONSHIP, null, _relationship);
    }

    protected void _fetchSpecificationChanged(EOFetchSpecification _fetchSpecification, String _propertyName, Object _oldValue, Object _newValue) {
        this.setFetchSpecsDirty(true);
        this.firePropertyChange(FETCH_SPECIFICATION, null, _fetchSpecification);
    }

    protected void _entityIndexChanged(EOEntityIndex _entityIndex, String _propertyName, Object _oldValue, Object _newValue) {
        this.firePropertyChange(ENTITY_INDEX, null, _entityIndex);
    }

    public void addRelationship(EORelationship relationship) throws DuplicateNameException {
        this.addRelationship(relationship, true, null, true);
    }

    public void addRelationship(EORelationship relationship, boolean pasteImmediately, Set<EOModelVerificationFailure> failures, boolean fireEvents) throws DuplicateNameException {
        relationship._setEntity(this);
        this._checkForDuplicateRelationshipName(relationship, relationship.getName(), failures);
        if (pasteImmediately) {
            relationship.pasted();
        }
        Set<EORelationship> oldRelationships = null;
        if (fireEvents) {
            oldRelationships = this.myRelationships;
            LinkedHashSet<EORelationship> newRelationships = new LinkedHashSet<EORelationship>();
            newRelationships.addAll(this.myRelationships);
            newRelationships.add(relationship);
            this.myRelationships = newRelationships;
            this.firePropertyChange(RELATIONSHIPS, oldRelationships, this.myRelationships);
        } else {
            this.myRelationships.add(relationship);
        }
    }

    public void removeRelationship(EORelationship _relationship, boolean _removeFromSubclasses) {
        String relationshipName = _relationship.getName();
        Set<EORelationship> oldRelationships = this.myRelationships;
        LinkedHashSet<EORelationship> newRelationships = new LinkedHashSet<EORelationship>();
        newRelationships.addAll(this.myRelationships);
        newRelationships.remove(_relationship);
        this.myRelationships = newRelationships;
        this.firePropertyChange(RELATIONSHIPS, oldRelationships, newRelationships);
        if (_removeFromSubclasses) {
            for (EOEntity childEntity : this.getChildrenEntities()) {
                EORelationship childRelationship = childEntity.getRelationshipNamed(relationshipName);
                if (childRelationship == null) continue;
                childEntity.removeRelationship(childRelationship, _removeFromSubclasses);
            }
        }
        _relationship._setEntity(null);
    }

    public EORelationship getRelationshipNamed(String _name) {
        EORelationship matchingRelationship = null;
        Iterator<EORelationship> relationshipsIter = this.myRelationships.iterator();
        while (matchingRelationship == null && relationshipsIter.hasNext()) {
            EORelationship relationship = relationshipsIter.next();
            if (!ComparisonUtils.equals((Object)relationship.getName(), (Object)_name)) continue;
            matchingRelationship = relationship;
        }
        return matchingRelationship;
    }

    public EOFetchSpecification getFetchSpecNamed(String _name) {
        EOFetchSpecification matchingFetchSpec = null;
        Iterator<EOFetchSpecification> fetchSpecsIter = this.myFetchSpecs.iterator();
        while (matchingFetchSpec == null && fetchSpecsIter.hasNext()) {
            EOFetchSpecification fetchSpec = fetchSpecsIter.next();
            if (!ComparisonUtils.equals((Object)fetchSpec.getName(), (Object)_name)) continue;
            matchingFetchSpec = fetchSpec;
        }
        return matchingFetchSpec;
    }

    public String findUnusedFetchSpecificationName(String _newName) {
        return this._findUnusedName(_newName, "getFetchSpecNamed");
    }

    public void _checkForDuplicateFetchSpecName(EOFetchSpecification _fetchSpec, String _newName, Set<EOModelVerificationFailure> _failures) throws DuplicateFetchSpecNameException {
        EOFetchSpecification existingFetchSpec = this.getFetchSpecNamed(_newName);
        if (existingFetchSpec != null && existingFetchSpec != _fetchSpec) {
            if (_failures == null) {
                throw new DuplicateFetchSpecNameException(_newName, this);
            }
            String unusedName = this.findUnusedFetchSpecificationName(_newName);
            existingFetchSpec.setName(unusedName, true);
            _failures.add(new DuplicateFetchSpecFailure(this, _newName, unusedName));
        }
    }

    public void addFetchSpecification(EOFetchSpecification _fetchSpecification) throws DuplicateFetchSpecNameException {
        this.addFetchSpecification(_fetchSpecification, true, null);
    }

    public void addFetchSpecification(EOFetchSpecification _fetchSpecification, boolean _fireEvents, Set<EOModelVerificationFailure> _failures) throws DuplicateFetchSpecNameException {
        _fetchSpecification._setEntity(this);
        this._checkForDuplicateFetchSpecName(_fetchSpecification, _fetchSpecification.getName(), _failures);
        Set<EOFetchSpecification> oldFetchSpecs = null;
        if (_fireEvents) {
            oldFetchSpecs = this.myFetchSpecs;
            LinkedHashSet<EOFetchSpecification> newFetchSpecs = new LinkedHashSet<EOFetchSpecification>();
            newFetchSpecs.addAll(this.myFetchSpecs);
            newFetchSpecs.add(_fetchSpecification);
            this.myFetchSpecs = newFetchSpecs;
            this.firePropertyChange(FETCH_SPECIFICATIONS, oldFetchSpecs, this.myFetchSpecs);
        } else {
            this.myFetchSpecs.add(_fetchSpecification);
        }
    }

    public void removeFetchSpecification(EOFetchSpecification _fetchSpecification) {
        Set<EOFetchSpecification> oldFetchSpecs = this.myFetchSpecs;
        LinkedHashSet<EOFetchSpecification> newFetchSpecs = new LinkedHashSet<EOFetchSpecification>();
        newFetchSpecs.addAll(this.myFetchSpecs);
        newFetchSpecs.remove(_fetchSpecification);
        this.myFetchSpecs = newFetchSpecs;
        this.firePropertyChange(FETCH_SPECIFICATIONS, oldFetchSpecs, newFetchSpecs);
    }

    public EOEntityIndex getEntityIndexNamed(String _name) {
        EOEntityIndex matchingEntityIndex = null;
        Iterator<EOEntityIndex> entityIndexesIter = this.myEntityIndexes.iterator();
        while (matchingEntityIndex == null && entityIndexesIter.hasNext()) {
            EOEntityIndex entityIndex = entityIndexesIter.next();
            if (!ComparisonUtils.equals((Object)entityIndex.getName(), (Object)_name)) continue;
            matchingEntityIndex = entityIndex;
        }
        return matchingEntityIndex;
    }

    public String findUnusedEntityIndexName(String _newName) {
        return this._findUnusedName(_newName, "getEntityIndexNamed");
    }

    public void _checkForDuplicateEntityIndexName(EOEntityIndex _entityIndex, String _newName, Set<EOModelVerificationFailure> _failures) throws DuplicateEntityIndexNameException {
        EOEntityIndex existingEntityIndex = this.getEntityIndexNamed(_newName);
        if (existingEntityIndex != null && existingEntityIndex != _entityIndex) {
            if (_failures == null) {
                throw new DuplicateEntityIndexNameException(_newName, this);
            }
            String unusedName = this.findUnusedEntityIndexName(_newName);
            existingEntityIndex.setName(unusedName, true);
            _failures.add(new DuplicateEntityIndexFailure(this, _newName, unusedName));
        }
    }

    public EOEntityIndex addEntityIndex(List<EOAttribute> attributes) throws DuplicateEntityIndexNameException {
        StringBuffer nameBuffer = new StringBuffer();
        for (EOAttribute attribute : attributes) {
            nameBuffer.append(attribute.getName());
            nameBuffer.append("_");
        }
        nameBuffer.append("idx");
        String name = nameBuffer.toString();
        EOEntityIndex entityIndex = this.addBlankEntityIndex(name);
        for (EOAttribute attribute : attributes) {
            entityIndex.addAttribute(attribute);
        }
        return entityIndex;
    }

    public EOEntityIndex addBlankEntityIndex(String _name) throws DuplicateEntityIndexNameException {
        String newEntityIndexName = this.findUnusedEntityIndexName(_name);
        EOEntityIndex entityIndex = new EOEntityIndex();
        entityIndex.setName(newEntityIndexName, false);
        this.addEntityIndex(entityIndex);
        return entityIndex;
    }

    public void addEntityIndex(EOEntityIndex _entityIndex) throws DuplicateEntityIndexNameException {
        this.addEntityIndex(_entityIndex, true, null);
    }

    public void addEntityIndex(EOEntityIndex _entityIndex, boolean _fireEvents, Set<EOModelVerificationFailure> _failures) throws DuplicateEntityIndexNameException {
        _entityIndex._setEntity(this);
        this._checkForDuplicateEntityIndexName(_entityIndex, _entityIndex.getName(), _failures);
        Set<EOEntityIndex> oldEntityIndexes = null;
        if (_fireEvents) {
            oldEntityIndexes = this.myEntityIndexes;
            LinkedHashSet<EOEntityIndex> newEntityIndexes = new LinkedHashSet<EOEntityIndex>();
            newEntityIndexes.addAll(this.myEntityIndexes);
            newEntityIndexes.add(_entityIndex);
            this.myEntityIndexes = newEntityIndexes;
            this.firePropertyChange(ENTITY_INDEXES, oldEntityIndexes, this.myEntityIndexes);
        } else {
            this.myEntityIndexes.add(_entityIndex);
        }
    }

    public void removeEntityIndex(EOEntityIndex _entityIndex) {
        Set<EOEntityIndex> oldEntityIndexes = this.myEntityIndexes;
        LinkedHashSet<EOEntityIndex> newEntityIndexes = new LinkedHashSet<EOEntityIndex>();
        newEntityIndexes.addAll(this.myEntityIndexes);
        newEntityIndexes.remove(_entityIndex);
        this.myEntityIndexes = newEntityIndexes;
        this.firePropertyChange(ENTITY_INDEXES, oldEntityIndexes, newEntityIndexes);
    }

    public void setDeleteProcedure(EOStoredProcedure _deleteProcedure) {
        EOStoredProcedure oldDeleteProcedure = this.myDeleteProcedure;
        this.myDeleteProcedure = _deleteProcedure;
        this.firePropertyChange(DELETE_PROCEDURE, oldDeleteProcedure, this.myDeleteProcedure);
    }

    public EOStoredProcedure getDeleteProcedure() {
        return this.myDeleteProcedure;
    }

    public void setFetchAllProcedure(EOStoredProcedure _fetchAllProcedure) {
        EOStoredProcedure oldFetchAllProcedure = this.myFetchAllProcedure;
        this.myFetchAllProcedure = _fetchAllProcedure;
        this.firePropertyChange(FETCH_ALL_PROCEDURE, oldFetchAllProcedure, this.myFetchAllProcedure);
    }

    public EOStoredProcedure getFetchAllProcedure() {
        return this.myFetchAllProcedure;
    }

    public void setFetchWithPrimaryKeyProcedure(EOStoredProcedure _fetchWithPrimaryKeyProcedure) {
        EOStoredProcedure oldFetchWithPrimaryKeyProcedure = this.myFetchWithPrimaryKeyProcedure;
        this.myFetchWithPrimaryKeyProcedure = _fetchWithPrimaryKeyProcedure;
        this.firePropertyChange(FETCH_WITH_PRIMARY_KEY_PROCEDURE, oldFetchWithPrimaryKeyProcedure, this.myFetchWithPrimaryKeyProcedure);
    }

    public EOStoredProcedure getFetchWithPrimaryKeyProcedure() {
        return this.myFetchWithPrimaryKeyProcedure;
    }

    public void setInsertProcedure(EOStoredProcedure _insertProcedure) {
        EOStoredProcedure oldInsertProcedure = this.myInsertProcedure;
        this.myInsertProcedure = _insertProcedure;
        this.firePropertyChange(INSERT_PROCEDURE, oldInsertProcedure, this.myInsertProcedure);
    }

    public EOStoredProcedure getInsertProcedure() {
        return this.myInsertProcedure;
    }

    public void setNextPrimaryKeyProcedure(EOStoredProcedure _nextPrimaryKeyProcedure) {
        EOStoredProcedure oldNextPrimaryKeyProcedure = this.myNextPrimaryKeyProcedure;
        this.myNextPrimaryKeyProcedure = _nextPrimaryKeyProcedure;
        this.firePropertyChange(NEXT_PRIMARY_KEY_PROCEDURE, oldNextPrimaryKeyProcedure, this.myNextPrimaryKeyProcedure);
    }

    public EOStoredProcedure getNextPrimaryKeyProcedure() {
        return this.myNextPrimaryKeyProcedure;
    }

    public void loadFromMap(EOModelMap _entityMap, Set<EOModelVerificationFailure> _failures) throws DuplicateNameException {
        Set attributesUsedForLocking;
        Set entityIndexesList;
        Set relationshipList;
        this.myEntityMap = _entityMap;
        this.myOriginalName = this.myName = _entityMap.getString(NAME, true);
        this.myExternalName = _entityMap.getString(EXTERNAL_NAME, true);
        this.myClassName = _entityMap.getString(CLASS_NAME, true);
        Map internalInfo = this.myEntityMap.getMap("internalInfo");
        if (internalInfo != null) {
            EOModelMap internalInfoModelMap = new EOModelMap(internalInfo);
            this.myClientClassName = internalInfoModelMap.getString("_javaClientClassName", true);
        }
        this.myCachesObjects = _entityMap.getBoolean(CACHES_OBJECTS);
        this.myAbstractEntity = _entityMap.containsKey("isFetchable") ? Boolean.valueOf(_entityMap.getBoolean("isFetchable") == false) : _entityMap.getBoolean("isAbstractEntity");
        this.myReadOnly = _entityMap.getBoolean("isReadOnly");
        this.myImmutable = _entityMap.getBoolean("isImmutable");
        this.myRawRowsOnly = _entityMap.getBoolean("isRawRowsOnly");
        this.myRestrictingQualifier = _entityMap.containsKey("mappingQualifier") ? _entityMap.getString("mappingQualifier", true) : _entityMap.getString(RESTRICTING_QUALIFIER, true);
        this.myExternalQuery = _entityMap.getString(EXTERNAL_QUERY, true);
        this.myMaxNumberOfInstancesToBatchFetch = _entityMap.getInteger(MAX_NUMBER_OF_INSTANCES_TO_BATCH_FETCH);
        this._cardinality = _entityMap.getString("cardinality", true);
        this.loadUserInfo(_entityMap);
        Set attributeList = _entityMap.getSet(ATTRIBUTES);
        if (attributeList != null) {
            Iterator attributeIter = attributeList.iterator();
            while (attributeIter.hasNext()) {
                EOModelMap attributeMap = new EOModelMap((Map)attributeIter.next());
                EOAttribute attribute = new EOAttribute();
                attribute.loadFromMap(attributeMap, _failures);
                this.addAttribute(attribute, false, _failures);
            }
        }
        if ((relationshipList = _entityMap.getSet(RELATIONSHIPS)) != null) {
            Iterator relationshipIter = relationshipList.iterator();
            while (relationshipIter.hasNext()) {
                EOModelMap relationshipMap = new EOModelMap((Map)relationshipIter.next());
                EORelationship relationship = new EORelationship();
                relationship.loadFromMap(relationshipMap, _failures);
                this.addRelationship(relationship, true, _failures, false);
            }
        }
        if ((entityIndexesList = _entityMap.getSet(ENTITY_INDEXES)) != null) {
            Iterator entityIndexIter = entityIndexesList.iterator();
            while (entityIndexIter.hasNext()) {
                EOModelMap entityIndexMap = new EOModelMap((Map)entityIndexIter.next());
                EOEntityIndex entityIndex = new EOEntityIndex();
                entityIndex.loadFromMap(entityIndexMap, _failures);
                this.addEntityIndex(entityIndex, true, _failures);
            }
        }
        if ((attributesUsedForLocking = _entityMap.getSet("attributesUsedForLocking")) != null) {
            for (String attributeName : attributesUsedForLocking) {
                EOAttribute attribute = this.getAttributeNamed(attributeName);
                if (attribute == null) continue;
                attribute.setUsedForLocking(Boolean.TRUE, false);
            }
        }
    }

    public void loadFetchSpecsFromMap(EOModelMap _map, Set<EOModelVerificationFailure> _failures) throws EOModelException {
        Map fetchSpecificationsDictionary;
        this.myFetchSpecsMap = _map;
        Set sharedObjectFetchSpecificationNames = this.myEntityMap.getSet("sharedObjectFetchSpecificationNames");
        if (_map != null && !_map.isEmpty()) {
            Set fetchSpecEntries = _map.entrySet();
            for (Map.Entry entry : fetchSpecEntries) {
                this._addFetchSpecificationFromMap(entry, _failures, sharedObjectFetchSpecificationNames);
            }
        }
        if ((fetchSpecificationsDictionary = this.myEntityMap.getMap("fetchSpecificationDictionary")) != null && !fetchSpecificationsDictionary.isEmpty()) {
            for (Map.Entry entry : fetchSpecificationsDictionary.entrySet()) {
                this._addFetchSpecificationFromMap(entry, _failures, sharedObjectFetchSpecificationNames);
            }
        }
    }

    protected void _addFetchSpecificationFromMap(Map.Entry<Object, Map> _fetchSpecEntry, Set<EOModelVerificationFailure> _failures, Set<String> _sharedObjectFetchSpecificationNames) throws EOModelException {
        String fetchSpecName = _fetchSpecEntry.getKey().toString();
        EOModelMap fetchSpecMap = new EOModelMap(_fetchSpecEntry.getValue());
        EOFetchSpecification fetchSpec = new EOFetchSpecification(fetchSpecName);
        fetchSpec.loadFromMap(fetchSpecMap, _failures);
        if (_sharedObjectFetchSpecificationNames != null && _sharedObjectFetchSpecificationNames.contains(fetchSpecName)) {
            fetchSpec.setSharesObjects(Boolean.TRUE, false);
        }
        this.addFetchSpecification(fetchSpec, false, _failures);
    }

    /*
     * WARNING - void declaration
     */
    public EOModelMap toEntityMap() {
        void var11_23;
        EOModelMap entityMap = this.myEntityMap.cloneModelMap();
        entityMap.setString(NAME, this.myName, true);
        entityMap.setString(EXTERNAL_NAME, this.myExternalName, true);
        entityMap.setString(CLASS_NAME, this.myClassName, true);
        if (this.myParent != null) {
            entityMap.setString(PARENT, this.myParent.getName(), true);
        } else {
            entityMap.remove(PARENT);
        }
        entityMap.setBoolean(CACHES_OBJECTS, this.myCachesObjects, 3);
        entityMap.setBoolean("isAbstractEntity", this.myAbstractEntity, 3);
        entityMap.remove("isFetchable");
        entityMap.setBoolean("isReadOnly", this.myReadOnly, 3);
        entityMap.setBoolean("isImmutable", this.myImmutable, 3);
        entityMap.setBoolean("isRawRowsOnly", this.myRawRowsOnly, 3);
        entityMap.setString(RESTRICTING_QUALIFIER, this.myRestrictingQualifier, true);
        entityMap.remove("mappingQualifier");
        entityMap.setString(EXTERNAL_QUERY, this.myExternalQuery, true);
        entityMap.setInteger(MAX_NUMBER_OF_INSTANCES_TO_BATCH_FETCH, this.myMaxNumberOfInstancesToBatchFetch);
        entityMap.setString("cardinality", this._cardinality, true);
        if (this.myFetchSpecs == null || this.myFetchSpecs.size() == 0) {
            entityMap.put("fetchSpecificationDictionary", new HashMap());
        } else {
            entityMap.remove("fetchSpecificationDictionary");
        }
        PropertyListSet classProperties = new PropertyListSet(EOModelMap.asArray(this.myEntityMap.get("classProperties")));
        PropertyListSet primaryKeyAttributes = new PropertyListSet(EOModelMap.asArray(this.myEntityMap.get("primaryKeyAttributes")));
        PropertyListSet attributesUsedForLocking = new PropertyListSet(EOModelMap.asArray(this.myEntityMap.get("attributesUsedForLocking")));
        Map oldInternalInfo = this.myEntityMap.getMap("internalInfo");
        PropertyListSet clientClassProperties = new PropertyListSet(oldInternalInfo != null ? EOModelMap.asArray(oldInternalInfo.get("_clientClassPropertyNames")) : null);
        PropertyListSet attributes = new PropertyListSet(EOModelMap.asArray(this.myEntityMap.get(ATTRIBUTES)));
        for (EOAttribute eOAttribute : this.myAttributes) {
            EOModelMap eOModelMap = eOAttribute.toMap();
            attributes.add(eOModelMap);
            if (BooleanUtils.isTrue(eOAttribute.isClassProperty())) {
                classProperties.add(eOAttribute.getName());
            }
            if (BooleanUtils.isTrue(eOAttribute.isPrimaryKey())) {
                primaryKeyAttributes.add(eOAttribute.getName());
            }
            if (BooleanUtils.isTrue(eOAttribute.isUsedForLocking())) {
                attributesUsedForLocking.add(eOAttribute.getName());
            }
            if (!BooleanUtils.isTrue(eOAttribute.isClientClassProperty())) continue;
            clientClassProperties.add(eOAttribute.getName());
        }
        entityMap.setSet(ATTRIBUTES, attributes, true);
        PropertyListSet relationships = new PropertyListSet(EOModelMap.asArray(this.myEntityMap.get(RELATIONSHIPS)));
        for (EORelationship eORelationship : this.myRelationships) {
            EOModelMap eOModelMap = eORelationship.toMap();
            relationships.add(eOModelMap);
            if (BooleanUtils.isTrue(eORelationship.isClassProperty())) {
                classProperties.add(eORelationship.getName());
            }
            if (!BooleanUtils.isTrue(eORelationship.isClientClassProperty())) continue;
            clientClassProperties.add(eORelationship.getName());
        }
        entityMap.setSet(RELATIONSHIPS, relationships, true);
        PropertyListSet propertyListSet = new PropertyListSet(EOModelMap.asArray(this.myEntityMap.get(ENTITY_INDEXES)));
        for (EOEntityIndex eOEntityIndex : this.myEntityIndexes) {
            EOModelMap entityIndexMap = eOEntityIndex.toMap();
            propertyListSet.add(entityIndexMap);
        }
        entityMap.setSet(ENTITY_INDEXES, propertyListSet, true);
        entityMap.setSet("attributesUsedForLocking", attributesUsedForLocking, true);
        entityMap.setSet("classProperties", classProperties, true);
        entityMap.setSet("primaryKeyAttributes", primaryKeyAttributes, true);
        PropertyListSet propertyListSet2 = new PropertyListSet(EOModelMap.asArray(this.myEntityMap.get("sharedObjectFetchSpecificationNames")));
        for (EOFetchSpecification fetchSpec : this.myFetchSpecs) {
            if (!BooleanUtils.isTrue(fetchSpec.isSharesObjects())) continue;
            propertyListSet2.add(fetchSpec.getName());
        }
        entityMap.setSet("sharedObjectFetchSpecificationNames", propertyListSet2, true);
        Map map = entityMap.getMap("internalInfo");
        if (map == null) {
            HashMap hashMap = new HashMap();
        }
        if (!clientClassProperties.isEmpty()) {
            var11_23.put("_clientClassPropertyNames", clientClassProperties);
        } else {
            var11_23.remove("_clientClassPropertyNames");
        }
        if (this.myClientClassName != null && this.myClientClassName.length() > 0) {
            var11_23.put("_javaClientClassName", this.myClientClassName);
        } else {
            var11_23.remove("_javaClientClassName");
        }
        if (!var11_23.isEmpty()) {
            entityMap.setMap("internalInfo", (Map)var11_23, false);
        } else {
            entityMap.remove("internalInfo");
        }
        HashMap<String, String> storedProcedureNames = this.myEntityMap.getMap("storedProcedureNames");
        if (storedProcedureNames == null) {
            storedProcedureNames = new HashMap<String, String>();
        }
        if (this.myDeleteProcedure == null) {
            storedProcedureNames.remove(EODELETE_PROCEDURE);
        } else {
            storedProcedureNames.put(EODELETE_PROCEDURE, this.myDeleteProcedure.getName());
        }
        if (this.myInsertProcedure == null) {
            storedProcedureNames.remove(EOINSERT_PROCEDURE);
        } else {
            storedProcedureNames.put(EOINSERT_PROCEDURE, this.myInsertProcedure.getName());
        }
        if (this.myFetchAllProcedure == null) {
            storedProcedureNames.remove(EOFETCH_ALL_PROCEDURE);
        } else {
            storedProcedureNames.put(EOFETCH_ALL_PROCEDURE, this.myFetchAllProcedure.getName());
        }
        if (this.myFetchWithPrimaryKeyProcedure == null) {
            storedProcedureNames.remove(EOFETCH_WITH_PRIMARY_KEY_PROCEDURE);
        } else {
            storedProcedureNames.put(EOFETCH_WITH_PRIMARY_KEY_PROCEDURE, this.myFetchWithPrimaryKeyProcedure.getName());
        }
        if (this.myNextPrimaryKeyProcedure == null) {
            storedProcedureNames.remove(EONEXT_PRIMARY_KEY_PROCEDURE);
        } else {
            storedProcedureNames.put(EONEXT_PRIMARY_KEY_PROCEDURE, this.myNextPrimaryKeyProcedure.getName());
        }
        EOModelMap entityModelerMap = this.getEntityModelerMap(true);
        if (this.myPartialEntity == null) {
            entityModelerMap.remove(PARTIAL_ENTITY);
        } else {
            entityModelerMap.put(PARTIAL_ENTITY, this.myPartialEntity.getName());
        }
        if (this.myParentClassName == null) {
            entityModelerMap.remove(PARENT_CLASS_NAME);
        } else {
            entityModelerMap.put(PARENT_CLASS_NAME, this.myParentClassName);
        }
        if (this.myGenerateSource) {
            entityModelerMap.remove(GENERATE_SOURCE);
        } else {
            entityModelerMap.setBoolean(GENERATE_SOURCE, Boolean.FALSE, 1);
        }
        this.writeUserInfo(entityMap);
        return entityMap;
    }

    public EOModelMap toFetchSpecsMap() {
        EOModelMap fetchSpecsMap = this.myFetchSpecsMap.cloneModelMap();
        fetchSpecsMap.clear();
        for (EOFetchSpecification fetchSpec : this.myFetchSpecs) {
            EOModelMap fetchSpecMap = fetchSpec.toMap();
            fetchSpecsMap.setMap(fetchSpec.getName(), fetchSpecMap, true);
        }
        return fetchSpecsMap;
    }

    public void checkLastModified(Set<EOLastModified> lastModified) {
        if (this._lastModified != null && this._lastModified.hasBeenModified()) {
            lastModified.add(this._lastModified);
        }
        if (this._fspecLastModified != null && this._fspecLastModified.hasBeenModified()) {
            lastModified.add(this._fspecLastModified);
        }
    }

    public void loadFromURL(URL entityURL, Set<EOModelVerificationFailure> failures) throws EOModelException {
        try {
            EOModelMap entityMap = new EOModelMap((Map)WOLPropertyListSerialization.propertyListFromURL((URL)entityURL, (ParserDataStructureFactory)new EOModelParserDataStructureFactory()));
            this.loadFromMap(entityMap, failures);
            this.setEntityDirty(false);
            this._lastModified = new EOLastModified(entityURL);
        }
        catch (Throwable e) {
            throw new EOModelException("Failed to load entity from '" + entityURL.getFile() + "'.", e);
        }
    }

    public void loadFetchSpecsFromURL(URL fetchSpecURL, Set<EOModelVerificationFailure> failures) throws EOModelException {
        try {
            EOModelMap fspecMap = new EOModelMap((Map)WOLPropertyListSerialization.propertyListFromURL((URL)fetchSpecURL, (ParserDataStructureFactory)new EOModelParserDataStructureFactory()));
            this.loadFetchSpecsFromMap(fspecMap, failures);
            this.setFetchSpecsDirty(false);
            this._fspecLastModified = new EOLastModified(fetchSpecURL);
        }
        catch (Throwable e) {
            throw new EOModelException("Failed to load fetch specifications from '" + fetchSpecURL.getFile() + "'.", e);
        }
    }

    public void saveToFile(File entityFile, File fetchSpecsFile) throws PropertyListParserException, IOException {
        EOModelMap entityMap = this.toEntityMap();
        WOLPropertyListSerialization.propertyListToFile((String)"Entity Modeler v1.0.1", (File)entityFile, (Object)entityMap);
        if (this.myFetchSpecs.size() == 0) {
            fetchSpecsFile.delete();
        } else if (this.getEntity().isFetchSpecsDirty()) {
            EOModelMap fetchSpecMap = this.toFetchSpecsMap();
            WOLPropertyListSerialization.propertyListToFile((String)"Entity Modeler v1.0.1", (File)fetchSpecsFile, (Object)fetchSpecMap);
        }
        this.myOriginalName = this.myName;
        this.setEntityDirty(false);
        this._lastModified = new EOLastModified(entityFile);
        this._fspecLastModified = new EOLastModified(fetchSpecsFile);
    }

    public void resolveFlattened(Set<EOModelVerificationFailure> _failures) {
        for (EOAttribute attribute : this.myAttributes) {
            if (!attribute.isFlattened()) continue;
            attribute.resolve(_failures);
        }
        for (EORelationship relationship : this.myRelationships) {
            if (!relationship.isFlattened()) continue;
            relationship.resolve(_failures);
        }
    }

    public void resolve(Set<EOModelVerificationFailure> _failures) {
        Map storedProcedureNames;
        Map internalInfo;
        Set set;
        Boolean generateSource;
        String parentClassName;
        EOModelMap entityModelerMap;
        String partialEntityName;
        String parentName = this.myEntityMap.getString(PARENT, true);
        if (parentName != null) {
            if (this.myModel != null) {
                this.myParent = this.myModel.getModelGroup().getEntityNamed(parentName);
            }
            if (this.myParent == null) {
                _failures.add(new MissingEntityFailure(this.myModel, parentName));
            }
        }
        if ((partialEntityName = (entityModelerMap = this.getEntityModelerMap(false)).getString(PARTIAL_ENTITY, true)) != null) {
            if (this.myModel != null) {
                this.myPartialEntity = this.myModel.getModelGroup().getEntityNamed(partialEntityName);
            }
            if (this.myPartialEntity == null) {
                _failures.add(new MissingEntityFailure(this.myModel, partialEntityName));
            }
        }
        if ((parentClassName = entityModelerMap.getString(PARENT_CLASS_NAME, true)) != null) {
            this.myParentClassName = parentClassName;
        }
        this.myGenerateSource = (generateSource = entityModelerMap.getBoolean(GENERATE_SOURCE)) == null ? true : generateSource;
        for (EOAttribute eOAttribute : this.myAttributes) {
            eOAttribute.resolve(_failures);
        }
        for (EORelationship eORelationship : this.myRelationships) {
            eORelationship.resolve(_failures);
        }
        for (EOFetchSpecification eOFetchSpecification : this.myFetchSpecs) {
            eOFetchSpecification.resolve(_failures);
        }
        for (EOEntityIndex eOEntityIndex : this.myEntityIndexes) {
            eOEntityIndex.resolve(_failures);
        }
        Set classProperties = this.myEntityMap.getSet("classProperties");
        if (classProperties != null) {
            for (Object attributeName : classProperties) {
                IEOAttribute attribute = this.getAttributeOrRelationshipNamed((String)attributeName);
                if (attribute == null) continue;
                attribute.setClassProperty(Boolean.TRUE, false);
            }
        }
        if ((set = this.myEntityMap.getSet("primaryKeyAttributes")) != null) {
            for (String attributeName : set) {
                EOAttribute attribute = this.getAttributeNamed(attributeName);
                if (attribute == null) continue;
                attribute.setPrimaryKey(Boolean.TRUE, false);
            }
        }
        if ((internalInfo = this.myEntityMap.getMap("internalInfo")) != null) {
            Set commonClassPropertyNames;
            EOModelMap internalInfoModelMap = new EOModelMap(internalInfo);
            Set clientClassPropertyNames = internalInfoModelMap.getSet("_clientClassPropertyNames");
            if (clientClassPropertyNames != null) {
                for (Object attributeName : clientClassPropertyNames) {
                    IEOAttribute attribute = this.getAttributeOrRelationshipNamed((String)attributeName);
                    if (attribute == null) continue;
                    attribute.setClientClassProperty(Boolean.TRUE, false);
                }
            }
            if ((commonClassPropertyNames = internalInfoModelMap.getSet("_commonClassPropertyNames")) != null) {
                for (String attributeName : commonClassPropertyNames) {
                    IEOAttribute attribute = this.getAttributeOrRelationshipNamed(attributeName);
                    if (attribute == null) continue;
                    attribute.setCommonClassProperty(Boolean.TRUE, false);
                }
            }
        }
        if ((storedProcedureNames = this.myEntityMap.getMap("storedProcedureNames")) != null) {
            String nextPrimaryKeyProcedureName;
            String insertProcedureName;
            String fetchWithPrimaryKeyProcedureName;
            String fetchAllProcedureName;
            String deleteProcedureName = (String)storedProcedureNames.get(EODELETE_PROCEDURE);
            if (deleteProcedureName != null) {
                this.myDeleteProcedure = this.myModel.getStoredProcedureNamed(deleteProcedureName);
                if (this.myDeleteProcedure == null) {
                    _failures.add(new EOModelVerificationFailure(this.myModel, this, "The entity " + this.getName() + "'s delete procedure '" + deleteProcedureName + "' is missing.", false));
                }
            }
            if ((fetchAllProcedureName = (String)storedProcedureNames.get(EOFETCH_ALL_PROCEDURE)) != null) {
                this.myFetchAllProcedure = this.myModel.getStoredProcedureNamed(fetchAllProcedureName);
                if (this.myFetchAllProcedure == null) {
                    _failures.add(new EOModelVerificationFailure(this.myModel, this, "The entity " + this.getName() + "'s fetch all procedure '" + fetchAllProcedureName + "' is missing.", false));
                }
            }
            if ((fetchWithPrimaryKeyProcedureName = (String)storedProcedureNames.get(EOFETCH_WITH_PRIMARY_KEY_PROCEDURE)) != null) {
                this.myFetchWithPrimaryKeyProcedure = this.myModel.getStoredProcedureNamed(fetchWithPrimaryKeyProcedureName);
                if (this.myFetchWithPrimaryKeyProcedure == null) {
                    _failures.add(new EOModelVerificationFailure(this.myModel, this, "The entity " + this.getName() + "'s fetch with primary key procedure '" + fetchWithPrimaryKeyProcedureName + "' is missing.", false));
                }
            }
            if ((insertProcedureName = (String)storedProcedureNames.get(EOINSERT_PROCEDURE)) != null) {
                this.myInsertProcedure = this.myModel.getStoredProcedureNamed(insertProcedureName);
                if (this.myInsertProcedure == null) {
                    _failures.add(new EOModelVerificationFailure(this.myModel, this, "The entity " + this.getName() + "'s insert procedure '" + insertProcedureName + "' is missing.", false));
                }
            }
            if ((nextPrimaryKeyProcedureName = (String)storedProcedureNames.get(EONEXT_PRIMARY_KEY_PROCEDURE)) != null) {
                this.myNextPrimaryKeyProcedure = this.myModel.getStoredProcedureNamed(nextPrimaryKeyProcedureName);
                if (this.myNextPrimaryKeyProcedure == null) {
                    _failures.add(new EOModelVerificationFailure(this.myModel, this, "The entity " + this.getName() + "'s next primary key procedure '" + nextPrimaryKeyProcedureName + "' is missing.", false));
                }
            }
        }
    }

    public void verify(Set<EOModelVerificationFailure> failures, VerificationContext verificationContext) {
        EOEntity parent;
        String name = this.getName();
        if (name == null || name.trim().length() == 0) {
            failures.add(new EOModelVerificationFailure(this.myModel, this, "The entity " + this.getName() + " has an empty name.", false));
        } else {
            if (name.indexOf(32) != -1) {
                failures.add(new EOModelVerificationFailure(this.myModel, this, "The entity " + this.getName() + "'s name has a space in it.", false));
            }
            if (!StringUtils.isUppercaseFirstLetter((String)this.myName)) {
                failures.add(new EOModelVerificationFailure(this.myModel, this, "Entity names should be capitalized, but " + this.getName() + " is not.", true));
            }
        }
        for (EOAttribute attribute : this.myAttributes) {
            attribute.verify(failures, verificationContext);
        }
        for (EORelationship relationship : this.myRelationships) {
            relationship.verify(failures);
        }
        for (EOFetchSpecification fetchSpec : this.myFetchSpecs) {
            fetchSpec.verify(failures);
        }
        for (EOEntityIndex entityIndex : this.myEntityIndexes) {
            entityIndex.verify(failures);
        }
        if (!this.isPrototype()) {
            String externalName = this.getExternalName();
            if (externalName == null || externalName.trim().length() == 0) {
                if (!BooleanUtils.isTrue(this.isAbstractEntity())) {
                    failures.add(new EOModelVerificationFailure(this.myModel, this, "The entity " + this.getName() + " has an empty table name.", false));
                }
            } else if (externalName.indexOf(32) != -1 && !externalName.startsWith("[") && !externalName.endsWith("]")) {
                failures.add(new EOModelVerificationFailure(this.myModel, this, "The entity " + this.getName() + "'s table name '" + externalName + "' has a space in it.", false));
            }
        }
        if ((parent = this.getParent()) != null && !BooleanUtils.isTrue(parent.isAbstractEntity()) && this.getRestrictingQualifier() == null && ComparisonUtils.equals((Object)parent.getExternalName(), (Object)this.getExternalName())) {
            failures.add(new EOModelVerificationFailure(this.myModel, this, "The entity " + this.getName() + " is a subclass of " + this.getParent().getName() + " but does not have a restricting qualifier.", false));
        }
        try {
            this.inheritParentAttributesAndRelationships(failures, false);
        }
        catch (DuplicateNameException e) {
            failures.add(new EOModelVerificationFailure(this.myModel, "Failed to fix inherited attributes and relationships for " + this.getName() + ".", true));
        }
        Set<EOAttribute> primaryKeyAttributes = this.getPrimaryKeyAttributes();
        if (primaryKeyAttributes.isEmpty() && !this.isPartialEntitySet() && BooleanUtils.isFalse(this.isRawRowsOnly())) {
            failures.add(new EOModelVerificationFailure(this.myModel, this, "The entity " + this.getName() + " does not have a primary key.", false));
        }
        if (this.isPartialEntitySet() && this.getPartialEntity().isPartialEntitySet()) {
            failures.add(new EOModelVerificationFailure(this.myModel, this, "The entity " + this.getName() + " is a partial of an entity that is itself a partial. This is not currently allowed.", false));
        }
        if (this._lastModified == null && this.getClassName() != null && this.getPackageName() == null && !this.isGenericRecord()) {
            failures.add(new EOModelVerificationFailure(this.myModel, this, "The class '" + this.getClassName() + "' for the entity " + this.getName() + " doesn't have a package name.", true));
        }
    }

    @Override
    public String getFullyQualifiedName() {
        return (this.myModel == null ? "?" : this.myModel.getFullyQualifiedName()) + "/" + this.myName;
    }

    protected EOEntity _cloneJustEntity() {
        EOEntity entity = new EOEntity(this.myName);
        entity.myParent = this.myParent;
        entity.myPartialEntity = this.myPartialEntity;
        entity.myExternalName = this.myExternalName;
        entity.myClassName = this.myClassName;
        entity.myClientClassName = this.myClientClassName;
        entity.myRestrictingQualifier = this.myRestrictingQualifier;
        entity.myExternalQuery = this.myExternalQuery;
        entity.myCachesObjects = this.myCachesObjects;
        entity.myAbstractEntity = this.myAbstractEntity;
        entity.myReadOnly = this.myReadOnly;
        entity.myImmutable = this.myImmutable;
        entity.myRawRowsOnly = this.myRawRowsOnly;
        entity.myMaxNumberOfInstancesToBatchFetch = this.myMaxNumberOfInstancesToBatchFetch;
        entity.myGenerateSource = this.myGenerateSource;
        return entity;
    }

    public EOEntity _cloneModelObject() {
        try {
            EOEntity entity = this._cloneJustEntity();
            entity._cloneAttributesAndRelationshipsFrom(this, false, null, false);
            entity._cloneFetchSpecificationsFrom(this, false);
            entity._cloneEntityIndexesFrom(this, false);
            this._cloneUserInfoInto(entity);
            return entity;
        }
        catch (DuplicateNameException e) {
            throw new RuntimeException("A duplicate name was found during a clone, which should never happen.", e);
        }
    }

    @Override
    public Class<EOModel> _getModelParentType() {
        return EOModel.class;
    }

    @Override
    public EOModel _getModelParent() {
        return this.getModel();
    }

    @Override
    public void _removeFromModelParent(Set<EOModelVerificationFailure> failures) {
        this.getModel().removeEntity(this);
    }

    public void synchronizeNameChange(String oldName, String newName) {
        EOModel model;
        boolean reverseEngineered = false;
        String externalName = this.getExternalName();
        if (externalName == null) {
            externalName = newName;
        }
        if ((model = this.getModel()) != null) {
            reverseEngineered = model.isReverseEngineered();
            externalName = model.getEntityNamingConvention().format(oldName, newName, this.getExternalName());
        }
        if (!reverseEngineered) {
            this.setExternalName(externalName);
        }
        this.setClassName(NamingConvention.newClassName(oldName, newName, this.getClassName()));
        this.setClientClassName(NamingConvention.newClassName(oldName, newName, this.getClientClassName()));
    }

    @Override
    public void _addToModelParent(EOModel modelParent, boolean findUniqueName, Set<EOModelVerificationFailure> failures) throws EOModelException {
        if (findUniqueName) {
            String oldName = this.getName();
            String newName = modelParent.findUnusedEntityName(this.getName());
            this.setName(newName);
            modelParent.addEntity(this);
            this.synchronizeNameChange(oldName, newName);
        } else {
            modelParent.addEntity(this);
        }
    }

    public boolean getSqlGenerationCreateInheritedProperties() {
        return this.isHorizontalInheritance();
    }

    public String getSqlGenerationPrimaryKeyColumnNames() {
        StringBuffer sb = new StringBuffer();
        Iterator<EOAttribute> attributesIter = this.getPrimaryKeyAttributes().iterator();
        while (attributesIter.hasNext()) {
            EOAttribute attribute = attributesIter.next();
            sb.append("\"" + attribute.getColumnName() + "\"");
            if (!attributesIter.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public String toString() {
        return "[EOEntity: name = " + this.myName + "; attributes = " + this.myAttributes + "; relationships = " + this.myRelationships + "; fetchSpecs = " + this.myFetchSpecs + "]";
    }

    public static void main(String[] args) {
        System.out.println("EOEntity.main: " + NamingConvention.DEFAULT.format("NewEntity"));
    }

    @Override
    public int compareTo(EOEntity otherEntity) {
        return this.myName.compareTo(otherEntity.getName());
    }
}

