/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.objectstyle.wolips.baseforplugins.util.StringUtils;
import org.objectstyle.wolips.eomodeler.core.model.EOArgument;
import org.objectstyle.wolips.eomodeler.core.model.EODatabaseConfig;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelObject;
import org.objectstyle.wolips.eomodeler.core.model.EOModelReferenceFailure;
import org.objectstyle.wolips.eomodeler.core.model.EOStoredProcedure;
import org.objectstyle.wolips.eomodeler.core.model.IEOEntityRelative;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOModelUtils {
    public static String getOperationLabel(String operation, List objs) {
        StringBuffer operationLabel = new StringBuffer();
        operationLabel.append(operation);
        if (objs != null) {
            if (objs.size() == 1) {
                Object obj = objs.get(0);
                if (obj instanceof EOModelObject) {
                    operationLabel.append(" ");
                    operationLabel.append(((EOModelObject)obj).getName());
                }
            } else if (objs.size() > 1) {
                operationLabel.append(" ");
                operationLabel.append(objs.size());
                Class<?> objType = null;
                for (Object obj : objs) {
                    Class<?> thisObjType = obj.getClass();
                    if (objType == null) {
                        objType = thisObjType;
                        continue;
                    }
                    if (objType.isAssignableFrom(thisObjType)) continue;
                    objType = null;
                    break;
                }
                operationLabel.append(" ");
                if (objType == null) {
                    operationLabel.append("Items");
                } else {
                    operationLabel.append(StringUtils.toPlural((String)StringUtils.toShortPrettyClassName((String)objType.getName())));
                }
            }
        }
        return operationLabel.toString();
    }

    public static Set<EOModelObject> getRecommendedDeletions(Object[] selectedObjects) {
        Set<EOModelReferenceFailure> beforeReferenceFailures = EOModelUtils.getReferenceFailures(selectedObjects);
        Set<EOModelObject> allRecommendedObjectsSet = new HashSet<EOModelObject>();
        for (Object selectedObject : selectedObjects) {
            if (!(selectedObject instanceof EOModelObject)) continue;
            EOModelObject modelObject = (EOModelObject)selectedObject;
            allRecommendedObjectsSet.add(modelObject);
        }
        for (EOModelReferenceFailure referenceFailure : beforeReferenceFailures) {
            Set<EOModelObject> recommendedDeletions = referenceFailure.getRecommendedDeletions();
            for (EOModelObject recommendedDelete : recommendedDeletions) {
                allRecommendedObjectsSet.add(recommendedDelete);
            }
        }
        Object[] recommendedObjects = allRecommendedObjectsSet.toArray();
        Set<EOModelReferenceFailure> afterReferenceFailures = EOModelUtils.getReferenceFailures(recommendedObjects);
        if (beforeReferenceFailures.size() != afterReferenceFailures.size()) {
            allRecommendedObjectsSet = EOModelUtils.getRecommendedDeletions(recommendedObjects);
        }
        return allRecommendedObjectsSet;
    }

    public static Set<EOModelReferenceFailure> getReferenceFailures(Object[] selectedObjects) {
        HashSet<EOModelObject> deletedObjects = new HashSet<EOModelObject>();
        HashSet<EOModelReferenceFailure> referenceFailures = new HashSet<EOModelReferenceFailure>();
        for (Object selectedObject : selectedObjects) {
            if (!(selectedObject instanceof EOModelObject)) continue;
            EOModelObject modelObject = (EOModelObject)selectedObject;
            deletedObjects.add(modelObject);
            referenceFailures.addAll(modelObject.getReferenceFailures());
        }
        for (EOModelObject deletedObject : deletedObjects) {
            for (EOModelReferenceFailure referenceFailure : new HashSet<EOModelReferenceFailure>(referenceFailures)) {
                if (!referenceFailure.getReferencingObject().equals(deletedObject)) continue;
                referenceFailures.remove(referenceFailure);
            }
        }
        return referenceFailures;
    }

    public static IUndoContext getUndoContext(Object obj) {
        EOModel model = EOModelUtils.getRelatedModel(obj);
        String label = model == null ? "No Model" : model.getName();
        return new ObjectUndoContext((Object)model, label);
    }

    public static EOModelObject getRelated(Class<? extends EOModelObject> type, EOModelObject obj) {
        EOModelObject relatedObj = EOModel.class.isAssignableFrom(type) ? EOModelUtils.getRelatedModel(obj) : (EOEntity.class.isAssignableFrom(type) ? EOModelUtils.getRelatedEntity(obj) : (EOStoredProcedure.class.isAssignableFrom(type) ? (obj instanceof EOStoredProcedure ? obj : (obj instanceof EOArgument ? ((EOArgument)obj).getStoredProcedure() : null)) : null));
        return relatedObj;
    }

    public static EOModel getRelatedModel(Object obj) {
        EOModel model = null;
        if (obj instanceof EOModel) {
            model = (EOModel)obj;
        } else if (obj instanceof IEOEntityRelative) {
            model = ((IEOEntityRelative)obj).getEntity().getModel();
        } else if (obj instanceof EOStoredProcedure) {
            model = ((EOStoredProcedure)obj).getModel();
        } else if (obj instanceof EOArgument) {
            model = ((EOArgument)obj).getStoredProcedure().getModel();
        } else if (obj instanceof EODatabaseConfig) {
            model = ((EODatabaseConfig)obj).getModel();
        } else if (obj instanceof Object[]) {
            Object arrayObj;
            Object[] objs;
            Object[] objectArray = objs = (Object[])obj;
            int n = objectArray.length;
            for (int i = 0; i < n && (model = EOModelUtils.getRelatedModel(arrayObj = objectArray[i])) == null; ++i) {
            }
        }
        return model;
    }

    public static EOEntity getRelatedEntity(Object obj) {
        EOEntity entity = null;
        if (obj instanceof IEOEntityRelative) {
            entity = ((IEOEntityRelative)obj).getEntity();
        }
        return entity;
    }

    public static EOStoredProcedure getRelatedStoredProcedure(Object obj) {
        EOStoredProcedure storedProcedure = null;
        if (obj instanceof EOStoredProcedure) {
            storedProcedure = (EOStoredProcedure)obj;
        } else if (obj instanceof EOArgument) {
            storedProcedure = ((EOArgument)obj).getStoredProcedure();
        }
        return storedProcedure;
    }
}

