/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.entities;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.baseforuiplugins.utils.KeyComboBoxCellEditor;
import org.objectstyle.wolips.baseforuiplugins.utils.TableRowDoubleClickHandler;
import org.objectstyle.wolips.baseforuiplugins.utils.WOTextCellEditor;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.editors.IEOModelEditor;
import org.objectstyle.wolips.eomodeler.editors.entities.EOEntitiesCellModifier;
import org.objectstyle.wolips.eomodeler.editors.entities.EOEntitiesContentProvider;
import org.objectstyle.wolips.eomodeler.editors.entities.EOEntitiesLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.entities.EOEntitiesViewerSorter;
import org.objectstyle.wolips.eomodeler.utils.StayEditingCellEditorListener;
import org.objectstyle.wolips.eomodeler.utils.TableRefreshPropertyListener;
import org.objectstyle.wolips.eomodeler.utils.TableRowRefreshPropertyListener;
import org.objectstyle.wolips.eomodeler.utils.TableUtils;

public class EOEntitiesTableViewer
extends Composite
implements ISelectionProvider,
IEOModelEditor {
    private TableViewer myEntitiesTableViewer;
    private EOModel myModel;
    private TableRefreshPropertyListener myTableRefresher;
    private TableRowRefreshPropertyListener myTableRowRefresher;

    public EOEntitiesTableViewer(Composite _parent, int _style) {
        super(_parent, _style);
        this.setLayout((Layout)new FillLayout());
        this.myEntitiesTableViewer = TableUtils.createTableViewer((Composite)this, 65538, "EOEntity", EOEntity.class.getName(), (IStructuredContentProvider)new EOEntitiesContentProvider(), (ITableLabelProvider)new EOEntitiesLabelProvider(EOEntity.class.getName()), (ViewerSorter)new EOEntitiesViewerSorter(EOEntity.class.getName()));
        new DoubleClickNewEntityHandler(this.myEntitiesTableViewer).attach();
        Table entitiesTable = this.myEntitiesTableViewer.getTable();
        entitiesTable.setLayoutData((Object)new GridData(1808));
        TableUtils.sort(this.myEntitiesTableViewer, "name");
        CellEditor[] cellEditors = new CellEditor[TableUtils.getColumnsForTableNamed(EOEntity.class.getName()).length];
        TableUtils.setCellEditor(EOEntity.class.getName(), "name", (CellEditor)new WOTextCellEditor((Composite)entitiesTable), cellEditors);
        TableUtils.setCellEditor(EOEntity.class.getName(), "externalName", (CellEditor)new WOTextCellEditor((Composite)entitiesTable), cellEditors);
        TableUtils.setCellEditor(EOEntity.class.getName(), "className", (CellEditor)new WOTextCellEditor((Composite)entitiesTable), cellEditors);
        TableUtils.setCellEditor(EOEntity.class.getName(), "parent", (CellEditor)new KeyComboBoxCellEditor((Composite)entitiesTable, new String[0], 8), cellEditors);
        this.myEntitiesTableViewer.setCellModifier((ICellModifier)new EOEntitiesCellModifier(this.myEntitiesTableViewer, cellEditors));
        this.myEntitiesTableViewer.setCellEditors(cellEditors);
        new StayEditingCellEditorListener(this.myEntitiesTableViewer, EOEntity.class.getName(), "name");
        new StayEditingCellEditorListener(this.myEntitiesTableViewer, EOEntity.class.getName(), "externalName");
        new StayEditingCellEditorListener(this.myEntitiesTableViewer, EOEntity.class.getName(), "className");
        new StayEditingCellEditorListener(this.myEntitiesTableViewer, EOEntity.class.getName(), "parent");
        this.myTableRefresher = new TableRefreshPropertyListener("EntitiesChanged", this.myEntitiesTableViewer);
        this.myTableRowRefresher = new TableRowRefreshPropertyListener(this.myEntitiesTableViewer);
    }

    public void setModel(EOModel _model) {
        TableColumn parentName;
        TableColumn className;
        TableColumn externalName;
        if (this.myModel != null) {
            this.myModel.removePropertyChangeListener("entities", this.myTableRefresher);
            this.myModel.removePropertyChangeListener("entity", this.myTableRowRefresher);
        }
        this.myModel = _model;
        this.myEntitiesTableViewer.setInput((Object)this.myModel);
        TableUtils.packTableColumns(this.myEntitiesTableViewer);
        TableColumn nameColumn = TableUtils.getColumn(this.myEntitiesTableViewer, EOEntity.class.getName(), "name");
        if (nameColumn != null) {
            nameColumn.setWidth(Math.max(nameColumn.getWidth(), 100));
        }
        if ((externalName = TableUtils.getColumn(this.myEntitiesTableViewer, EOEntity.class.getName(), "externalName")) != null) {
            externalName.setWidth(Math.max(externalName.getWidth(), 100));
        }
        if ((className = TableUtils.getColumn(this.myEntitiesTableViewer, EOEntity.class.getName(), "className")) != null) {
            className.setWidth(Math.max(className.getWidth(), 100));
        }
        if ((parentName = TableUtils.getColumn(this.myEntitiesTableViewer, EOEntity.class.getName(), "parent")) != null) {
            parentName.setWidth(Math.max(parentName.getWidth(), 100));
        }
        if (this.myModel != null) {
            this.myModel.addPropertyChangeListener("entities", this.myTableRefresher);
            this.myModel.addPropertyChangeListener("entity", this.myTableRowRefresher);
        }
    }

    public EOModel getModel() {
        return this.myModel;
    }

    public void setSelectedEntity(EOEntity _entity) {
        IStructuredSelection selection = (IStructuredSelection)this.myEntitiesTableViewer.getSelection();
        if (_entity == null && !selection.isEmpty() || selection != null && !selection.toList().contains(_entity)) {
            if (_entity == null) {
                this.myEntitiesTableViewer.setSelection((ISelection)new StructuredSelection(), true);
            } else {
                this.myEntitiesTableViewer.setSelection((ISelection)new StructuredSelection((Object)_entity), true);
            }
        }
    }

    public TableViewer getTableViewer() {
        return this.myEntitiesTableViewer;
    }

    public void setSelection(ISelection _selection) {
        this.myEntitiesTableViewer.setSelection(_selection);
    }

    public ISelection getSelection() {
        return this.myEntitiesTableViewer.getSelection();
    }

    public void addSelectionChangedListener(ISelectionChangedListener _listener) {
        this.myEntitiesTableViewer.addSelectionChangedListener(_listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener _listener) {
        this.myEntitiesTableViewer.removeSelectionChangedListener(_listener);
    }

    protected class DoubleClickNewEntityHandler
    extends TableRowDoubleClickHandler {
        public DoubleClickNewEntityHandler(TableViewer _viewer) {
            super(_viewer);
        }

        protected void emptyDoubleSelectionOccurred() {
            try {
                EOEntitiesTableViewer.this.getModel().addBlankEntity(Messages.getString("EOEntity.newName"));
            }
            catch (Throwable e) {
                ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)e);
            }
        }

        protected void doubleSelectionOccurred(ISelection _selection) {
        }
    }
}

