/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.entityIndex;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOEntityIndex;
import org.objectstyle.wolips.eomodeler.core.utils.IPropertyChangeSource;
import org.objectstyle.wolips.eomodeler.editors.attributes.EOAttributesContentProvider;
import org.objectstyle.wolips.eomodeler.editors.attributes.EOAttributesLabelProvider;
import org.objectstyle.wolips.eomodeler.editors.entityIndex.EOEntityIndexAttributesContentProvider;
import org.objectstyle.wolips.eomodeler.utils.AddRemoveButtonGroup;
import org.objectstyle.wolips.eomodeler.utils.ComboViewerBinding;

public class EOEntityIndexAttributesEditor
extends Composite
implements IPropertyChangeSource {
    private EOEntityIndex _entityIndex;
    private ComboViewer _attributesComboViewer;
    private ListViewer _entityIndexListViewer;
    private AddRemoveButtonGroup _addRemoveButtonGroup;
    private ButtonUpdateListener _buttonUpdateListener;
    private EOAttribute _selectedAttribute;
    private DataBindingContext _dataBindingContext;
    private ComboViewerBinding _selectedAttributeBinding;
    private PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);

    public EOEntityIndexAttributesEditor(Composite parent, int style) {
        super(parent, style);
        this.setBackground(parent.getBackground());
        this._buttonUpdateListener = new ButtonUpdateListener();
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this._entityIndexListViewer = new ListViewer((Composite)this, 0x800802);
        this._entityIndexListViewer.setContentProvider((IContentProvider)new EOEntityIndexAttributesContentProvider());
        this._entityIndexListViewer.setLabelProvider((IBaseLabelProvider)new EOAttributesLabelProvider(new String[]{"name"}));
        GridData attributeListLayoutData = new GridData(1808);
        attributeListLayoutData.heightHint = 100;
        this._entityIndexListViewer.getList().setLayoutData((Object)attributeListLayoutData);
        this._entityIndexListViewer.addSelectionChangedListener((ISelectionChangedListener)this._buttonUpdateListener);
        Combo attributesCombo = new Combo((Composite)this, 0x800808);
        this._attributesComboViewer = new ComboViewer(attributesCombo);
        this._attributesComboViewer.setLabelProvider((IBaseLabelProvider)new EOAttributesLabelProvider(new String[]{"name"}));
        this._attributesComboViewer.setContentProvider((IContentProvider)new EOAttributesContentProvider());
        GridData attributesComboLayoutData = new GridData(768);
        attributesCombo.setLayoutData((Object)attributesComboLayoutData);
        this._addRemoveButtonGroup = new AddRemoveButtonGroup(this, new AddAttributeHandler(), new RemoveAttributesHandler());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this._propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this._propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public void setSelectedAttribute(EOAttribute selectedAttribute) {
        EOAttribute oldAttribute = this._selectedAttribute;
        this._selectedAttribute = selectedAttribute;
        this._propertyChangeSupport.firePropertyChange("selectedAttribute", oldAttribute, selectedAttribute);
    }

    public EOAttribute getSelectedAttribute() {
        return this._selectedAttribute;
    }

    public void setEntityIndex(EOEntityIndex entityIndex) {
        if (!ComparisonUtils.equals((Object)entityIndex, (Object)this._entityIndex)) {
            this.disposeBindings();
            this._entityIndex = entityIndex;
            if (this._entityIndex != null) {
                this._selectedAttribute = null;
                this._dataBindingContext = new DataBindingContext();
                this._selectedAttributeBinding = new ComboViewerBinding(this._attributesComboViewer, this, "selectedAttribute", null, null, null);
                this.updateAttributes();
                this.updateButtons();
            }
        }
    }

    protected void updateButtons() {
        boolean removeEnabled = !this._entityIndexListViewer.getSelection().isEmpty();
        this._addRemoveButtonGroup.setRemoveEnabled(removeEnabled);
    }

    protected void updateAttributes() {
        if (this._entityIndexListViewer != null) {
            this._entityIndexListViewer.setInput((Object)this._entityIndex);
            this._attributesComboViewer.setInput((Object)this._entityIndex.getEntity());
        }
    }

    protected void addSelectedAttribute() {
        if (this._selectedAttribute != null) {
            this._entityIndex.addAttribute(this._selectedAttribute);
            this._entityIndexListViewer.setSelection((ISelection)new StructuredSelection((Object)this._selectedAttribute));
            this.updateAttributes();
        }
    }

    protected void removeSelectedAttributes() {
        boolean confirmed;
        Object[] selectedAttributes = ((IStructuredSelection)this._entityIndexListViewer.getSelection()).toArray();
        if (selectedAttributes.length > 0 && (confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("EOEntityIndexBasicEditorSection.removeAttributesTitle"), (String)Messages.getString("EOEntityIndexBasicEditorSection.removeAttributesMessage")))) {
            for (int attributeNum = 0; attributeNum < selectedAttributes.length; ++attributeNum) {
                EOAttribute attribute = (EOAttribute)selectedAttributes[attributeNum];
                this._entityIndex.removeAttribute(attribute, true);
            }
            this.updateAttributes();
        }
    }

    public void disposeBindings() {
        if (this._entityIndex != null) {
            this._dataBindingContext.dispose();
            this._selectedAttributeBinding.dispose();
        }
    }

    public void setEnabled(boolean _enabled) {
        super.setEnabled(_enabled);
        this._entityIndexListViewer.getList().setEnabled(_enabled);
        this.updateButtons();
    }

    public void dispose() {
        super.dispose();
        this.disposeBindings();
    }

    protected class RemoveAttributesHandler
    implements SelectionListener {
        protected RemoveAttributesHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent _e) {
            this.widgetSelected(_e);
        }

        public void widgetSelected(SelectionEvent _e) {
            EOEntityIndexAttributesEditor.this.removeSelectedAttributes();
        }
    }

    protected class AddAttributeHandler
    implements SelectionListener {
        protected AddAttributeHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent _e) {
            this.widgetSelected(_e);
        }

        public void widgetSelected(SelectionEvent _e) {
            EOEntityIndexAttributesEditor.this.addSelectedAttribute();
        }
    }

    protected class ButtonUpdateListener
    implements ISelectionChangedListener {
        protected ButtonUpdateListener() {
        }

        public void selectionChanged(SelectionChangedEvent _event) {
            EOEntityIndexAttributesEditor.this.updateButtons();
        }
    }

    protected class EntityIndexAttributesListener
    implements PropertyChangeListener {
        protected EntityIndexAttributesListener() {
        }

        public void propertyChange(PropertyChangeEvent _event) {
            String propertyName = _event.getPropertyName();
            if (propertyName.equals("attributes")) {
                EOEntityIndexAttributesEditor.this.updateAttributes();
            }
        }
    }

    protected class AttributesListener
    implements PropertyChangeListener {
        protected AttributesListener() {
        }

        public void propertyChange(PropertyChangeEvent _event) {
            String propertyName = _event.getPropertyName();
            if (propertyName.equals("attribute")) {
                EOEntityIndexAttributesEditor.this.updateAttributes();
            } else if (propertyName.equals("attributes")) {
                EOEntityIndexAttributesEditor.this.updateAttributes();
            }
        }
    }
}

