/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.openEntity;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.baseforplugins.util.FilesystemFolder;
import org.objectstyle.wolips.baseforplugins.util.ResourceUtilities;
import org.objectstyle.wolips.baseforplugins.util.URLUtils;
import org.objectstyle.wolips.eomodeler.actions.OpenEntityModelerAction;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.editors.EOModelEditor;
import org.objectstyle.wolips.eomodeler.editors.openEntity.OpenEntityDialog;

public class OpenEntityHandler
extends Action
implements IHandler,
IWorkbenchWindowActionDelegate {
    private static String PARAM_ID_FILE_PATH = "filePath";
    private transient ListenerList listenerList = null;

    public OpenEntityHandler() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_workspace_file_action_context");
    }

    public void addHandlerListener(IHandlerListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ListenerList(1);
        }
        this.listenerList.add((Object)listener);
    }

    public void dispose() {
        this.listenerList = null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EOModelEditor modelEditor = null;
        ArrayList<IResource> files = new ArrayList<IResource>();
        if (event.getParameter(PARAM_ID_FILE_PATH) == null) {
            Object[] result = this.queryFileResource();
            if (result != null) {
                if (result.length == 2 && result[0] instanceof EOModelEditor) {
                    modelEditor = (EOModelEditor)result[0];
                    result = (Object[])result[1];
                }
                if (result != null) {
                    for (int i = 0; i < result.length; ++i) {
                        files.add((IResource)result[i]);
                    }
                }
            }
        } else {
            IResource resource = (IResource)event.getObjectParameterForExecution(PARAM_ID_FILE_PATH);
            if (!(resource instanceof IFile)) {
                throw new ExecutionException("filePath parameter must identify a file");
            }
            files.add(resource);
        }
        if (files.size() > 0) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                throw new ExecutionException("no active workbench window");
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                throw new ExecutionException("no active workbench page");
            }
            for (IResource resource : files) {
                IFile file = null;
                if (!"eomodeld".equals(resource.getFileExtension()) && resource instanceof IFile) {
                    if (modelEditor != null) {
                        EOEntity entity = modelEditor.getModel().getModelGroup().getEntityNamed(ResourceUtilities.getFileNameWithoutExtension((IResource)resource));
                        if (entity == null) continue;
                        modelEditor.setSelection((ISelection)new StructuredSelection((Object)entity));
                        continue;
                    }
                    file = (IFile)resource;
                    OpenEntityModelerAction.openResourceIfPossible(null, (IResource)file);
                    continue;
                }
                if (resource instanceof IContainer) {
                    if (modelEditor != null) {
                        EOModel model = modelEditor.getModel().getModelGroup().getModelNamed(ResourceUtilities.getFileNameWithoutExtension((String)resource.getName()));
                        if (model == null) continue;
                        modelEditor.setSelection((ISelection)new StructuredSelection((Object)model));
                        continue;
                    }
                    file = ((IContainer)resource).getFile((IPath)new Path("index.eomodeld"));
                    OpenEntityModelerAction.openResourceIfPossible(null, (IResource)file);
                    continue;
                }
                file = null;
            }
        }
        return null;
    }

    public void init(IWorkbenchWindow window) {
    }

    private Object[] queryFileResource() {
        OpenEntityDialog dialog;
        int resultCode;
        EOModel editingModel;
        IEditorPart editorPart;
        IPerspectiveDescriptor perspective;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        Shell parent = window.getShell();
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        EOModelEditor modelEditor = null;
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null && (perspective = window.getActivePage().getPerspective()) != null && "org.objectstyle.wolips.eomodeler.EOModelerPerspective".equals(perspective.getId()) && (editorPart = activePage.getActiveEditor()) instanceof EOModelEditor && (editingModel = (modelEditor = (EOModelEditor)editorPart).getModel()) != null) {
            LinkedList<File> modelFolders = new LinkedList<File>();
            EOModelGroup modelGroup = editingModel.getModelGroup();
            for (EOModel model : modelGroup.getModels()) {
                File modelFolder = URLUtils.cheatAndTurnIntoFile((URL)model.getModelURL()).getParentFile();
                modelFolders.add(modelFolder);
            }
            if (modelFolders.size() > 0) {
                input = new FilesystemFolder(new File("/"), modelFolders);
            }
        }
        if ((resultCode = (dialog = new OpenEntityDialog(parent, (IContainer)input, modelEditor == null)).open()) != 0) {
            return null;
        }
        Object[] result = dialog.getResult();
        if (modelEditor != null) {
            result = new Object[]{modelEditor, result};
        }
        return result;
    }

    public void removeHandlerListener(IHandlerListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove((Object)listener);
            if (this.listenerList.isEmpty()) {
                this.listenerList = null;
            }
        }
    }

    public void run(IAction action) {
        try {
            this.execute(new ExecutionEvent());
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

