/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.qualifier;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOAggregateQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOQualifier;
import org.objectstyle.wolips.eomodeler.editors.qualifier.AbstractQualifierTypeEditor;
import org.objectstyle.wolips.eomodeler.editors.qualifier.AndQualifierType;
import org.objectstyle.wolips.eomodeler.editors.qualifier.ExpressionQualifierType;
import org.objectstyle.wolips.eomodeler.editors.qualifier.IQualifierEditorListener;
import org.objectstyle.wolips.eomodeler.editors.qualifier.IQualifierType;
import org.objectstyle.wolips.eomodeler.editors.qualifier.IQualifierTypeEditorListener;
import org.objectstyle.wolips.eomodeler.editors.qualifier.KeyValueQualifierType;
import org.objectstyle.wolips.eomodeler.editors.qualifier.NotQualifierType;
import org.objectstyle.wolips.eomodeler.editors.qualifier.OrQualifierType;
import org.objectstyle.wolips.eomodeler.editors.qualifier.SelectKeyQualifierType;

public class EOQualifierEditor
extends Composite
implements IQualifierTypeEditorListener {
    private ComboViewer _typeCombo;
    private Composite _typeEditorContainer;
    private Button _removeButton;
    private Button _addButton;
    private IQualifierType _qualifierType;
    private AbstractQualifierTypeEditor _typeEditor;
    private boolean _settingQualifier;
    private IQualifierType[] _qualifierTypes = new IQualifierType[]{new ExpressionQualifierType(), new SelectKeyQualifierType(), new KeyValueQualifierType(), new AndQualifierType(), new OrQualifierType(), new NotQualifierType()};
    private IQualifierEditorListener _listener;

    public EOQualifierEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(4, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this._typeCombo = new ComboViewer((Composite)this, 8);
        this._typeCombo.add((Object[])this._qualifierTypes);
        this._typeCombo.addSelectionChangedListener((ISelectionChangedListener)new TypeSelectionHandler());
        this._typeCombo.getCombo().setLayoutData((Object)new GridData());
        this._typeEditorContainer = new Composite((Composite)this, 0);
        this._typeEditorContainer.setLayout((Layout)new FillLayout(256));
        this._typeEditorContainer.setLayoutData((Object)new GridData(768));
    }

    public void setQualifierEditorListener(IQualifierEditorListener listener) {
        this._listener = listener;
    }

    public IQualifierEditorListener getQualifierEditorListener() {
        return this._listener;
    }

    protected void createButtons() {
        this._removeButton = new Button((Composite)this, 8);
        this._removeButton.setText("-");
        this._removeButton.setLayoutData((Object)new GridData());
        this._removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IQualifierEditorListener listener = EOQualifierEditor.this.getQualifierEditorListener();
                if (listener != null) {
                    listener.qualifierRemoved(EOQualifierEditor.this);
                }
            }
        });
        this._addButton = new Button((Composite)this, 8);
        this._addButton.setText("+");
        this._addButton.setLayoutData((Object)new GridData());
        this._addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IQualifierEditorListener listener = EOQualifierEditor.this.getQualifierEditorListener();
                if (listener != null) {
                    listener.qualifierAddedBelow(EOQualifierEditor.this);
                }
            }
        });
    }

    public EOQualifier getQualifier() {
        return this._typeEditor == null ? null : this._typeEditor.getQualifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQualifier(EOQualifier qualifier) {
        IQualifierType matchingQualifierType = null;
        for (IQualifierType qualifierType : this._qualifierTypes) {
            if (qualifierType instanceof ExpressionQualifierType || !qualifierType.isTypeFor(qualifier)) continue;
            matchingQualifierType = qualifierType;
        }
        if (matchingQualifierType == null) {
            for (IQualifierType qualifierType : this._qualifierTypes) {
                if (!(qualifierType instanceof ExpressionQualifierType)) continue;
                matchingQualifierType = qualifierType;
            }
        }
        this._settingQualifier = true;
        try {
            this._typeCombo.setSelection((ISelection)new StructuredSelection(matchingQualifierType));
            this._typeEditor.setQualifier(qualifier);
            this.refreshQualifierTypes();
        }
        finally {
            this._settingQualifier = false;
        }
    }

    protected void typeChanged() {
        IStructuredSelection selection = (IStructuredSelection)this._typeCombo.getSelection();
        IQualifierType selectedQualifierType = (IQualifierType)selection.getFirstElement();
        if (selectedQualifierType != null && this._qualifierType != selectedQualifierType) {
            EOQualifier previousQualifier = this.getQualifier();
            if (this._typeEditor != null) {
                this._typeEditor.dispose();
                this._typeEditor = null;
            }
            this._qualifierType = selectedQualifierType;
            if (this._qualifierType != null) {
                this._typeEditor = this._qualifierType.createEditor(this._typeEditorContainer);
                this._typeEditor.setQualifierTypeEditorListener(this);
            }
            if (!this._settingQualifier) {
                this._typeEditor.setQualifier(previousQualifier);
                this.refreshQualifierTypes();
            }
        }
        this.getParent().layout(true, true);
    }

    protected void refreshQualifierTypes() {
        boolean buttonsVisible;
        EOQualifier qualifier = this._typeEditor.getQualifier();
        for (IQualifierType qualifierType : this._qualifierTypes) {
            qualifierType.setQualifier(qualifier);
            this._typeCombo.refresh((Object)qualifierType);
        }
        boolean bl = buttonsVisible = !(qualifier instanceof EOAggregateQualifier);
        if (!buttonsVisible) {
            if (this._addButton != null) {
                this._addButton.dispose();
                this._addButton = null;
            }
            if (this._removeButton != null) {
                this._removeButton.dispose();
                this._removeButton = null;
            }
            ((GridLayout)this.getLayout()).numColumns = 2;
        } else {
            ((GridLayout)this.getLayout()).numColumns = 4;
            this.createButtons();
        }
        this.layout();
    }

    public void qualifierTypeChanged(AbstractQualifierTypeEditor editor) {
        this.setQualifier(this.getQualifier());
    }

    protected class TypeSelectionHandler
    implements ISelectionChangedListener {
        protected TypeSelectionHandler() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            EOQualifierEditor.this.typeChanged();
        }
    }
}

