/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.relationship;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforuiplugins.utils.KeyComboBoxCellEditor;
import org.objectstyle.wolips.baseforuiplugins.utils.TableRowDoubleClickHandler;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOJoin;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.editors.relationship.EOJoinsCellModifier;
import org.objectstyle.wolips.eomodeler.editors.relationship.EOJoinsContentProvider;
import org.objectstyle.wolips.eomodeler.editors.relationship.EOJoinsLabelProvider;
import org.objectstyle.wolips.eomodeler.utils.AddRemoveButtonGroup;
import org.objectstyle.wolips.eomodeler.utils.TablePropertyViewerSorter;
import org.objectstyle.wolips.eomodeler.utils.TableUtils;

public class JoinsTableEditor
extends Composite {
    private EORelationship myRelationship;
    private TableViewer myJoinsTableViewer;
    private AddRemoveButtonGroup myAddRemoveButtonGroup;
    private AttributesListener myAttributesListener;
    private RelationshipListener myRelationshipListener;
    private ButtonUpdateListener myButtonUpdateListener;

    public JoinsTableEditor(Composite _parent, int _style) {
        super(_parent, _style);
        this.setBackground(_parent.getBackground());
        this.myRelationshipListener = new RelationshipListener();
        this.myButtonUpdateListener = new ButtonUpdateListener();
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this.myJoinsTableViewer = TableUtils.createTableViewer((Composite)this, 8456194, "EOJoin", EOJoin.class.getName(), (IStructuredContentProvider)new EOJoinsContentProvider(), (ITableLabelProvider)new EOJoinsLabelProvider(EOJoin.class.getName()), (ViewerSorter)new TablePropertyViewerSorter(EOJoin.class.getName()));
        CellEditor[] cellEditors = new CellEditor[TableUtils.getColumnsForTableNamed(EOJoin.class.getName()).length];
        TableUtils.setCellEditor(EOJoin.class.getName(), "sourceAttributeName", (CellEditor)new KeyComboBoxCellEditor((Composite)this.myJoinsTableViewer.getTable(), new String[0], 8), cellEditors);
        TableUtils.setCellEditor(EOJoin.class.getName(), "destinationAttributeName", (CellEditor)new KeyComboBoxCellEditor((Composite)this.myJoinsTableViewer.getTable(), new String[0], 8), cellEditors);
        this.myJoinsTableViewer.setCellModifier((ICellModifier)new EOJoinsCellModifier(this.myJoinsTableViewer));
        this.myJoinsTableViewer.setCellEditors(cellEditors);
        GridData joinsTableLayoutData = new GridData(1808);
        joinsTableLayoutData.heightHint = 100;
        this.myJoinsTableViewer.getTable().setLayoutData((Object)joinsTableLayoutData);
        this.myJoinsTableViewer.addSelectionChangedListener((ISelectionChangedListener)this.myButtonUpdateListener);
        new DoubleClickNewJoinHandler(this.myJoinsTableViewer).attach();
        this.myAddRemoveButtonGroup = new AddRemoveButtonGroup(this, new AddJoinHandler(), new RemoveJoinsHandler());
    }

    public void setRelationship(EORelationship _relationship) {
        if (!ComparisonUtils.equals((Object)_relationship, (Object)this.myRelationship)) {
            this.disposeBindings();
            this.myRelationship = _relationship;
            if (this.myRelationship != null) {
                this.myRelationship.addPropertyChangeListener("destination", this.myRelationshipListener);
                this.myRelationship.addPropertyChangeListener("joins", this.myRelationshipListener);
                this.myRelationship.addPropertyChangeListener("definition", this.myRelationshipListener);
                this.myJoinsTableViewer.setInput((Object)this.myRelationship);
                TableUtils.sort(this.myJoinsTableViewer, "sourceAttribute");
                boolean enabled = !this.myRelationship.isFlattened();
                this.myJoinsTableViewer.getTable().setEnabled(enabled);
                this.myAddRemoveButtonGroup.setAddEnabled(enabled);
                this.myAddRemoveButtonGroup.setRemoveEnabled(enabled);
                this.updateJoins();
                this.updateButtons();
            }
        }
    }

    protected void updateButtons() {
        boolean joinsEnabled = this.myRelationship != null && !this.myRelationship.isFlattened();
        boolean buttonsEnabled = this.isEnabled() && this.myRelationship != null && this.myRelationship.getDestination() != null && joinsEnabled;
        boolean removeEnabled = buttonsEnabled && !this.myJoinsTableViewer.getSelection().isEmpty() && joinsEnabled;
        boolean addEnabled = buttonsEnabled;
        this.myAddRemoveButtonGroup.setRemoveEnabled(removeEnabled);
        this.myAddRemoveButtonGroup.setAddEnabled(addEnabled);
    }

    protected void updateJoins() {
        if (this.myJoinsTableViewer != null) {
            TableColumn destinationColumn;
            EOEntity destination;
            TableColumn sourceColumn;
            this.myJoinsTableViewer.setInput((Object)this.myRelationship);
            EOEntity source = this.myRelationship.getEntity();
            if (source != null && (sourceColumn = TableUtils.getColumn(this.myJoinsTableViewer, EOJoin.class.getName(), "sourceAttributeName")) != null) {
                sourceColumn.setText(source.getName());
                KeyComboBoxCellEditor sourceCellEditor = (KeyComboBoxCellEditor)TableUtils.getCellEditor(this.myJoinsTableViewer, EOJoin.class.getName(), "sourceAttributeName");
                sourceCellEditor.setItems(source.getAttributeNames());
            }
            if ((destination = this.myRelationship.getDestination()) != null && (destinationColumn = TableUtils.getColumn(this.myJoinsTableViewer, EOJoin.class.getName(), "destinationAttributeName")) != null) {
                destinationColumn.setText(destination.getName());
                KeyComboBoxCellEditor destinationCellEditor = (KeyComboBoxCellEditor)TableUtils.getCellEditor(this.myJoinsTableViewer, EOJoin.class.getName(), "destinationAttributeName");
                destinationCellEditor.setItems(destination.getAttributeNames());
            }
            TableUtils.packTableColumns(this.myJoinsTableViewer);
        }
    }

    protected void addSelectedJoin() {
        EOJoin newJoin = new EOJoin();
        this.myRelationship.addJoin(newJoin);
        this.myJoinsTableViewer.setSelection((ISelection)new StructuredSelection((Object)newJoin));
    }

    protected void removeSelectedJoins() {
        boolean confirmed;
        Object[] selectedJoins = ((IStructuredSelection)this.myJoinsTableViewer.getSelection()).toArray();
        if (selectedJoins.length > 0 && (confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString("EORelationshipBasicEditorSection.removeJoinsTitle"), (String)Messages.getString("EORelationshipBasicEditorSection.removeJoinsMessage")))) {
            for (int joinNum = 0; joinNum < selectedJoins.length; ++joinNum) {
                EOJoin join = (EOJoin)selectedJoins[joinNum];
                this.myRelationship.removeJoin(join);
            }
        }
    }

    public void disposeBindings() {
        if (this.myRelationship != null) {
            this.myRelationship.removePropertyChangeListener("definition", this.myRelationshipListener);
            this.myRelationship.removePropertyChangeListener("destination", this.myRelationshipListener);
            this.myRelationship.removePropertyChangeListener("joins", this.myRelationshipListener);
            EOEntity destination = this.myRelationship.getDestination();
            if (destination != null) {
                destination.removePropertyChangeListener("attribute", this.myAttributesListener);
                destination.removePropertyChangeListener("attributes", this.myAttributesListener);
            }
        }
    }

    public void setEnabled(boolean _enabled) {
        super.setEnabled(_enabled);
        this.myJoinsTableViewer.getTable().setEnabled(_enabled);
        this.updateButtons();
    }

    public void dispose() {
        super.dispose();
        this.disposeBindings();
    }

    protected void definitionChanged() {
        this.updateJoins();
        this.updateButtons();
    }

    protected void destinationChanged(EOEntity _oldDestination, EOEntity _newDestination) {
        if (_oldDestination != null) {
            _oldDestination.removePropertyChangeListener("attribute", this.myAttributesListener);
            _oldDestination.removePropertyChangeListener("attributes", this.myAttributesListener);
        }
        this.updateJoins();
        this.updateButtons();
        if (_newDestination != null) {
            _newDestination.addPropertyChangeListener("attribute", this.myAttributesListener);
            _newDestination.addPropertyChangeListener("attributes", this.myAttributesListener);
        }
    }

    protected class RemoveJoinsHandler
    implements SelectionListener {
        protected RemoveJoinsHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent _e) {
            this.widgetSelected(_e);
        }

        public void widgetSelected(SelectionEvent _e) {
            JoinsTableEditor.this.removeSelectedJoins();
        }
    }

    protected class AddJoinHandler
    implements SelectionListener {
        protected AddJoinHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent _e) {
            this.widgetSelected(_e);
        }

        public void widgetSelected(SelectionEvent _e) {
            JoinsTableEditor.this.addSelectedJoin();
        }
    }

    protected class ButtonUpdateListener
    implements ISelectionChangedListener {
        protected ButtonUpdateListener() {
        }

        public void selectionChanged(SelectionChangedEvent _event) {
            JoinsTableEditor.this.updateButtons();
        }
    }

    protected class RelationshipListener
    implements PropertyChangeListener {
        protected RelationshipListener() {
        }

        public void propertyChange(PropertyChangeEvent _event) {
            String propertyName = _event.getPropertyName();
            if (propertyName.equals("definition")) {
                JoinsTableEditor.this.definitionChanged();
            } else if (propertyName.equals("destination")) {
                EOEntity oldDestination = (EOEntity)_event.getOldValue();
                EOEntity newDestination = (EOEntity)_event.getNewValue();
                JoinsTableEditor.this.destinationChanged(oldDestination, newDestination);
            } else if (propertyName.equals("joins")) {
                JoinsTableEditor.this.updateJoins();
            }
        }
    }

    protected class AttributesListener
    implements PropertyChangeListener {
        protected AttributesListener() {
        }

        public void propertyChange(PropertyChangeEvent _event) {
            String propertyName = _event.getPropertyName();
            if (propertyName.equals("attribute")) {
                JoinsTableEditor.this.updateJoins();
            } else if (propertyName.equals("attributes")) {
                JoinsTableEditor.this.updateJoins();
            }
        }
    }

    protected class DoubleClickNewJoinHandler
    extends TableRowDoubleClickHandler {
        public DoubleClickNewJoinHandler(TableViewer _viewer) {
            super(_viewer);
        }

        protected void emptyDoubleSelectionOccurred() {
            JoinsTableEditor.this.addSelectedJoin();
        }

        protected void doubleSelectionOccurred(ISelection _selection) {
        }
    }
}

