/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.utils;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.objectstyle.wolips.baseforplugins.util.Throttle;

public class SelectionThrottle
implements Runnable {
    private String _name;
    private Throttle _throttle;
    private IThrottledSelectionHandler _selectionHandler;
    private List _addedObjects;
    private List _removedObjects;

    public SelectionThrottle(String name, IThrottledSelectionHandler selectionHandler) {
        this._name = name;
        this._selectionHandler = selectionHandler;
        this._addedObjects = new LinkedList();
        this._removedObjects = new LinkedList();
        this._throttle = new Throttle(this._name, 150L, (Runnable)this);
    }

    public void start() {
        this._throttle.start();
    }

    public void stop() {
        this._throttle.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        List addedObjects;
        List list = this._addedObjects;
        synchronized (list) {
            addedObjects = this._addedObjects;
            this._addedObjects = new LinkedList();
        }
        list = this._removedObjects;
        synchronized (list) {
            this._removedObjects = new LinkedList();
        }
        if (!addedObjects.isEmpty()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    SelectionThrottle.this._selectionHandler.changeSelection((ISelection)new StructuredSelection(addedObjects.get(0)));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectsAdded(Collection addedObjects) {
        if (!addedObjects.isEmpty()) {
            List list = this._addedObjects;
            synchronized (list) {
                this._addedObjects.addAll(addedObjects);
            }
            this._throttle.ping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectsRemoved(Collection removedObjects) {
        if (!removedObjects.isEmpty()) {
            List list = this._removedObjects;
            synchronized (list) {
                this._removedObjects.addAll(removedObjects);
            }
            this._throttle.ping();
        }
    }

    public static interface IThrottledSelectionHandler {
        public void changeSelection(ISelection var1);
    }

    public static class TableViewerSelectionHandler
    implements IThrottledSelectionHandler {
        private TableViewer _tableViewer;

        public TableViewerSelectionHandler(TableViewer tableViewer) {
            this._tableViewer = tableViewer;
        }

        public void changeSelection(ISelection selection) {
            this._tableViewer.setSelection(selection);
            this._tableViewer.getTable().forceFocus();
        }
    }
}

