/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforplugins.util;

public class Throttle
implements Runnable {
    private String _name;
    private Thread _throttleThread;
    private boolean _running;
    private boolean _stopRequested;
    private int _pingCount;
    private long _sleepTime;
    private Runnable _runnable;

    public Throttle(String name, long sleepTime, Runnable runnable) {
        this._name = name;
        this._sleepTime = sleepTime;
        this._runnable = runnable;
    }

    public synchronized int pingCount() {
        return this._pingCount;
    }

    public synchronized void ping() {
        ++this._pingCount;
        this.notifyAll();
    }

    public synchronized void start() {
        if (this._throttleThread == null) {
            this._throttleThread = new Thread((Runnable)this, this._name);
            this._throttleThread.start();
            while (!this._running) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void stop() {
        if (this._throttleThread != null) {
            this._stopRequested = true;
            while (this._running) {
                this.notifyAll();
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this._stopRequested = false;
            this._throttleThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Throttle throttle;
        Throttle throttle2 = this;
        synchronized (throttle2) {
            this._running = true;
            this.notifyAll();
        }
        boolean running = true;
        while (running) {
            throttle = this;
            synchronized (throttle) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            while (this._pingCount > 0) {
                int pingCount;
                Throttle throttle3 = this;
                synchronized (throttle3) {
                    pingCount = this._pingCount;
                }
                try {
                    Thread.sleep(this._sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                throttle3 = this;
                synchronized (throttle3) {
                    if (pingCount == this._pingCount) {
                        try {
                            this._runnable.run();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        this._pingCount = 0;
                    }
                }
            }
            throttle = this;
            synchronized (throttle) {
                running = !this._stopRequested;
            }
        }
        throttle = this;
        synchronized (throttle) {
            this._running = false;
            this.notifyAll();
        }
    }
}

