/*
 * Decompiled with CFR 0.152.
 */
package jp.aonir.fuzzyxml.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import jp.aonir.fuzzyxml.internal.FuzzyXMLFormatComposite;
import jp.aonir.fuzzyxml.internal.RenderContext;
import jp.aonir.fuzzyxml.internal.RenderDelegate;

public class WOHTMLRenderDelegate
implements RenderDelegate {
    private FuzzyXMLFormatComposite lastNode = null;
    private final boolean useStickyWOTags;
    private static final Set<String> STICKY_TAGS;
    private static final int LINE_WRAP_LENGTH = 120;
    private static final String[] SPACE_EFFECTED_TAGS;

    public WOHTMLRenderDelegate() {
        this(true);
    }

    public WOHTMLRenderDelegate(boolean _useStickyWOTags) {
        this.useStickyWOTags = _useStickyWOTags;
    }

    public void afterCloseTag(FuzzyXMLNode node, RenderContext renderContext, StringBuffer xmlBuffer) {
        FuzzyXMLFormatComposite _node = new FuzzyXMLFormatComposite(node);
        if (_node.isComment() && WOHTMLRenderDelegate.hasNewLineEnd(xmlBuffer)) {
            renderContext.appendIndent(xmlBuffer);
        }
        if (_node.getParentNode() == null) {
            xmlBuffer.append("\n");
        }
        this.lastNode = _node.isDocumentRoot() || _node.getParentNode().isDocumentRoot() ? null : _node;
    }

    public void afterOpenTag(FuzzyXMLNode node, RenderContext renderContext, StringBuffer xmlBuffer) {
        FuzzyXMLFormatComposite _node = new FuzzyXMLFormatComposite(node);
        if (renderContext.shouldFormat()) {
            renderContext.indent();
        }
        this.lastNode = _node;
    }

    public void afterRender(RenderContext renderContext, StringBuffer xmlBuffer) {
    }

    public void beforeCloseTag(FuzzyXMLNode node, RenderContext renderContext, StringBuffer xmlBuffer) {
        FuzzyXMLFormatComposite _node = new FuzzyXMLFormatComposite(node);
        if (renderContext.shouldFormat()) {
            renderContext.outdent();
            if (renderContext.isShowNewlines()) {
                boolean bufferHasBreakingEnd;
                boolean append_newline = false;
                boolean append_space = false;
                boolean bl = bufferHasBreakingEnd = WOHTMLRenderDelegate.hasWhiteSpaceEnd(xmlBuffer) || WOHTMLRenderDelegate.hasTagEnd(xmlBuffer);
                if (!WOHTMLRenderDelegate.isPreBlock(_node) && !this.isSticky(_node) && _node.isBreaking() && bufferHasBreakingEnd && _node.getParentNode().isBreaking()) {
                    append_newline = true;
                }
                if (this.lastNodeWasHiddenText()) {
                    append_space = true;
                }
                if (append_newline) {
                    if (!WOHTMLRenderDelegate.hasNewLineEnd(xmlBuffer)) {
                        xmlBuffer.append("\n");
                    }
                    renderContext.appendIndent(xmlBuffer);
                } else if (append_space) {
                    xmlBuffer.append(" ");
                }
            }
        }
    }

    public boolean beforeOpenTag(FuzzyXMLNode node, RenderContext renderContext, StringBuffer xmlBuffer) {
        FuzzyXMLFormatComposite _node = new FuzzyXMLFormatComposite(node);
        if (renderContext.isShowNewlines() && renderContext.shouldFormat()) {
            boolean append_newline = false;
            boolean append_space = false;
            if ((!this.isSticky(_node.getParentNode()) || this.lastNodeWasHiddenText()) && WOHTMLRenderDelegate.hasTagEnd(xmlBuffer)) {
                if (_node.getParentNode().isBreaking()) {
                    append_newline = true;
                }
                if (this.lastNodeWasHiddenText()) {
                    if (_node.isBreaking()) {
                        append_newline = true;
                    } else {
                        append_space = true;
                    }
                }
                if (_node.getParentNode().isDocumentRoot()) {
                    append_newline = true;
                }
            }
            if (WOHTMLRenderDelegate.isText(this.lastNode) && !this.lastNodeWasHiddenText() && _node.getParentNode().isBreaking() && WOHTMLRenderDelegate.hasWhiteSpaceEnd(xmlBuffer)) {
                append_newline = true;
            }
            if (append_newline) {
                if (!WOHTMLRenderDelegate.hasNewLineEnd(xmlBuffer)) {
                    xmlBuffer.append("\n");
                }
                renderContext.appendIndent(xmlBuffer);
            } else if (append_space) {
                xmlBuffer.append(" ");
            }
        }
        return true;
    }

    public void beforeRender(RenderContext renderContext, StringBuffer xmlBuffer) {
    }

    public boolean renderNode(FuzzyXMLNode node, RenderContext renderContext, StringBuffer xmlBuffer) {
        boolean bufferHasBreakingEnd;
        FuzzyXMLFormatComposite _node = new FuzzyXMLFormatComposite(node);
        boolean append_newline = false;
        boolean append_space = false;
        boolean bl = bufferHasBreakingEnd = WOHTMLRenderDelegate.hasWhiteSpaceEnd(xmlBuffer) || WOHTMLRenderDelegate.hasTagEnd(xmlBuffer);
        if (_node.isHidden()) {
            this.lastNode = _node;
            return false;
        }
        if (renderContext.shouldFormat() && renderContext.isShowNewlines()) {
            if (!this.isSticky(this.lastNode) || !_node.isElement()) {
                if (_node.isText()) {
                    if ((_node.hasBreakingStart() || this.lastNodeWasHiddenText()) && (_node.parentNode().isBreaking() || WOHTMLRenderDelegate.lineIsTooLong(xmlBuffer))) {
                        append_newline = true;
                    }
                } else if (bufferHasBreakingEnd && _node.parentNode().isBreaking() && this.lastNode.isHidden()) {
                    append_newline = true;
                }
            }
            if (append_newline) {
                if (!WOHTMLRenderDelegate.hasNewLineEnd(xmlBuffer)) {
                    xmlBuffer.append("\n");
                }
                renderContext.appendIndent(xmlBuffer);
            } else if (append_space) {
                xmlBuffer.append(" ");
            }
            if (_node.isText() && _node.hasLineBreaks()) {
                this.renderTextBlock((FuzzyXMLText)node, renderContext, xmlBuffer);
                this.lastNode = _node;
                return false;
            }
        }
        if (!_node.isElement()) {
            this.lastNode = _node;
        }
        return true;
    }

    private void renderTextBlock(FuzzyXMLText node, RenderContext renderContext, StringBuffer xmlBuffer) {
        FuzzyXMLFormatComposite _node = new FuzzyXMLFormatComposite(node);
        StringBuffer indent = new StringBuffer();
        renderContext.appendIndent(indent);
        xmlBuffer.append(node.getValue().trim().replaceAll("\n\\s*", "\n" + indent.toString()));
        if (_node.hasBreakingEnd()) {
            if (_node.hasLineBreaks()) {
                xmlBuffer.append("\n");
            } else {
                xmlBuffer.append(" ");
            }
        }
    }

    private static boolean hasTagEnd(StringBuffer xmlBuffer) {
        if (xmlBuffer.length() == 0) {
            return false;
        }
        return xmlBuffer.charAt(xmlBuffer.length() - 1) == '>';
    }

    private static boolean hasNewLineEnd(StringBuffer xmlBuffer) {
        if (xmlBuffer.length() == 0) {
            return false;
        }
        return xmlBuffer.charAt(xmlBuffer.length() - 1) == '\n';
    }

    private static boolean hasWhiteSpaceEnd(StringBuffer xmlBuffer) {
        if (xmlBuffer.length() == 0) {
            return false;
        }
        return Character.isWhitespace(xmlBuffer.charAt(xmlBuffer.length() - 1));
    }

    private boolean lastNodeWasHiddenText() {
        return this.lastNode == null || this.lastNode.isText() && this.lastNode.isHidden();
    }

    private boolean _isStickyTag(FuzzyXMLFormatComposite node) {
        return STICKY_TAGS.contains(node.getName().toLowerCase()) || this.useStickyWOTags && node.isWOTag();
    }

    private boolean isSticky(FuzzyXMLFormatComposite node) {
        return !this.lastNodeWasHiddenText() && this._isStickyTag(node);
    }

    private static boolean isPreBlock(FuzzyXMLFormatComposite node) {
        return "pre".equalsIgnoreCase(node.getName());
    }

    private static boolean lineIsTooLong(StringBuffer xmlBuffer) {
        int lastLineStart = xmlBuffer.lastIndexOf("\n");
        String line = lastLineStart == -1 ? xmlBuffer.toString() : xmlBuffer.substring(lastLineStart);
        return line.length() > 120;
    }

    private static boolean isText(FuzzyXMLFormatComposite node) {
        if (node == null) {
            return false;
        }
        return node.isText();
    }

    static {
        SPACE_EFFECTED_TAGS = new String[]{"a", "img", "u"};
        STICKY_TAGS = new HashSet<String>();
        STICKY_TAGS.addAll(Arrays.asList(SPACE_EFFECTED_TAGS));
    }
}

