/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.csseditor.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class CSSRule
implements IPredicateRule {
    private IToken propToken;
    private IToken valueToken;

    public CSSRule(IToken propToken, IToken valueToken) {
        this.propToken = propToken;
        this.valueToken = valueToken;
    }

    private boolean sequenceDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        for (int i = 1; i < sequence.length; ++i) {
            int c = scanner.read();
            if (c == -1 && eofAllowed) {
                return true;
            }
            if (c == sequence[i]) continue;
            scanner.unread();
            for (int j = i - 1; j > 0; --j) {
                scanner.unread();
            }
            return false;
        }
        return true;
    }

    private IToken getToken(ICharacterScanner scanner) {
        int c;
        char[][] delimiters = scanner.getLegalLineDelimiters();
        while ((c = scanner.read()) != -1) {
            if (c == 58) {
                return this.propToken;
            }
            if (c == 59) {
                return this.valueToken;
            }
            for (int i = 0; i < delimiters.length; ++i) {
                if (c != delimiters[i][0] || !this.sequenceDetected(scanner, delimiters[i], true)) continue;
                return null;
            }
        }
        scanner.unread();
        return null;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.doEvaluate(scanner, resume);
    }

    private IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        if (resume) {
            IToken token = this.getToken(scanner);
            if (token != null) {
                return token;
            }
        } else {
            IToken token;
            int c = scanner.read();
            if (c != 32 && c != 9 && c != 13 && c != 10 && (token = this.getToken(scanner)) != null) {
                return token;
            }
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    public IToken getSuccessToken() {
        return null;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }
}

