/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.tasktag;

import jp.aonir.fuzzyxml.FuzzyXMLComment;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import tk.eclipse.plugin.htmleditor.tasktag.AbstractTaskTagDetector;

public class HTMLTaskTagDetector
extends AbstractTaskTagDetector {
    public HTMLTaskTagDetector() {
        this.addSupportedExtension("html");
        this.addSupportedExtension("htm");
        this.addSupportedExtension("xml");
        this.addSupportedExtension("tld");
        this.addSupportedExtension("xsd");
        this.addSupportedExtension("jsp");
        this.addSupportedExtension("jspf");
        this.addSupportedExtension("jspx");
    }

    public void doDetect() throws Exception {
        FuzzyXMLDocument doc = new FuzzyXMLParser(false).parse(this._contents);
        this.processElement(doc.getDocumentElement());
    }

    private void processElement(FuzzyXMLElement element) {
        FuzzyXMLNode[] children = element.getChildren();
        for (int i = 0; i < children.length; ++i) {
            String value;
            if (children[i] instanceof FuzzyXMLElement) {
                this.processElement((FuzzyXMLElement)children[i]);
                continue;
            }
            if (children[i] instanceof FuzzyXMLComment) {
                this.detectTaskTag(((FuzzyXMLComment)children[i]).getValue(), children[i].getOffset());
                continue;
            }
            if (!(children[i] instanceof FuzzyXMLText) || !(value = ((FuzzyXMLText)children[i]).getValue()).startsWith("<%--")) continue;
            if (value.endsWith("--%>")) {
                value = value.substring(0, value.length() - 4);
            }
            this.detectTaskTag(value, children[i].getOffset());
        }
    }
}

