/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jseditor.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tk.eclipse.plugin.jseditor.editors.JavaScriptComment;
import tk.eclipse.plugin.jseditor.editors.JavaScriptContext;
import tk.eclipse.plugin.jseditor.editors.JavaScriptElement;
import tk.eclipse.plugin.jseditor.editors.JavaScriptFunction;
import tk.eclipse.plugin.jseditor.editors.JavaScriptVariable;

public class JavaScriptModel
implements JavaScriptContext {
    private List<JavaScriptElement> _children = new ArrayList<JavaScriptElement>();
    private List<JavaScriptComment> _comments = new ArrayList<JavaScriptComment>();
    private JavaScriptContext _context;
    private int _endOffset;

    public JavaScriptModel(String source) {
        this.update(source);
    }

    public int getStartOffset() {
        return 0;
    }

    public int getEndOffset() {
        return this._endOffset;
    }

    public JavaScriptContext getContextFromOffset(int offset) {
        return this.getContextFromOffset(this, offset);
    }

    private JavaScriptContext getContextFromOffset(JavaScriptContext context, int offset) {
        if (context.getStartOffset() < offset && context.getEndOffset() > offset) {
            JavaScriptElement[] children = context.getChildren();
            for (int i = 0; i < children.length; ++i) {
                JavaScriptContext result;
                if (!(children[i] instanceof JavaScriptContext) || (result = this.getContextFromOffset((JavaScriptContext)((Object)children[i]), offset)) == null) continue;
                return result;
            }
            return context;
        }
        return this;
    }

    public void update(String source) {
        this._children.clear();
        this._comments.clear();
        this._endOffset = source.length();
        this._context = this;
        boolean whitespace = true;
        char quote = '\u0000';
        boolean escape = false;
        for (int i = 0; i < source.length(); ++i) {
            int result;
            char c = source.charAt(i);
            if (c == '\"' || c == '\'') {
                if (!escape) {
                    quote = quote == c ? (char)'\u0000' : c;
                }
                escape = false;
                continue;
            }
            if (quote != '\u0000') {
                escape = c == '\\';
                continue;
            }
            if (c == '/' && source.length() > i + 1) {
                int start;
                char nc = source.charAt(i + 1);
                if (nc == '/') {
                    start = i;
                    while (nc != '\r' && nc != '\n' && source.length() > i) {
                        nc = source.charAt(++i + 1);
                    }
                    this._comments.add(new JavaScriptComment(start, i + 1, source.substring(start, i + 1)));
                }
                if (nc == '*') {
                    start = i;
                    if ((i = source.indexOf("*/", i)) == -1) break;
                    this._comments.add(new JavaScriptComment(start, i + 2, source.substring(start, i + 2)));
                }
            }
            if (whitespace && c == 'v' && (result = JavaScriptModel.parseVariable(source, i, this._context)) != 0) {
                whitespace = true;
                i += result;
                continue;
            }
            if (whitespace && c == 'f' && (result = JavaScriptModel.parseFunction(source, i, this._context)) != null) {
                whitespace = true;
                i += ((Integer)result[0]).intValue();
                this._context = (JavaScriptFunction)result[1];
                continue;
            }
            if (c == '}' && this._context.getParent() != null) {
                if (this._context instanceof JavaScriptFunction) {
                    ((JavaScriptFunction)this._context).setEndOffset(i);
                }
                this._context = this._context.getParent();
            }
            whitespace = c == ' ' || c == '\t' || c == '\r' || c == '\n';
        }
    }

    private static int parseVariable(String source, int position, JavaScriptContext context) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("var[\\s\r\n]+(.+?)[\\s\r\n]*?[;=]");
        if (source.indexOf("var", position) == position && (matcher = pattern.matcher(source.substring(position))).find() && matcher.start() == 0) {
            JavaScriptVariable var = new JavaScriptVariable(matcher.group(1), position);
            context.add(var);
            return matcher.end();
        }
        return 0;
    }

    private static Object[] parseFunction(String source, int position, JavaScriptContext context) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("function[\\s\r\n]+?(.+?)[\\s\r\n]*?\\((.*?)\\)[\\s\r\n]*?\\{", 32);
        if (source.indexOf("function", position) == position && (matcher = pattern.matcher(source.substring(position))).find() && matcher.start() == 0) {
            String args = matcher.group(2).replaceAll("[\\s\r\n]*,[\\s\r\n]*", ", ").trim();
            JavaScriptFunction func = new JavaScriptFunction(matcher.group(1), args, position);
            func.setParent(context);
            context.add(func);
            return new Object[]{matcher.end(), func};
        }
        return null;
    }

    public void add(JavaScriptFunction func) {
        this._children.add(func);
    }

    public void add(JavaScriptVariable var) {
        this._children.add(var);
    }

    public JavaScriptElement[] getChildren() {
        return this._children.toArray(new JavaScriptElement[this._children.size()]);
    }

    public JavaScriptElement[] getVisibleElements() {
        return this.getChildren();
    }

    public JavaScriptContext getParent() {
        return null;
    }

    public JavaScriptComment[] getComments() {
        return this._comments.toArray(new JavaScriptComment[this._comments.size()]);
    }
}

