/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.editors.HTMLConfiguration;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;
import tk.eclipse.plugin.jspeditor.editors.JSPAutoEditStrategy;
import tk.eclipse.plugin.jspeditor.editors.JSPConfiguration;
import tk.eclipse.plugin.jspeditor.editors.JSPDirectiveAssistProcessor;
import tk.eclipse.plugin.jspeditor.editors.JSPOutlinePage;
import tk.eclipse.plugin.jspeditor.editors.JSPScriptletAssistProcessor;
import tk.eclipse.plugin.jspeditor.editors.JSPValidator;

public class JSPSourceEditor
extends HTMLSourceEditor {
    public static final String ACTION_JSP_COMMENT = "_jsp_comment";
    public static final String ACTION_TOGGLE_BREAKPOINT = "_jsp_toggle_breakpoint";

    public JSPSourceEditor(HTMLConfiguration config) {
        super(config);
        this.setAction(ACTION_JSP_COMMENT, (IAction)new JSPCommentAction());
        this.setAction(ACTION_TOGGLE_BREAKPOINT, (IAction)new ToggleBreakPointAction());
    }

    protected void doValidate() {
        try {
            String[] natureIds = HTMLPlugin.getDefault().getNoValidationNatureId();
            final IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            for (int i = 0; i < natureIds.length; ++i) {
                if (!file.getProject().hasNature(natureIds[i])) continue;
                return;
            }
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        file.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                        HTMLProjectParams params = new HTMLProjectParams(file.getProject());
                        if (params.getValidateJSP()) {
                            new JSPValidator(file).doValidate();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    protected IHTMLOutlinePage createOutlinePage() {
        return new JSPOutlinePage(this);
    }

    protected void addContextMenuActions(IMenuManager menu) {
        super.addContextMenuActions(menu);
        this.addAction(menu, "_html", ACTION_JSP_COMMENT);
    }

    protected void updateSelectionDependentActions() {
        super.updateSelectionDependentActions();
        ITextSelection sel = (ITextSelection)this.getSelectionProvider().getSelection();
        if (sel.getText().equals("")) {
            this.getAction(ACTION_JSP_COMMENT).setEnabled(false);
        } else {
            this.getAction(ACTION_JSP_COMMENT).setEnabled(true);
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        menu.add(this.getAction(ACTION_TOGGLE_BREAKPOINT));
        super.rulerContextMenuAboutToShow(menu);
    }

    protected void updateAssist() {
        super.updateAssist();
        JSPConfiguration config = (JSPConfiguration)this.getSourceViewerConfiguration();
        JSPDirectiveAssistProcessor directiveProcessor = config.getDirectiveAssistProcessor();
        directiveProcessor.update(this);
        JSPScriptletAssistProcessor scriptletProcessor = config.getScriptletAssistProcessor();
        scriptletProcessor.update(this);
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            JSPAutoEditStrategy autoEdit = (JSPAutoEditStrategy)config.getAutoEditStrategy();
            autoEdit.setFile(((IFileEditorInput)input).getFile());
        }
    }

    private class ToggleBreakPointAction
    extends Action {
        public ToggleBreakPointAction() {
            super(HTMLPlugin.getResourceString("JSPEditor.ToggleBreakPoint"));
            this.setEnabled(true);
        }

        public void run() {
            IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] breakpoints = manager.getBreakpoints();
            IEditorInput input = JSPSourceEditor.this.getEditorInput();
            IResource resource = (IResource)input.getAdapter(IFile.class);
            if (resource == null) {
                resource = (IResource)input.getAdapter(IResource.class);
            }
            int lineNumber = JSPSourceEditor.this.getVerticalRuler().getLineOfLastMouseButtonActivity() + 1;
            for (int i = 0; i < breakpoints.length; ++i) {
                IJavaStratumLineBreakpoint breakpoint;
                if (!(breakpoints[i] instanceof IJavaStratumLineBreakpoint) || !(breakpoint = (IJavaStratumLineBreakpoint)breakpoints[i]).getMarker().getResource().equals((Object)resource)) continue;
                try {
                    if (breakpoint.getLineNumber() != lineNumber) continue;
                    breakpoint.delete();
                    return;
                }
                catch (Exception ex) {
                    HTMLPlugin.logException(ex);
                }
            }
            try {
                int pos = this.getValidPosition(JSPSourceEditor.this.getViewer().getDocument(), lineNumber);
                System.out.println(pos);
                JDIDebugModel.createStratumBreakpoint((IResource)resource, (String)"JSP", (String)resource.getName(), null, (String)"*", (int)lineNumber, (int)pos, (int)pos, (int)0, (boolean)true, null);
            }
            catch (Exception ex) {
                HTMLPlugin.logException(ex);
            }
        }

        private int getValidPosition(IDocument idoc, int editorLineNumber) {
            int result = -1;
            if (idoc != null) {
                int startOffset = 0;
                int endOffset = 0;
                try {
                    IRegion line = idoc.getLineInformation(editorLineNumber - 1);
                    startOffset = line.getOffset();
                    endOffset = Math.max(line.getOffset(), line.getOffset() + line.getLength());
                    String lineText = idoc.get(startOffset, endOffset - startOffset).trim();
                    if (lineText.equals("") || lineText.equals("{") || lineText.equals("}") || lineText.equals("<%")) {
                        result = -1;
                    } else {
                        ITypedRegion[] partitions = null;
                        partitions = idoc.computePartitioning(startOffset, endOffset - startOffset);
                        for (int i = 0; i < partitions.length; ++i) {
                            String type = partitions[i].getType();
                            if (type != "__html_comment" && type != "__html_directive") continue;
                            result = partitions[i].getOffset();
                        }
                    }
                }
                catch (BadLocationException e) {
                    result = -1;
                }
            }
            return result;
        }
    }

    private class JSPCommentAction
    extends Action {
        public JSPCommentAction() {
            super(HTMLPlugin.getResourceString("HTMLEditor.JSPCommentAction"));
            this.setEnabled(false);
            this.setAccelerator(327727);
        }

        public void run() {
            ITextSelection sel = (ITextSelection)JSPSourceEditor.this.getSelectionProvider().getSelection();
            IDocument doc = JSPSourceEditor.this.getDocumentProvider().getDocument((Object)JSPSourceEditor.this.getEditorInput());
            String text = sel.getText().trim();
            try {
                if (text.startsWith("<%--") && text.endsWith("--%>")) {
                    text = sel.getText().replaceAll("<%--|--%>", "");
                    doc.replace(sel.getOffset(), sel.getLength(), text);
                } else {
                    doc.replace(sel.getOffset(), sel.getLength(), "<%--" + sel.getText() + "--%>");
                }
            }
            catch (BadLocationException e) {
                HTMLPlugin.logException(e);
            }
        }
    }
}

