/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;

public class ClassNameAssistProcessor {
    public AssistInfo[] getClassAttributeValues(IFile file, String value) {
        if (value.length() == 0) {
            return new AssistInfo[0];
        }
        try {
            IJavaProject project = JavaCore.create((IProject)file.getProject());
            CompletionProposalCollector collector = new CompletionProposalCollector(project);
            ICompilationUnit unit = HTMLUtil.getTemporaryCompilationUnit(project);
            String source = "public class _xxx { public static void hoge(){ " + value + "}}";
            HTMLUtil.setContentsToCU(unit, source);
            unit.codeComplete(source.length() - 2, (CompletionRequestor)collector, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
            IJavaCompletionProposal[] proposals = collector.getJavaCompletionProposals();
            ArrayList<JavaClassAssistInfo> result = new ArrayList<JavaClassAssistInfo>();
            for (int j = 0; j < proposals.length; ++j) {
                LazyJavaTypeCompletionProposal p;
                if (proposals[j].getImage() == null) continue;
                if (proposals[j] instanceof LazyJavaTypeCompletionProposal) {
                    p = (LazyJavaTypeCompletionProposal)proposals[j];
                    if (!p.getReplacementString().startsWith(value)) continue;
                    result.add(new JavaClassAssistInfo((AbstractJavaCompletionProposal)p));
                    continue;
                }
                if (!(proposals[j] instanceof JavaCompletionProposal) || !(p = (JavaCompletionProposal)proposals[j]).getReplacementString().startsWith(value)) continue;
                result.add(new JavaClassAssistInfo((AbstractJavaCompletionProposal)p));
            }
            return result.toArray(new AssistInfo[result.size()]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new AssistInfo[0];
        }
    }

    private class JavaClassAssistInfo
    extends AssistInfo {
        private AbstractJavaCompletionProposal proposal;

        public JavaClassAssistInfo(AbstractJavaCompletionProposal proposal) {
            super("");
            this.proposal = proposal;
        }

        public String getDisplayString() {
            return this.proposal.getDisplayString();
        }

        public Image getImage() {
            return this.proposal.getImage();
        }

        public String getReplaceString() {
            return this.proposal.getReplacementString();
        }

        public ICompletionProposal toCompletionProposal(int offset, String matchString, Image defaultImage) {
            this.proposal.setReplacementOffset(offset - matchString.length());
            this.proposal.setReplacementLength(matchString.length());
            this.proposal.setCursorPosition(this.proposal.getReplacementString().length());
            return this.proposal;
        }
    }
}

